/*
 * Decompiled with CFR 0.152.
 */
package org.dataconservancy.pass.authz;

import java.net.URI;
import java.time.Duration;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.dataconservancy.pass.authz.AuthUser;
import org.dataconservancy.pass.authz.AuthUserProvider;
import org.dataconservancy.pass.authz.ConfigUtil;
import org.dataconservancy.pass.authz.ExpiringLRUCache;
import org.dataconservancy.pass.client.PassClient;
import org.dataconservancy.pass.model.User;
import org.dataconservancy.pass.model.support.Identifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShibAuthUserProvider
implements AuthUserProvider {
    public static final String CONFIG_SHIB_USE_HEADERS = "authz.shib.use.headers";
    public static final String CONFIG_SHIB_CACHE_LIFE = "authz.shib.cache.minutes";
    public static final String CONFIG_SHIB_CACHE_SIZE = "authz.shib.cache.size";
    Logger LOG = LoggerFactory.getLogger(ShibAuthUserProvider.class);
    public static final String DISPLAY_NAME_HEADER = "Displayname";
    public static final String EMAIL_HEADER = "Mail";
    public static final String EPPN_HEADER = "Eppn";
    public static final String SCOPED_AFFILIATION_HEADER = "Affiliation";
    public static final String EMPLOYEE_ID_HEADER = "Employeenumber";
    public static final String HOPKINS_ID_HEADER = "unique-id";
    public static final String EMPLOYEE_ID_TYPE = "employeeid";
    public static final String HOPKINS_ID_TYPE = "hopkinsid";
    public static final String JHED_ID_TYPE = "jhed";
    final PassClient passClient;
    final ExpiringLRUCache<String, User> userCache;
    boolean useShibHeaders = Optional.ofNullable(ConfigUtil.getValue("authz.shib.use.headers")).map(Boolean::valueOf).orElse(false);

    public ShibAuthUserProvider(PassClient client) {
        this.passClient = client;
        int minutes = Integer.valueOf(Optional.ofNullable(ConfigUtil.getValue(CONFIG_SHIB_CACHE_LIFE)).orElse("10"));
        int size = Integer.valueOf(Optional.ofNullable(ConfigUtil.getValue(CONFIG_SHIB_CACHE_SIZE)).orElse("100"));
        this.userCache = new ExpiringLRUCache(size, Duration.ofMinutes(minutes));
    }

    public ShibAuthUserProvider(PassClient client, ExpiringLRUCache<String, User> cache) {
        this.passClient = client;
        this.userCache = cache;
    }

    @Override
    public AuthUser getUser(HttpServletRequest request, Function<AuthUser, AuthUser> doAfter, boolean allowCached) {
        if (this.LOG.isDebugEnabled() && request != null) {
            this.LOG.debug("Request headers: ");
            Enumeration headerNames = request.getHeaderNames();
            if (headerNames != null) {
                while (headerNames.hasMoreElements()) {
                    String name = (String)headerNames.nextElement();
                    this.LOG.debug("   " + name + ": " + request.getHeader(name));
                }
            }
        }
        String displayName = this.getShibAttr(request, DISPLAY_NAME_HEADER, String::trim);
        String emailAddress = this.getShibAttr(request, EMAIL_HEADER, String::trim);
        String domain = this.getShibAttr(request, EPPN_HEADER, s -> s.split("@")[1]);
        String institutionalId = this.getShibAttr(request, EPPN_HEADER, s -> s.split("@")[0]);
        if (institutionalId != null && !institutionalId.isEmpty()) {
            institutionalId = new Identifier(domain, JHED_ID_TYPE, institutionalId.toLowerCase()).serialize();
        }
        String employeeId = new Identifier(domain, EMPLOYEE_ID_TYPE, this.getShibAttr(request, EMPLOYEE_ID_HEADER, e -> e)).serialize();
        String hopkinsId = new Identifier(domain, HOPKINS_ID_TYPE, this.getShibAttr(request, HOPKINS_ID_HEADER, s -> s.split("@")[0])).serialize();
        String cacheLookupId = null;
        AuthUser authUser = new AuthUser();
        authUser.setName(displayName);
        authUser.setEmail(emailAddress);
        if (hopkinsId != null) {
            authUser.getLocatorIds().add(hopkinsId);
            cacheLookupId = hopkinsId;
        }
        if (employeeId != null) {
            authUser.getLocatorIds().add(employeeId);
        }
        if (institutionalId != null) {
            authUser.getLocatorIds().add(institutionalId);
        }
        authUser.setPrincipal(this.getShibAttr(request, EPPN_HEADER, s -> s));
        Optional.ofNullable(authUser.getPrincipal()).filter(s -> s.contains("@")).map(s -> s.split("@")[1]).ifPresent(authUser.getDomains()::add);
        authUser.getDomains().addAll(Arrays.stream((Object[])Optional.ofNullable(this.getShibAttr(request, SCOPED_AFFILIATION_HEADER, s -> s.split(";"))).orElse(new String[0])).filter(sa -> sa.contains("@")).map(sa -> sa.split("@")[1]).collect(Collectors.toSet()));
        if (cacheLookupId != null) {
            this.LOG.debug("Looking up User based on hopkins id '{}'", (Object)cacheLookupId);
            try {
                Callable<User> criticalSection = () -> {
                    authUser.setId(this.findUserId(authUser.getLocatorIds()));
                    AuthUser filtered = (AuthUser)doAfter.apply(authUser);
                    if (filtered.getUser() != null) {
                        this.LOG.debug("doAfter filter supplied a User resource");
                        return filtered.getUser();
                    }
                    this.LOG.debug("doAfter filter did NOT supply a User resource");
                    return null;
                };
                if (allowCached) {
                    authUser.setUser(this.userCache.getOrDo(hopkinsId, criticalSection));
                } else {
                    authUser.setUser(this.userCache.doAndCache(hopkinsId, criticalSection));
                }
                if (authUser.getUser() != null) {
                    authUser.setId(authUser.getUser().getId());
                }
                this.LOG.debug("User resource for {} is {}", (Object)hopkinsId, (Object)authUser.getId());
            }
            catch (Exception e2) {
                throw new RuntimeException("Error while looking up user by locatorIds" + authUser.getLocatorIds().toString(), e2);
            }
        } else {
            this.LOG.debug("No shibboleth hopkins id; skipping user lookup ");
        }
        return authUser;
    }

    private URI findUserId(List<String> locatorIdList) {
        URI userURI = null;
        ListIterator<String> idIterator = locatorIdList.listIterator();
        while (userURI == null && idIterator.hasNext()) {
            String locatorId = String.valueOf(idIterator.next());
            if (locatorId == null) continue;
            userURI = this.passClient.findByAttribute(User.class, "locatorIds", (Object)locatorId);
        }
        return userURI;
    }

    private <T> T getShibAttr(HttpServletRequest request, String name, Function<String, T> transform) {
        T value = this.transform(Optional.ofNullable(request.getAttribute(name)).map(Object::toString).orElse(this.useShibHeaders ? request.getHeader(name) : null), transform);
        this.LOG.debug("Shib attribute {} is {}", (Object)name, value);
        return value;
    }

    private <T> T transform(String value, Function<String, T> transform) {
        return Optional.ofNullable(value).map(transform).orElse(null);
    }
}

