/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jdo;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.jdo.Extent;
import javax.jdo.JDOException;
import javax.jdo.JDOFatalUserException;
import javax.jdo.JDONullIdentityException;
import javax.jdo.JDOOptimisticVerificationException;
import javax.jdo.JDOUnsupportedOptionException;
import javax.jdo.JDOUserException;
import javax.jdo.ObjectState;
import javax.jdo.PersistenceManager;
import javax.jdo.datastore.JDOConnection;
import javax.jdo.datastore.Sequence;
import javax.jdo.listener.InstanceLifecycleListener;
import javax.jdo.spi.PersistenceCapable;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.FetchGroup;
import org.datanucleus.FetchPlan;
import org.datanucleus.ObjectManager;
import org.datanucleus.ObjectManagerImpl;
import org.datanucleus.Transaction;
import org.datanucleus.api.jdo.JDOConnectionImpl;
import org.datanucleus.api.jdo.JDOExtent;
import org.datanucleus.api.jdo.JDOFetchGroup;
import org.datanucleus.api.jdo.JDOFetchPlan;
import org.datanucleus.api.jdo.JDOPersistenceManagerFactory;
import org.datanucleus.api.jdo.JDOQuery;
import org.datanucleus.api.jdo.JDOSequence;
import org.datanucleus.api.jdo.JDOTransaction;
import org.datanucleus.api.jdo.LifecycleListenerForClass;
import org.datanucleus.api.jdo.NucleusJDOHelper;
import org.datanucleus.api.jdo.exceptions.TransactionNotActiveException;
import org.datanucleus.api.jdo.exceptions.TransactionNotWritableException;
import org.datanucleus.api.jdo.query.JDOTypesafeQuery;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusOptimisticException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.exceptions.TransactionActiveOnCloseException;
import org.datanucleus.identity.SCOID;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.ExtensionMetaData;
import org.datanucleus.metadata.FetchGroupMetaData;
import org.datanucleus.metadata.FetchPlanMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.QueryLanguage;
import org.datanucleus.metadata.QueryMetaData;
import org.datanucleus.metadata.SequenceMetaData;
import org.datanucleus.query.typesafe.TypesafeQuery;
import org.datanucleus.state.DetachState;
import org.datanucleus.state.FetchPlanState;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.NucleusConnection;
import org.datanucleus.store.NucleusSequence;
import org.datanucleus.store.query.Query;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDOPersistenceManager
implements PersistenceManager {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.Localisation", (ClassLoader)ObjectManager.class.getClassLoader());
    protected static final Localiser LOCALISER_JDO = Localiser.getInstance((String)"org.datanucleus.api.jdo.Localisation", (ClassLoader)JDOPersistenceManager.class.getClassLoader());
    public static final NucleusLogger LOGGER = NucleusLogger.getLoggerInstance((String)"DataNucleus.JDO");
    private Map userObjectMap;
    private Object userObject;
    protected ObjectManager om;
    protected javax.jdo.Transaction jdotx;
    protected JDOPersistenceManagerFactory pmf;
    protected JDOFetchPlan fetchPlan = null;
    private Set<JDOFetchGroup> jdoFetchGroups = null;

    public JDOPersistenceManager(JDOPersistenceManagerFactory apmf, String userName, String password) {
        this.om = new ObjectManagerImpl(apmf.getNucleusContext(), (Object)this, userName, password);
        this.pmf = apmf;
        this.userObject = null;
        this.userObjectMap = null;
        this.fetchPlan = new JDOFetchPlan(this.om.getFetchPlan());
        this.setTransaction(this.om.getTransaction());
    }

    public ObjectManager getObjectManager() {
        return this.om;
    }

    public JDOPersistenceManagerFactory getPersistenceManagerFactory() {
        return this.pmf;
    }

    public boolean getDetachAllOnCommit() {
        if (this.om.isClosed()) {
            throw new JDOFatalUserException(LOCALISER.msg("010002"));
        }
        return (Boolean)this.om.getProperty("datanucleus.DetachAllOnCommit");
    }

    public boolean getCopyOnAttach() {
        if (this.om.isClosed()) {
            throw new JDOFatalUserException(LOCALISER.msg("010002"));
        }
        return (Boolean)this.om.getProperty("datanucleus.CopyOnAttach");
    }

    public javax.jdo.FetchPlan getFetchPlan() {
        return this.fetchPlan;
    }

    public boolean getIgnoreCache() {
        if (this.om.isClosed()) {
            throw new JDOFatalUserException(LOCALISER.msg("010002"));
        }
        return (Boolean)this.om.getProperty("datanucleus.IgnoreCache");
    }

    public boolean getMultithreaded() {
        if (this.om.isClosed()) {
            throw new JDOFatalUserException(LOCALISER.msg("010002"));
        }
        return (Boolean)this.om.getProperty("datanucleus.Multithreaded");
    }

    public void setDetachAllOnCommit(boolean flag) {
        this.om.setProperty("datanucleus.DetachAllOnCommit", (Object)flag);
    }

    public void setCopyOnAttach(boolean flag) {
        this.om.setProperty("datanucleus.CopyOnAttach", (Object)flag);
    }

    public void setIgnoreCache(boolean flag) {
        this.om.setProperty("datanucleus.IgnoreCache", (Object)flag);
    }

    public void setMultithreaded(boolean flag) {
        this.om.setProperty("datanucleus.Multithreaded", (Object)flag);
    }

    public void setDatastoreReadTimeoutMillis(Integer timeout) {
        if (!this.om.getStoreManager().getSupportedOptions().contains("Datastore.Timeout")) {
            throw new JDOUnsupportedOptionException("This datastore doesn't support read timeouts");
        }
        this.om.setProperty("datanucleus.datastoreReadTimeout", (Object)timeout);
    }

    public Integer getDatastoreReadTimeoutMillis() {
        return (Integer)this.om.getProperty("datanucleus.datastoreReadTimeout");
    }

    public void setDatastoreWriteTimeoutMillis(Integer timeout) {
        if (!this.om.getStoreManager().getSupportedOptions().contains("Datastore.Timeout")) {
            throw new JDOUnsupportedOptionException("This datastore doesn't support write timeouts");
        }
        this.om.setProperty("datanucleus.datastoreWriteTimeout", (Object)timeout);
    }

    public Integer getDatastoreWriteTimeoutMillis() {
        return (Integer)this.om.getProperty("datanucleus.datastoreWriteTimeout");
    }

    public Date getServerDate() {
        try {
            return this.om.getStoreManager().getDatastoreDate();
        }
        catch (NucleusException ne) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(ne);
        }
    }

    public void close() {
        this.pmf.releasePersistenceManager(this);
    }

    protected void internalClose() {
        if (this.isClosed()) {
            return;
        }
        try {
            this.om.close();
        }
        catch (TransactionActiveOnCloseException tae) {
            throw new JDOUserException(tae.getMessage(), (Object)this);
        }
        catch (NucleusException ne) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(ne);
        }
        this.userObject = null;
        this.userObjectMap = null;
    }

    public boolean isClosed() {
        return this.om.isClosed();
    }

    public javax.jdo.Transaction currentTransaction() {
        this.assertIsOpen();
        return this.jdotx;
    }

    protected void setTransaction(Transaction tx) {
        this.jdotx = new JDOTransaction(this, tx);
    }

    private void jdoEvict(Object obj) {
        try {
            this.om.evictObject(obj);
        }
        catch (NucleusException ne) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(ne);
        }
    }

    public void evict(Object obj) {
        this.assertIsOpen();
        this.jdoEvict(obj);
    }

    public void evictAll(boolean subclasses, Class cls) {
        try {
            this.om.evictObjects(cls, subclasses);
        }
        catch (NucleusException ne) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(ne);
        }
    }

    public void evictAll(Object ... pcs) {
        this.evictAll(Arrays.asList(pcs));
    }

    public void evictAll(Collection pcs) {
        this.assertIsOpen();
        ArrayList<JDOException> failures = new ArrayList<JDOException>();
        Iterator i = pcs.iterator();
        while (i.hasNext()) {
            try {
                this.jdoEvict(i.next());
            }
            catch (JDOException e) {
                failures.add(e);
            }
        }
        if (!failures.isEmpty()) {
            throw new JDOUserException(LOCALISER.msg("010036"), (Throwable[])failures.toArray(new Exception[failures.size()]));
        }
    }

    public void evictAll() {
        this.assertIsOpen();
        this.om.evictAllObjects();
    }

    private void jdoRefresh(Object obj) {
        try {
            this.om.refreshObject(obj);
        }
        catch (NucleusException ne) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(ne);
        }
    }

    public void refresh(Object obj) {
        this.assertIsOpen();
        this.jdoRefresh(obj);
    }

    public void refreshAll(Object ... pcs) {
        this.refreshAll(Arrays.asList(pcs));
    }

    public void refreshAll(Collection pcs) {
        this.assertIsOpen();
        ArrayList<JDOException> failures = new ArrayList<JDOException>();
        Iterator iter = pcs.iterator();
        while (iter.hasNext()) {
            try {
                this.jdoRefresh(iter.next());
            }
            catch (JDOException e) {
                failures.add(e);
            }
        }
        if (!failures.isEmpty()) {
            throw new JDOUserException(LOCALISER.msg("010037"), (Throwable[])failures.toArray(new Exception[failures.size()]));
        }
    }

    public void refreshAll() {
        this.assertIsOpen();
        try {
            this.om.refreshAllObjects();
        }
        catch (NucleusException ne) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(ne);
        }
    }

    public void refreshAll(JDOException exc) {
        Throwable[] nested_excs;
        Object obj = exc.getFailedObject();
        if (obj != null) {
            this.refresh(obj);
        }
        if ((nested_excs = exc.getNestedExceptions()) != null) {
            for (int i = 0; i < nested_excs.length; ++i) {
                if (!(nested_excs[i] instanceof JDOException)) continue;
                this.refreshAll((JDOException)nested_excs[i]);
            }
        }
    }

    private void jdoRetrieve(Object obj, boolean useFetchPlan) {
        try {
            this.om.retrieveObject(obj, useFetchPlan);
        }
        catch (NucleusException ne) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(ne);
        }
    }

    public void retrieve(Object pc, boolean useFetchPlan) {
        this.assertIsOpen();
        this.jdoRetrieve(pc, useFetchPlan);
    }

    public void retrieve(Object pc) {
        this.retrieve(pc, false);
    }

    public void retrieveAll(Object ... pcs) {
        this.retrieveAll(Arrays.asList(pcs), false);
    }

    public void retrieveAll(Object[] pcs, boolean useFetchPlan) {
        this.retrieveAll(Arrays.asList(pcs), useFetchPlan);
    }

    public void retrieveAll(boolean useFetchPlan, Object ... pcs) {
        this.retrieveAll(Arrays.asList(pcs), useFetchPlan);
    }

    public void retrieveAll(Collection pcs, boolean useFetchPlan) {
        this.assertIsOpen();
        ArrayList<RuntimeException> failures = new ArrayList<RuntimeException>();
        Iterator i = pcs.iterator();
        while (i.hasNext()) {
            try {
                this.jdoRetrieve(i.next(), useFetchPlan);
            }
            catch (RuntimeException e) {
                failures.add(e);
            }
        }
        if (!failures.isEmpty()) {
            throw new JDOUserException(LOCALISER.msg("010038"), (Throwable[])failures.toArray(new Exception[failures.size()]));
        }
    }

    public void retrieveAll(Collection pcs) {
        this.retrieveAll(pcs, false);
    }

    private Object jdoMakePersistent(Object obj) {
        try {
            return this.om.persistObject(obj);
        }
        catch (NucleusException ne) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(ne);
        }
    }

    public Object makePersistent(Object obj) {
        this.assertIsOpen();
        this.assertWritable();
        if (obj == null) {
            return null;
        }
        return this.jdoMakePersistent(obj);
    }

    public Object[] makePersistentAll(Object ... pcs) {
        return this.makePersistentAll(Arrays.asList(pcs)).toArray();
    }

    public Collection makePersistentAll(Collection pcs) {
        this.assertIsOpen();
        this.assertWritable();
        try {
            Object[] persistedPcs = this.om.persistObjects(pcs.toArray());
            ArrayList<Object> persisted = new ArrayList<Object>();
            for (int i = 0; i < persistedPcs.length; ++i) {
                persisted.add(persistedPcs[i]);
            }
            return persisted;
        }
        catch (NucleusUserException nue) {
            Throwable[] failures = nue.getNestedExceptions();
            throw new JDOUserException(LOCALISER.msg("010039"), failures);
        }
    }

    private void jdoDeletePersistent(Object obj) {
        try {
            this.om.deleteObject(obj);
        }
        catch (NucleusException ne) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(ne);
        }
    }

    public void deletePersistent(Object obj) {
        this.assertIsOpen();
        this.assertWritable();
        this.jdoDeletePersistent(obj);
    }

    public void deletePersistentAll(Object ... pcs) {
        this.deletePersistentAll(Arrays.asList(pcs));
    }

    public void deletePersistentAll(Collection pcs) {
        this.assertIsOpen();
        this.assertWritable();
        try {
            this.om.deleteObjects(pcs.toArray());
        }
        catch (NucleusUserException nue) {
            Throwable[] failures = nue.getNestedExceptions();
            throw new JDOUserException(LOCALISER.msg("010040"), failures);
        }
    }

    private void jdoMakeTransient(Object pc, FetchPlanState state) {
        try {
            this.om.makeObjectTransient(pc, state);
        }
        catch (NucleusException ne) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(ne);
        }
    }

    public void makeTransient(Object pc, boolean useFetchPlan) {
        this.assertIsOpen();
        FetchPlanState state = null;
        if (useFetchPlan) {
            state = new FetchPlanState();
        }
        this.jdoMakeTransient(pc, state);
    }

    public void makeTransient(Object pc) {
        this.makeTransient(pc, false);
    }

    public void makeTransientAll(Object ... pcs) {
        this.makeTransientAll(Arrays.asList(pcs));
    }

    public void makeTransientAll(Object[] pcs, boolean includeFetchPlan) {
        this.makeTransientAll(Arrays.asList(pcs), includeFetchPlan);
    }

    public void makeTransientAll(boolean includeFetchPlan, Object ... pcs) {
        this.makeTransientAll(Arrays.asList(pcs), includeFetchPlan);
    }

    public void makeTransientAll(Collection pcs, boolean useFetchPlan) {
        this.assertIsOpen();
        ArrayList<RuntimeException> failures = new ArrayList<RuntimeException>();
        Iterator i = pcs.iterator();
        FetchPlanState state = null;
        if (useFetchPlan) {
            state = new FetchPlanState();
        }
        while (i.hasNext()) {
            try {
                this.jdoMakeTransient(i.next(), state);
            }
            catch (RuntimeException e) {
                failures.add(e);
            }
        }
        if (!failures.isEmpty()) {
            throw new JDOUserException(LOCALISER.msg("010041"), (Throwable[])failures.toArray(new Exception[failures.size()]));
        }
    }

    public void makeTransientAll(Collection pcs) {
        this.makeTransientAll(pcs, false);
    }

    private void jdoMakeTransactional(Object pc) {
        try {
            this.om.makeObjectTransactional(pc);
        }
        catch (NucleusException ne) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(ne);
        }
    }

    public void makeTransactional(Object pc) {
        this.assertIsOpen();
        this.jdoMakeTransactional(pc);
    }

    public void makeTransactionalAll(Object ... pcs) {
        this.makeTransactionalAll(Arrays.asList(pcs));
    }

    public void makeTransactionalAll(Collection pcs) {
        this.assertIsOpen();
        this.assertActiveTransaction();
        ArrayList<RuntimeException> failures = new ArrayList<RuntimeException>();
        Iterator i = pcs.iterator();
        while (i.hasNext()) {
            try {
                this.jdoMakeTransactional(i.next());
            }
            catch (RuntimeException e) {
                failures.add(e);
            }
        }
        if (!failures.isEmpty()) {
            throw new JDOUserException(LOCALISER.msg("010042"), (Throwable[])failures.toArray(new Exception[failures.size()]));
        }
    }

    private void jdoMakeNontransactional(Object obj) {
        try {
            this.om.makeObjectNontransactional(obj);
        }
        catch (NucleusException ne) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(ne);
        }
    }

    public void makeNontransactional(Object pc) {
        this.assertIsOpen();
        if (pc == null) {
            return;
        }
        if (this.om.getTransaction().isActive()) {
            this.assertActiveTransaction();
        }
        if (!((PersistenceCapable)pc).jdoIsTransactional() && !((PersistenceCapable)pc).jdoIsPersistent()) {
            throw new JDOUserException(LOCALISER_JDO.msg("011004"));
        }
        if (!((PersistenceCapable)pc).jdoIsTransactional() && ((PersistenceCapable)pc).jdoIsPersistent()) {
            return;
        }
        this.jdoMakeNontransactional(pc);
    }

    public void makeNontransactionalAll(Object ... pcs) {
        this.makeNontransactionalAll(Arrays.asList(pcs));
    }

    public void makeNontransactionalAll(Collection pcs) {
        this.assertIsOpen();
        this.assertActiveTransaction();
        ArrayList<RuntimeException> failures = new ArrayList<RuntimeException>();
        Iterator i = pcs.iterator();
        while (i.hasNext()) {
            try {
                this.jdoMakeNontransactional(i.next());
            }
            catch (RuntimeException e) {
                failures.add(e);
            }
        }
        if (!failures.isEmpty()) {
            throw new JDOUserException(LOCALISER.msg("010043"), (Throwable[])failures.toArray(new Exception[failures.size()]));
        }
    }

    private Object jdoDetachCopy(Object obj, FetchPlanState state) {
        try {
            return this.om.detachObjectCopy(obj, state);
        }
        catch (NucleusException ne) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(ne);
        }
    }

    public Object detachCopy(Object pc) {
        this.assertIsOpen();
        if (pc == null) {
            return null;
        }
        try {
            this.om.assertClassPersistable(pc.getClass());
            this.assertReadable("detachCopy");
            return this.jdoDetachCopy(pc, (FetchPlanState)new DetachState(this.om.getApiAdapter()));
        }
        catch (NucleusException ne) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(ne);
        }
    }

    public Object[] detachCopyAll(Object ... pcs) {
        return this.detachCopyAll(Arrays.asList(pcs)).toArray();
    }

    public Collection detachCopyAll(Collection pcs) {
        this.assertIsOpen();
        this.assertReadable("detachCopyAll");
        DetachState state = new DetachState(this.om.getApiAdapter());
        ArrayList<Object> detacheds = new ArrayList<Object>();
        for (Object obj : pcs) {
            if (obj == null) {
                detacheds.add(null);
                continue;
            }
            detacheds.add(this.jdoDetachCopy(obj, (FetchPlanState)state));
        }
        return detacheds;
    }

    public javax.jdo.Query newQuery() {
        return this.newQuery("javax.jdo.query.JDOQL", null);
    }

    public javax.jdo.Query newQuery(Object obj) {
        if (obj != null && obj instanceof JDOQuery) {
            String language = ((JDOQuery)obj).getLanguage();
            return this.newQuery(language, obj);
        }
        return this.newQuery(null, obj);
    }

    public javax.jdo.Query newQuery(String query) {
        return this.newQuery("javax.jdo.query.JDOQL", (Object)query);
    }

    public javax.jdo.Query newQuery(String language, Object query) {
        this.assertIsOpen();
        String queryLanguage = language;
        if (queryLanguage == null) {
            queryLanguage = "JDOQL";
        } else if (queryLanguage.equals("javax.jdo.query.JDOQL")) {
            queryLanguage = "JDOQL";
        } else if (queryLanguage.equals("javax.jdo.query.SQL")) {
            queryLanguage = "SQL";
        } else if (queryLanguage.equals("javax.jdo.query.JPQL")) {
            queryLanguage = "JPQL";
        }
        if (!this.om.getStoreManager().supportsQueryLanguage(queryLanguage)) {
            throw new JDOUserException(LOCALISER_JDO.msg("011006", (Object)queryLanguage));
        }
        Query internalQuery = null;
        try {
            internalQuery = query != null && query instanceof JDOQuery ? this.getObjectManager().getStoreManager().getQueryManager().newQuery(queryLanguage, (ExecutionContext)this.om, (Object)((JDOQuery)query).getInternalQuery()) : (query instanceof String && StringUtils.isWhitespace((String)((String)query)) ? this.getObjectManager().getStoreManager().getQueryManager().newQuery(queryLanguage, (ExecutionContext)this.om, null) : this.getObjectManager().getStoreManager().getQueryManager().newQuery(queryLanguage, (ExecutionContext)this.om, query));
        }
        catch (NucleusException ne) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(ne);
        }
        return new JDOQuery(this, internalQuery, queryLanguage);
    }

    public javax.jdo.Query newQuery(Class cls) {
        javax.jdo.Query query = this.newQuery();
        query.setClass(cls);
        return query;
    }

    public javax.jdo.Query newQuery(Extent cln) {
        javax.jdo.Query query = this.newQuery();
        query.setClass(cln.getCandidateClass());
        query.setCandidates(cln);
        return query;
    }

    public javax.jdo.Query newQuery(Class cls, Collection cln) {
        javax.jdo.Query query = this.newQuery();
        query.setClass(cls);
        query.setCandidates(cln);
        return query;
    }

    public javax.jdo.Query newQuery(Class cls, String filter) {
        javax.jdo.Query query = this.newQuery();
        query.setClass(cls);
        query.setFilter(filter);
        return query;
    }

    public javax.jdo.Query newQuery(Class cls, Collection cln, String filter) {
        javax.jdo.Query query = this.newQuery();
        query.setClass(cls);
        query.setCandidates(cln);
        query.setFilter(filter);
        return query;
    }

    public javax.jdo.Query newQuery(Extent cln, String filter) {
        javax.jdo.Query query = this.newQuery();
        query.setClass(cln.getCandidateClass());
        query.setCandidates(cln);
        query.setFilter(filter);
        return query;
    }

    public javax.jdo.Query newNamedQuery(Class cls, String queryName) {
        FetchPlanMetaData fpmd;
        ExtensionMetaData[] extmds;
        this.assertIsOpen();
        if (queryName == null) {
            throw new JDOUserException(LOCALISER_JDO.msg("011005", (Object)queryName, (Object)cls));
        }
        ClassLoaderResolver clr = this.om.getClassLoaderResolver();
        QueryMetaData qmd = this.om.getMetaDataManager().getMetaDataForQuery(cls, clr, queryName);
        if (qmd == null) {
            throw new JDOUserException(LOCALISER_JDO.msg("011005", (Object)queryName, (Object)cls));
        }
        javax.jdo.Query query = this.newQuery(qmd.getLanguage(), (Object)qmd.getQuery());
        if (cls != null) {
            query.setClass(cls);
            if (!this.om.getStoreManager().managesClass(cls.getName())) {
                this.om.getStoreManager().addClass(cls.getName(), clr);
            }
        }
        if (qmd.getLanguage().equals(QueryLanguage.JDOQL.toString()) && (qmd.isUnique() || qmd.getResultClass() != null)) {
            throw new JDOUserException(LOCALISER_JDO.msg("011007", (Object)queryName));
        }
        if (qmd.isUnique()) {
            query.setUnique(true);
        }
        if (qmd.getResultClass() != null) {
            Class resultCls = null;
            try {
                resultCls = clr.classForName(qmd.getResultClass());
            }
            catch (ClassNotResolvedException cnre) {
                try {
                    String resultClassName = cls.getPackage().getName() + "." + qmd.getResultClass();
                    resultCls = clr.classForName(resultClassName);
                }
                catch (ClassNotResolvedException cnre2) {
                    throw new JDOUserException(LOCALISER_JDO.msg("011008", (Object)queryName, (Object)qmd.getResultClass()));
                }
            }
            query.setResultClass(resultCls);
        }
        if ((extmds = qmd.getExtensions()) != null) {
            for (int i = 0; i < extmds.length; ++i) {
                if (!extmds[i].getVendorName().equals("datanucleus")) continue;
                query.addExtension(extmds[i].getKey(), (Object)extmds[i].getValue());
            }
        }
        if (qmd.isUnmodifiable()) {
            query.setUnmodifiable();
        }
        if (qmd.getFetchPlanName() != null && (fpmd = this.getObjectManager().getMetaDataManager().getMetaDataForFetchPlan(qmd.getFetchPlanName())) != null) {
            FetchPlan fp = new FetchPlan((ExecutionContext)this.om, clr);
            fp.removeGroup("default");
            FetchGroupMetaData[] fgmds = fpmd.getFetchGroupMetaData();
            for (int i = 0; i < fgmds.length; ++i) {
                fp.addGroup(fgmds[i].getName());
            }
            fp.setMaxFetchDepth(fpmd.getMaxFetchDepth());
            fp.setFetchSize(fpmd.getFetchSize());
            JDOQuery jdoquery = (JDOQuery)query;
            jdoquery.getInternalQuery().setFetchPlan(fp);
        }
        return query;
    }

    public <T> TypesafeQuery<T> newTypesafeQuery(Class cls) {
        return new JDOTypesafeQuery(this, cls);
    }

    public Extent getExtent(Class pcClass, boolean subclasses) {
        try {
            return new JDOExtent(this, this.om.getExtent(pcClass, subclasses));
        }
        catch (NucleusException ne) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(ne);
        }
    }

    public Extent getExtent(Class pcClass) {
        return this.getExtent(pcClass, true);
    }

    public Object newInstance(Class pc) {
        try {
            return this.om.newInstance(pc);
        }
        catch (NucleusException ne) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(ne);
        }
    }

    public Object newObjectIdInstance(Class pcClass, Object key) {
        try {
            return this.om.newObjectId(pcClass, key);
        }
        catch (NucleusException ne) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(ne);
        }
    }

    public Set getManagedObjects() {
        return this.om.getManagedObjects();
    }

    public Set getManagedObjects(Class ... classes) {
        return this.om.getManagedObjects(classes);
    }

    public Set getManagedObjects(EnumSet states) {
        if (states == null) {
            return null;
        }
        String[] stateNames = new String[states.size()];
        Iterator iter = states.iterator();
        int i = 0;
        while (iter.hasNext()) {
            ObjectState state = (ObjectState)iter.next();
            stateNames[i++] = state.toString();
        }
        return this.om.getManagedObjects(stateNames);
    }

    public Set getManagedObjects(EnumSet states, Class ... classes) {
        if (states == null) {
            return null;
        }
        String[] stateNames = new String[states.size()];
        Iterator iter = states.iterator();
        int i = 0;
        while (iter.hasNext()) {
            ObjectState state = (ObjectState)iter.next();
            stateNames[i++] = state.toString();
        }
        return this.om.getManagedObjects(stateNames, classes);
    }

    public Object getObjectById(Object id) {
        return this.getObjectById(id, true);
    }

    public Object getObjectById(Object id, boolean validate) {
        this.assertIsOpen();
        if (id == null) {
            throw new JDONullIdentityException(LOCALISER.msg("010044"));
        }
        try {
            return this.om.findObject(id, validate, validate, null);
        }
        catch (NucleusException ne) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(ne);
        }
    }

    public Object getObjectById(Class cls, Object key) {
        return this.getObjectById(this.newObjectIdInstance(cls, key), true);
    }

    public Object[] getObjectsById(boolean validate, Object ... oids) {
        return this.getObjectsById(oids, validate);
    }

    public Object[] getObjectsById(Object[] oids, boolean validate) {
        this.assertIsOpen();
        if (oids == null) {
            throw new JDOUserException(LOCALISER_JDO.msg("011002"));
        }
        return this.om.findObjects(oids, validate);
    }

    public Object[] getObjectsById(Object ... oids) {
        return this.getObjectsById(oids, true);
    }

    public Collection getObjectsById(Collection oids) {
        return this.getObjectsById(oids, true);
    }

    public Collection getObjectsById(Collection oids, boolean validate) {
        this.assertIsOpen();
        if (oids == null) {
            throw new JDOUserException(LOCALISER_JDO.msg("011002"));
        }
        if (oids.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Object> objects = new ArrayList<Object>(oids.size());
        Object[] objs = this.om.findObjects(oids.toArray(), validate);
        for (int i = 0; i < objs.length; ++i) {
            objects.add(objs[i]);
        }
        return objects;
    }

    public Object getObjectId(Object pc) {
        PersistenceCapable p;
        this.assertIsOpen();
        if (pc != null && pc instanceof PersistenceCapable && ((p = (PersistenceCapable)pc).jdoIsPersistent() || p.jdoIsDetached())) {
            return p.jdoGetObjectId();
        }
        return null;
    }

    public Object getTransactionalObjectId(Object pc) {
        this.assertIsOpen();
        return ((PersistenceCapable)pc).jdoGetTransactionalObjectId();
    }

    public Class getObjectIdClass(Class cls) {
        this.assertIsOpen();
        if (!this.getObjectManager().getNucleusContext().getApiAdapter().isPersistable(cls) || !this.hasPersistenceInformationForClass(cls)) {
            return null;
        }
        ClassLoaderResolver clr = this.om.getClassLoaderResolver();
        AbstractClassMetaData cmd = this.om.getMetaDataManager().getMetaDataForClass(cls, clr);
        if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            return this.om.getNucleusContext().getDatastoreIdentityClass();
        }
        if (cmd.getIdentityType() == IdentityType.APPLICATION) {
            try {
                return this.om.getClassLoaderResolver().classForName(this.om.getMetaDataManager().getMetaDataForClass(cls, clr).getObjectidClass(), null);
            }
            catch (ClassNotResolvedException e) {
                String msg = LOCALISER_JDO.msg("011009", (Object)cls.getName());
                LOGGER.error((Object)msg);
                throw new JDOException(msg);
            }
        }
        if (cmd.isRequiresExtent()) {
            return this.om.getNucleusContext().getDatastoreIdentityClass();
        }
        return SCOID.class;
    }

    public Object putUserObject(Object key, Object value) {
        this.assertIsOpen();
        if (key == null) {
            return null;
        }
        if (this.userObjectMap == null) {
            this.userObjectMap = new HashMap();
        }
        if (value == null) {
            return this.userObjectMap.remove(key);
        }
        return this.userObjectMap.put(key, value);
    }

    public Object getUserObject(Object key) {
        this.assertIsOpen();
        if (key == null) {
            return null;
        }
        if (this.userObjectMap == null) {
            return null;
        }
        return this.userObjectMap.get(key);
    }

    public Object removeUserObject(Object key) {
        this.assertIsOpen();
        if (key == null) {
            return null;
        }
        if (this.userObjectMap == null) {
            return null;
        }
        return this.userObjectMap.remove(key);
    }

    public void setUserObject(Object userObject) {
        this.assertIsOpen();
        this.userObject = userObject;
    }

    public Object getUserObject() {
        this.assertIsOpen();
        return this.userObject;
    }

    public void flush() {
        try {
            this.om.flush();
        }
        catch (NucleusException ne) {
            if (ne instanceof NucleusOptimisticException) {
                Throwable[] nested = ne.getNestedExceptions();
                JDOOptimisticVerificationException[] jdoNested = new JDOOptimisticVerificationException[nested.length];
                for (int i = 0; i < nested.length; ++i) {
                    jdoNested[i] = (JDOOptimisticVerificationException)NucleusJDOHelper.getJDOExceptionForNucleusException((NucleusException)nested[i]);
                }
                throw new JDOOptimisticVerificationException(ne.getMessage(), (Throwable[])jdoNested);
            }
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(ne);
        }
    }

    public void checkConsistency() {
        this.assertIsOpen();
        if (!this.om.getTransaction().isActive()) {
            return;
        }
        if (this.om.getTransaction().getOptimistic()) {
            throw new JDOUserException("checkConsistency() not yet implemented for optimistic transactions");
        }
        this.flush();
    }

    public Sequence getSequence(String sequenceName) {
        this.assertIsOpen();
        SequenceMetaData seqmd = this.om.getMetaDataManager().getMetaDataForSequence(this.om.getClassLoaderResolver(), sequenceName);
        if (seqmd == null) {
            throw new JDOUserException(LOCALISER.msg("017000", (Object)sequenceName));
        }
        Sequence seq = null;
        if (seqmd.getFactoryClass() != null) {
            seq = this.pmf.getSequenceForFactoryClass(seqmd.getFactoryClass());
            if (seq == null) {
                Class factory = this.om.getClassLoaderResolver().classForName(seqmd.getFactoryClass());
                if (factory == null) {
                    throw new JDOUserException(LOCALISER.msg("017001", (Object)sequenceName, (Object)seqmd.getFactoryClass()));
                }
                Class[] argTypes = null;
                Object[] arguments = null;
                if (seqmd.getStrategy() != null) {
                    argTypes = new Class[]{String.class, String.class};
                    arguments = new Object[]{seqmd.getName(), seqmd.getStrategy().toString()};
                } else {
                    argTypes = new Class[]{String.class};
                    arguments = new Object[]{seqmd.getName()};
                }
                try {
                    Method newInstanceMethod = factory.getMethod("newInstance", argTypes);
                    seq = (Sequence)newInstanceMethod.invoke(null, arguments);
                }
                catch (Exception e) {
                    throw new JDOUserException(LOCALISER.msg("017002", (Object)seqmd.getFactoryClass(), (Object)e.getMessage()));
                }
                this.pmf.addSequenceForFactoryClass(seqmd.getFactoryClass(), seq);
            }
        } else {
            NucleusSequence nucSeq = this.om.getStoreManager().getNucleusSequence((ExecutionContext)this.om, seqmd);
            seq = new JDOSequence(nucSeq);
        }
        return seq;
    }

    public void addInstanceLifecycleListener(InstanceLifecycleListener listener, Class ... classes) {
        if (listener == null) {
            return;
        }
        if ((classes = LifecycleListenerForClass.canonicaliseClasses(classes)) != null && classes.length == 0) {
            return;
        }
        this.om.addListener((Object)listener, classes);
    }

    public void removeInstanceLifecycleListener(InstanceLifecycleListener listener) {
        this.om.removeListener((Object)listener);
    }

    protected void assertIsOpen() {
        if (this.isClosed()) {
            throw new JDOFatalUserException(LOCALISER_JDO.msg("011000"));
        }
    }

    protected void assertActiveTransaction() {
        if (!this.om.getTransaction().isActive()) {
            throw new TransactionNotActiveException();
        }
    }

    protected void assertWritable() {
        if (!this.om.getTransaction().isActive() && !this.om.getTransaction().getNontransactionalWrite()) {
            throw new TransactionNotWritableException();
        }
    }

    protected void assertReadable(String operation) {
        if (!this.om.getTransaction().isActive() && !this.om.getTransaction().getNontransactionalRead()) {
            throw new JDOUserException(LOCALISER_JDO.msg("011001", (Object)operation));
        }
    }

    protected boolean hasPersistenceInformationForClass(Class cls) {
        return this.om.hasPersistenceInformationForClass(cls);
    }

    public JDOConnection getDataStoreConnection() {
        try {
            NucleusConnection nconn = this.om.getStoreManager().getNucleusConnection((ExecutionContext)this.om);
            if (nconn instanceof JDOConnection) {
                return (JDOConnection)nconn;
            }
            return new JDOConnectionImpl(nconn);
        }
        catch (NucleusException ne) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(ne);
        }
    }

    public javax.jdo.FetchGroup getFetchGroup(Class cls, String name) {
        JDOFetchGroup jdoGrp2;
        if (this.jdoFetchGroups == null) {
            this.jdoFetchGroups = new HashSet<JDOFetchGroup>();
        }
        for (JDOFetchGroup jdoGrp2 : this.jdoFetchGroups) {
            if (!jdoGrp2.getName().equals(name) || jdoGrp2.getType() != cls || jdoGrp2.isUnmodifiable()) continue;
            return jdoGrp2;
        }
        jdoGrp2 = (JDOFetchGroup)this.getPersistenceManagerFactory().getFetchGroup(cls, name);
        if (jdoGrp2 != null) {
            FetchGroup internalGrp = jdoGrp2.getInternalFetchGroup();
            FetchGroup internalCopy = new FetchGroup(internalGrp);
            jdoGrp2 = new JDOFetchGroup(internalCopy);
            this.om.addInternalFetchGroup(internalCopy);
            this.jdoFetchGroups.add(jdoGrp2);
            return jdoGrp2;
        }
        try {
            FetchGroup internalGrp = this.om.getInternalFetchGroup(cls, name);
            jdoGrp2 = new JDOFetchGroup(internalGrp);
            this.jdoFetchGroups.add(jdoGrp2);
            return jdoGrp2;
        }
        catch (NucleusException ne) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(ne);
        }
    }

    public void setProperty(String propertyName, Object value) {
        try {
            this.om.setProperty(propertyName, value);
        }
        catch (NucleusException ne) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(ne);
        }
    }

    public Map<String, Object> getProperties() {
        return this.om.getProperties();
    }

    public Set<String> getSupportedProperties() {
        return this.om.getSupportedProperties();
    }
}

