/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jpa.enhancement;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;

public abstract class SingleFieldPK
implements Externalizable,
Comparable {
    private transient Class targetClass;
    private String targetClassName;
    protected int hashCode;
    protected Object keyAsObject;

    protected SingleFieldPK(Class pcClass) {
        if (pcClass == null) {
            throw new NullPointerException();
        }
        this.targetClass = pcClass;
        this.targetClassName = pcClass.getName();
    }

    public SingleFieldPK() {
    }

    protected void setKeyAsObject(Object key) {
        this.assertKeyNotNull(key);
        this.keyAsObject = key;
    }

    protected void assertKeyNotNull(Object key) {
        if (key == null) {
            throw new NucleusUserException("Cannot create SingleFieldIdentity with null parameter");
        }
    }

    public Class getTargetClass() {
        return this.targetClass;
    }

    public String getTargetClassName() {
        return this.targetClassName;
    }

    public synchronized Object getKeyAsObject() {
        if (this.keyAsObject == null) {
            this.keyAsObject = this.createKeyAsObject();
        }
        return this.keyAsObject;
    }

    protected Object createKeyAsObject() {
        throw new NucleusException("SingleFIeldIdentity.createKeyAsObject must not be called.").setFatal();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SingleFieldPK other = (SingleFieldPK)obj;
        if (this.targetClass != null && this.targetClass == other.targetClass) {
            return true;
        }
        return this.targetClassName.equals(other.targetClassName);
    }

    protected int hashClassName() {
        return this.targetClassName.hashCode();
    }

    public int hashCode() {
        return this.hashCode;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.targetClassName);
        out.writeInt(this.hashCode);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.targetClass = null;
        this.targetClassName = (String)in.readObject();
        this.hashCode = in.readInt();
    }
}

