/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.json;

import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.NucleusContext;
import org.datanucleus.api.json.JsonAPI;
import org.datanucleus.api.json.JsonAPIExecutionContext;
import org.datanucleus.api.json.JsonAPIObjectProvider;
import org.datanucleus.api.json.JsonAPITransaction;
import org.datanucleus.api.json.JsonAPITransactionImpl;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.query.Query;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonAPIImpl
implements JsonAPI {
    NucleusContext ctx = new NucleusContext("JDO", null);
    ExecutionContext ec;
    JsonAPITransaction tx;

    public JsonAPIImpl(Map props) {
        this.ctx.getPersistenceConfiguration().setPersistenceProperties(props);
        this.ctx.initialise();
        this.ec = new JsonAPIExecutionContext(this.ctx);
        this.tx = new JsonAPITransactionImpl(this.ec.getTransaction());
    }

    public MetaDataManager getMetaDataManager() {
        return this.ctx.getMetaDataManager();
    }

    public ClassLoaderResolver getClassLoaderResolver() {
        return this.ctx.getClassLoaderResolver(null);
    }

    public JsonAPITransaction getTransaction() {
        return this.tx;
    }

    public void persist(JSONObject obj) {
        AbstractClassMetaData acmd = this.ec.getMetaDataManager().getMetaDataForClass(this.getType(obj), this.ec.getClassLoaderResolver());
        this.ctx.getStoreManager().getPersistenceHandler().insertObject((ObjectProvider)new JsonAPIObjectProvider(this.ec, acmd, obj));
    }

    public Query newQuery(String language, String query) {
        return this.ctx.getStoreManager().getQueryManager().newQuery(language, this.ec, (Object)query);
    }

    public JSONObject findObject(JSONObject id) {
        AbstractClassMetaData acmd = this.ec.getMetaDataManager().getMetaDataForClass(this.getType(id), this.ec.getClassLoaderResolver());
        JsonAPIObjectProvider op = new JsonAPIObjectProvider(this.ec, acmd, id);
        this.ctx.getStoreManager().getPersistenceHandler().fetchObject((ObjectProvider)op, acmd.getAllMemberPositions());
        return (JSONObject)op.getObject();
    }

    public void deleteObject(JSONObject id) {
        AbstractClassMetaData acmd = this.ec.getMetaDataManager().getMetaDataForClass(this.getType(id), this.ec.getClassLoaderResolver());
        JsonAPIObjectProvider op = new JsonAPIObjectProvider(this.ec, acmd, id);
        this.ctx.getStoreManager().getPersistenceHandler().deleteObject((ObjectProvider)op);
    }

    public void close() {
    }

    private String getType(JSONObject obj) {
        try {
            return obj.getString("class");
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }
}

