/**********************************************************************
Copyright (c) 2010 Andy Jefferson and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Contributors :
 ...
***********************************************************************/
package org.datanucleus.store.excel;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.OMFContext;
import org.datanucleus.ObjectManager;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.store.AbstractStoreManager;
import org.datanucleus.store.NucleusConnection;
import org.datanucleus.util.ClassUtils;

/**
 * StoreManager for data access to Excel documents (XSL or OOXML).
 * Makes use of Apache POI project.
 */
public abstract class ExcelStoreManager extends AbstractStoreManager
{
    public ExcelStoreManager(String storeMgrKey, ClassLoaderResolver clr, OMFContext omfContext)
    {
        super(storeMgrKey, clr, omfContext);

        // Check if Apache POI JAR is in CLASSPATH
        ClassUtils.assertClassForJarExistsInClasspath(clr, "org.apache.poi.hssf.usermodel.HSSFWorkbook", "poi.jar");

        persistenceHandler = new ExcelPersistenceHandler(this);

        logConfiguration();
    }

    public NucleusConnection getNucleusConnection(ObjectManager om)
    {
        throw new UnsupportedOperationException();
    }

    /**
     * Method defining which value-strategy to use when the user specifies "native".
     * @return Just returns "uuid-hex".
     */
    protected String getStrategyForNative(AbstractClassMetaData cmd, int absFieldNumber)
    {
        return "uuid-hex";
    }

    /**
     * Accessor for the supported options in string form
     */
    public Collection getSupportedOptions()
    {
        Set set = new HashSet();
        set.add("ApplicationIdentity");
        set.add("DatastoreIdentity");
        set.add("TransactionIsolationLevel.read-committed");
        set.add("ORM");
        return set;
    }
}