/*
 * Decompiled with CFR 0.152.
 */
package org.datasyslab.geosparkviz.core;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;

public class ImageSerializableWrapper
implements Serializable {
    static final Logger log = Logger.getLogger(ImageSerializableWrapper.class);
    protected transient BufferedImage image;

    public ImageSerializableWrapper(BufferedImage image) {
        this.image = image;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        log.debug((Object)"Serializing ImageWrapper");
        out.defaultWriteObject();
        ImageIO.write((RenderedImage)this.image, "png", out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        log.debug((Object)"De-serializing ImageWrapper");
        in.defaultReadObject();
        this.image = ImageIO.read(in);
        if (this.image == null) {
            System.out.println("I got nothing from the stream!");
        }
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public String toString() {
        return "Image(width=" + this.image.getWidth() + "height=" + this.image.getHeight() + ')';
    }
}

