/*
 * Decompiled with CFR 0.152.
 */
package org.datasyslab.geosparkviz.core;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Paint;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.spark.Partitioner;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.Function2;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.apache.spark.api.java.function.PairFunction;
import org.datasyslab.geospark.spatialRDD.SpatialRDD;
import org.datasyslab.geosparkviz.core.ImageSerializableWrapper;
import org.datasyslab.geosparkviz.core.PhotoFilter;
import org.datasyslab.geosparkviz.core.RasterPixelCountComparator;
import org.datasyslab.geosparkviz.core.VectorObjectCountComparator;
import org.datasyslab.geosparkviz.core.VisualizationPartitioner;
import org.datasyslab.geosparkviz.utils.ColorizeOption;
import org.datasyslab.geosparkviz.utils.Pixel;
import org.datasyslab.geosparkviz.utils.RasterizationUtils;
import org.jfree.graphics2d.svg.SVGGraphics2D;
import scala.Tuple2;

public abstract class VisualizationOperator
implements Serializable {
    protected ColorizeOption colorizeOption = ColorizeOption.NORMAL;
    protected Double maxPixelCount = -1.0;
    protected boolean reverseSpatialCoordinate;
    protected int resolutionX;
    protected int resolutionY;
    protected Envelope datasetBoundary;
    protected int red = 255;
    protected int green = 255;
    protected int blue = 255;
    protected int colorAlpha = 0;
    protected Color controlColorChannel = Color.green;
    protected boolean useInverseRatioForControlColorChannel = true;
    protected boolean generateVectorImage = false;
    protected JavaPairRDD<Pixel, Double> distributedRasterCountMatrix;
    protected JavaPairRDD<Pixel, Integer> distributedRasterColorMatrix;
    public BufferedImage rasterImage = null;
    public JavaPairRDD<Integer, ImageSerializableWrapper> distributedRasterImage = null;
    protected JavaPairRDD<Object, Double> distributedVectorObjects;
    protected JavaPairRDD<Object, Color> distributedVectorColors;
    protected boolean onlyDrawOutline = true;
    public List<String> vectorImage = null;
    public JavaPairRDD<Integer, String> distributedVectorImage = null;
    protected Double[][] PhotoFilterConvolutionMatrix = null;
    protected int photoFilterRadius;
    protected int partitionX;
    protected int partitionY;
    protected int partitionIntervalX;
    protected int partitionIntervalY;
    protected boolean hasBeenSpatialPartitioned = false;
    protected boolean parallelPhotoFilter = false;
    protected boolean parallelRenderImage = false;
    static final Logger logger = Logger.getLogger(VisualizationOperator.class);

    public VisualizationOperator(int resolutionX, int resolutionY, Envelope datasetBoundary, ColorizeOption colorizeOption, boolean reverseSpatialCoordinate, int partitionX, int partitionY, boolean parallelPhotoFilter, boolean parallelRenderImage, boolean generateVectorImage) {
        logger.info((Object)"[GeoSparkViz][Constructor][Start]");
        this.resolutionX = resolutionX;
        this.resolutionY = resolutionY;
        this.datasetBoundary = datasetBoundary;
        this.reverseSpatialCoordinate = reverseSpatialCoordinate;
        this.generateVectorImage = generateVectorImage;
        this.parallelRenderImage = parallelRenderImage;
        if (this.generateVectorImage) {
            return;
        }
        this.colorizeOption = colorizeOption;
        this.partitionX = partitionX;
        this.partitionY = partitionY;
        this.partitionIntervalX = this.resolutionX / this.partitionX;
        this.partitionIntervalY = this.resolutionY / this.partitionY;
        this.parallelPhotoFilter = parallelPhotoFilter;
        logger.info((Object)"[GeoSparkViz][Constructor][Stop]");
    }

    protected boolean InitPhotoFilterWeightMatrix(PhotoFilter photoFilter) {
        this.photoFilterRadius = photoFilter.getFilterRadius();
        this.PhotoFilterConvolutionMatrix = photoFilter.getConvolutionMatrix();
        return true;
    }

    private boolean spatialPartitioningWithoutDuplicates() throws Exception {
        this.distributedRasterColorMatrix = this.distributedRasterColorMatrix.mapToPair((PairFunction)new PairFunction<Tuple2<Pixel, Integer>, Pixel, Integer>(){

            public Tuple2<Pixel, Integer> call(Tuple2<Pixel, Integer> pixelDoubleTuple2) throws Exception {
                Pixel newPixel = new Pixel(((Pixel)((Object)pixelDoubleTuple2._1())).getX(), ((Pixel)((Object)pixelDoubleTuple2._1())).getY(), VisualizationOperator.this.resolutionX, VisualizationOperator.this.resolutionY);
                newPixel.setDuplicate(false);
                newPixel.setCurrentPartitionId(VisualizationPartitioner.CalculatePartitionId(VisualizationOperator.this.resolutionX, VisualizationOperator.this.resolutionY, VisualizationOperator.this.partitionX, VisualizationOperator.this.partitionY, (int)((Pixel)((Object)pixelDoubleTuple2._1)).getX(), (int)((Pixel)((Object)pixelDoubleTuple2._1)).getY()));
                Tuple2 newPixelDoubleTuple2 = new Tuple2((Object)newPixel, pixelDoubleTuple2._2());
                return newPixelDoubleTuple2;
            }
        });
        this.distributedRasterColorMatrix = this.distributedRasterColorMatrix.partitionBy((Partitioner)new VisualizationPartitioner(this.resolutionX, this.resolutionY, this.partitionX, this.partitionY));
        return true;
    }

    private boolean spatialPartitioningWithDuplicates() throws Exception {
        this.distributedRasterCountMatrix = this.distributedRasterCountMatrix.flatMapToPair((PairFlatMapFunction)new PairFlatMapFunction<Tuple2<Pixel, Double>, Pixel, Double>(){

            public Iterator<Tuple2<Pixel, Double>> call(Tuple2<Pixel, Double> pixelDoubleTuple2) throws Exception {
                VisualizationPartitioner vizPartitioner = new VisualizationPartitioner(VisualizationOperator.this.resolutionX, VisualizationOperator.this.resolutionY, VisualizationOperator.this.partitionX, VisualizationOperator.this.partitionY);
                return vizPartitioner.assignPartitionIDs(pixelDoubleTuple2, VisualizationOperator.this.photoFilterRadius).iterator();
            }
        });
        this.distributedRasterCountMatrix = this.distributedRasterCountMatrix.partitionBy((Partitioner)new VisualizationPartitioner(this.resolutionX, this.resolutionY, this.partitionX, this.partitionY));
        return true;
    }

    protected JavaPairRDD<Pixel, Double> ApplyPhotoFilter(JavaSparkContext sparkContext) throws Exception {
        logger.info((Object)"[GeoSparkViz][ApplyPhotoFilter][Start]");
        if (this.parallelPhotoFilter) {
            if (!this.hasBeenSpatialPartitioned) {
                this.spatialPartitioningWithDuplicates();
                this.hasBeenSpatialPartitioned = true;
            }
            this.distributedRasterCountMatrix = this.distributedRasterCountMatrix.mapPartitionsToPair((PairFlatMapFunction)new PairFlatMapFunction<Iterator<Tuple2<Pixel, Double>>, Pixel, Double>(){

                public Iterator<Tuple2<Pixel, Double>> call(Iterator<Tuple2<Pixel, Double>> currentPartition) throws Exception {
                    HashMap<Pixel, Double> pixelCountHashMap = new HashMap<Pixel, Double>();
                    while (currentPartition.hasNext()) {
                        Tuple2<Pixel, Double> currentPixelCount = currentPartition.next();
                        Tuple2 centerPixelCoordinate = new Tuple2((Object)((int)((Pixel)((Object)currentPixelCount._1())).getX()), (Object)((int)((Pixel)((Object)currentPixelCount._1())).getY()));
                        if ((Integer)centerPixelCoordinate._1() < 0 || (Integer)centerPixelCoordinate._1() >= VisualizationOperator.this.resolutionX || (Integer)centerPixelCoordinate._2() < 0 || (Integer)centerPixelCoordinate._2() >= VisualizationOperator.this.resolutionY) continue;
                        for (int x = -VisualizationOperator.this.photoFilterRadius; x <= VisualizationOperator.this.photoFilterRadius; ++x) {
                            for (int y = -VisualizationOperator.this.photoFilterRadius; y <= VisualizationOperator.this.photoFilterRadius; ++y) {
                                Pixel newPixel;
                                int neighborPixelX = (Integer)centerPixelCoordinate._1 + x;
                                int neighborPixelY = (Integer)centerPixelCoordinate._2 + y;
                                if (((Pixel)((Object)currentPixelCount._1())).getCurrentPartitionId() < 0) {
                                    throw new Exception("[VisualizationOperator][ApplyPhotoFilter] this pixel doesn't have currentPartitionId that is assigned in VisualizationPartitioner.");
                                }
                                if (neighborPixelX < 0 || neighborPixelX >= VisualizationOperator.this.resolutionX || neighborPixelY < 0 || neighborPixelY >= VisualizationOperator.this.resolutionY || VisualizationPartitioner.CalculatePartitionId(VisualizationOperator.this.resolutionX, VisualizationOperator.this.resolutionY, VisualizationOperator.this.partitionX, VisualizationOperator.this.partitionY, neighborPixelX, neighborPixelY) != ((Pixel)((Object)currentPixelCount._1())).getCurrentPartitionId()) continue;
                                Double neighborPixelCount = (Double)pixelCountHashMap.get((Object)new Pixel(neighborPixelX, neighborPixelY, VisualizationOperator.this.resolutionX, VisualizationOperator.this.resolutionY));
                                if (neighborPixelCount != null) {
                                    neighborPixelCount = neighborPixelCount + (Double)currentPixelCount._2() * VisualizationOperator.this.PhotoFilterConvolutionMatrix[x + VisualizationOperator.this.photoFilterRadius][y + VisualizationOperator.this.photoFilterRadius];
                                    pixelCountHashMap.remove((Object)new Pixel(neighborPixelX, neighborPixelY, VisualizationOperator.this.resolutionX, VisualizationOperator.this.resolutionY));
                                    newPixel = new Pixel(neighborPixelX, neighborPixelY, VisualizationOperator.this.resolutionX, VisualizationOperator.this.resolutionY, false, VisualizationPartitioner.CalculatePartitionId(VisualizationOperator.this.resolutionX, VisualizationOperator.this.resolutionY, VisualizationOperator.this.partitionX, VisualizationOperator.this.partitionY, neighborPixelX, neighborPixelY));
                                    pixelCountHashMap.put(newPixel, neighborPixelCount);
                                    continue;
                                }
                                neighborPixelCount = (Double)currentPixelCount._2() * VisualizationOperator.this.PhotoFilterConvolutionMatrix[x + VisualizationOperator.this.photoFilterRadius][y + VisualizationOperator.this.photoFilterRadius];
                                newPixel = new Pixel(neighborPixelX, neighborPixelY, VisualizationOperator.this.resolutionX, VisualizationOperator.this.resolutionY, false, VisualizationPartitioner.CalculatePartitionId(VisualizationOperator.this.resolutionX, VisualizationOperator.this.resolutionY, VisualizationOperator.this.partitionX, VisualizationOperator.this.partitionY, neighborPixelX, neighborPixelY));
                                pixelCountHashMap.put(newPixel, neighborPixelCount);
                            }
                        }
                    }
                    ArrayList<Tuple2> resultSet = new ArrayList<Tuple2>();
                    for (Map.Entry cursorEntry : pixelCountHashMap.entrySet()) {
                        resultSet.add(new Tuple2(cursorEntry.getKey(), cursorEntry.getValue()));
                    }
                    return resultSet.iterator();
                }
            });
        } else {
            this.distributedRasterCountMatrix = this.distributedRasterCountMatrix.flatMapToPair((PairFlatMapFunction)new PairFlatMapFunction<Tuple2<Pixel, Double>, Pixel, Double>(){

                public Iterator<Tuple2<Pixel, Double>> call(Tuple2<Pixel, Double> pixelCount) throws Exception {
                    Tuple2 centerPixelCoordinate = new Tuple2((Object)((int)((Pixel)((Object)pixelCount._1())).getX()), (Object)((int)((Pixel)((Object)pixelCount._1())).getY()));
                    ArrayList<Tuple2> result = new ArrayList<Tuple2>();
                    for (int x = -VisualizationOperator.this.photoFilterRadius; x <= VisualizationOperator.this.photoFilterRadius; ++x) {
                        for (int y = -VisualizationOperator.this.photoFilterRadius; y <= VisualizationOperator.this.photoFilterRadius; ++y) {
                            int neighborPixelX = (Integer)centerPixelCoordinate._1 + x;
                            int neighborPixelY = (Integer)centerPixelCoordinate._2 + y;
                            Double pixelCountValue = 0.0;
                            if (neighborPixelX >= VisualizationOperator.this.resolutionX || neighborPixelX < 0 || neighborPixelY >= VisualizationOperator.this.resolutionY || neighborPixelY < 0) continue;
                            pixelCountValue = (Double)pixelCount._2() * VisualizationOperator.this.PhotoFilterConvolutionMatrix[x + VisualizationOperator.this.photoFilterRadius][y + VisualizationOperator.this.photoFilterRadius];
                            result.add(new Tuple2((Object)new Pixel(neighborPixelX, neighborPixelY, VisualizationOperator.this.resolutionX, VisualizationOperator.this.resolutionY), (Object)pixelCountValue));
                        }
                    }
                    return result.iterator();
                }
            });
            this.distributedRasterCountMatrix = this.distributedRasterCountMatrix.reduceByKey((Function2)new Function2<Double, Double, Double>(){

                public Double call(Double count1, Double count2) throws Exception {
                    return count1 + count2;
                }
            });
        }
        logger.info((Object)"[GeoSparkViz][ApplyPhotoFilter][Stop]");
        return this.distributedRasterCountMatrix;
    }

    protected boolean Colorize() {
        logger.info((Object)"[GeoSparkViz][Colorize][Start]");
        if (this.generateVectorImage) {
            if (this.maxPixelCount < 0.0) {
                this.maxPixelCount = (Double)((Tuple2)this.distributedVectorObjects.max((Comparator)new VectorObjectCountComparator()))._2;
            }
            final Double maxWeight = this.maxPixelCount;
            final Double minWeight = 0.0;
            this.distributedVectorColors = this.distributedVectorObjects.mapValues((Function)new Function<Double, Color>(){

                public Color call(Double objectCount) throws Exception {
                    Long normalizedObjectCount = new Double((objectCount - minWeight) * 255.0 / (maxWeight - minWeight)).longValue();
                    Color objectColor = VisualizationOperator.this.EncodeToColor(normalizedObjectCount.intValue());
                    return objectColor;
                }
            });
        } else {
            if (this.maxPixelCount < 0.0) {
                this.maxPixelCount = (Double)((Tuple2)this.distributedRasterCountMatrix.max((Comparator)new RasterPixelCountComparator()))._2;
            }
            final Double maxWeight = this.maxPixelCount;
            logger.info((Object)("[GeoSparkViz][Colorize]maxCount is " + maxWeight));
            final Double minWeight = 0.0;
            this.distributedRasterColorMatrix = this.distributedRasterCountMatrix.mapValues((Function)new Function<Double, Integer>(){

                public Integer call(Double pixelCount) throws Exception {
                    Double currentPixelCount = pixelCount;
                    if (currentPixelCount > maxWeight) {
                        currentPixelCount = maxWeight;
                    }
                    Double normalizedPixelCount = (currentPixelCount - minWeight) * 255.0 / (maxWeight - minWeight);
                    Integer pixelColor = VisualizationOperator.this.EncodeToRGB(normalizedPixelCount.intValue());
                    return pixelColor;
                }
            });
        }
        logger.info((Object)"[GeoSparkViz][Colorize][Stop]");
        return true;
    }

    protected boolean RenderImage(JavaSparkContext sparkContext) throws Exception {
        logger.info((Object)"[GeoSparkViz][RenderImage][Start]");
        if (this.generateVectorImage) {
            this.distributedVectorImage = this.distributedVectorColors.mapToPair((PairFunction)new PairFunction<Tuple2<Object, Color>, Integer, String>(){

                public Tuple2<Integer, String> call(Tuple2<Object, Color> color) throws Exception {
                    SVGGraphics2D g2 = new SVGGraphics2D(VisualizationOperator.this.resolutionX, VisualizationOperator.this.resolutionY);
                    if (color._1() instanceof Point) {
                        g2.setPaint((Paint)color._2());
                        Ellipse2D.Double circle = new Ellipse2D.Double(((Point)color._1()).getCoordinate().x, ((Point)color._1()).getCoordinate().y, 1.0, 1.0);
                        g2.fill(circle);
                        String svgBody = g2.getSVGBody();
                        return new Tuple2((Object)1, (Object)svgBody);
                    }
                    if (color._1() instanceof Polygon) {
                        g2.setPaint((Paint)color._2());
                        Coordinate[] coordinates = ((Polygon)color._1()).getCoordinates();
                        int[] xPoints = new int[coordinates.length - 1];
                        int[] yPoints = new int[coordinates.length - 1];
                        for (int i = 0; i < coordinates.length - 1; ++i) {
                            xPoints[i] = (int)coordinates[i].x;
                            yPoints[i] = (int)coordinates[i].y;
                        }
                        if (VisualizationOperator.this.onlyDrawOutline) {
                            g2.drawPolygon(xPoints, yPoints, coordinates.length - 1);
                        } else {
                            g2.fillPolygon(xPoints, yPoints, coordinates.length - 1);
                        }
                        return new Tuple2((Object)1, (Object)g2.getSVGBody());
                    }
                    if (color._1() instanceof LineString) {
                        g2.setPaint((Paint)color._2());
                        Coordinate[] coordinates = ((LineString)color._1()).getCoordinates();
                        int[] xPoints = new int[coordinates.length];
                        int[] yPoints = new int[coordinates.length];
                        for (int i = 0; i < coordinates.length; ++i) {
                            xPoints[i] = (int)coordinates[i].x;
                            yPoints[i] = (int)coordinates[i].y;
                        }
                        g2.drawPolyline(xPoints, yPoints, coordinates.length);
                        return new Tuple2((Object)1, (Object)g2.getSVGBody());
                    }
                    throw new Exception("[GeoSparkViz][RenderImage] Unsupported spatial object types. GeoSparkViz only supports Point, Polygon, LineString");
                }
            });
            ArrayList<Tuple2> svgHeaderFooter = new ArrayList<Tuple2>();
            SVGGraphics2D g2 = new SVGGraphics2D(this.resolutionX, this.resolutionY);
            svgHeaderFooter.add(new Tuple2((Object)0, (Object)g2.getSVGHeader()));
            svgHeaderFooter.add(new Tuple2((Object)2, (Object)g2.getSVGFooter()));
            JavaPairRDD distributedSVGHeaderFooter = sparkContext.parallelizePairs(svgHeaderFooter);
            this.distributedVectorImage = this.distributedVectorImage.union(distributedSVGHeaderFooter);
            this.distributedVectorImage = this.distributedVectorImage.sortByKey();
            if (this.parallelRenderImage) {
                return true;
            }
            JavaRDD distributedVectorImageNoKey = this.distributedVectorImage.map((Function)new Function<Tuple2<Integer, String>, String>(){

                public String call(Tuple2<Integer, String> vectorObject) throws Exception {
                    return (String)vectorObject._2();
                }
            });
            this.vectorImage = distributedVectorImageNoKey.collect();
        } else if (this.parallelRenderImage && !this.generateVectorImage) {
            if (!this.hasBeenSpatialPartitioned) {
                this.spatialPartitioningWithoutDuplicates();
                this.hasBeenSpatialPartitioned = true;
            }
            this.distributedRasterImage = this.distributedRasterColorMatrix.mapPartitionsToPair((PairFlatMapFunction)new PairFlatMapFunction<Iterator<Tuple2<Pixel, Integer>>, Integer, ImageSerializableWrapper>(){

                public Iterator<Tuple2<Integer, ImageSerializableWrapper>> call(Iterator<Tuple2<Pixel, Integer>> currentPartition) throws Exception {
                    BufferedImage imagePartition = new BufferedImage(VisualizationOperator.this.partitionIntervalX, VisualizationOperator.this.partitionIntervalY, 2);
                    Tuple2<Pixel, Integer> pixelColor = null;
                    while (currentPartition.hasNext()) {
                        pixelColor = currentPartition.next();
                        if (((Pixel)((Object)pixelColor._1())).getX() < 0.0 || ((Pixel)((Object)pixelColor._1())).getX() >= (double)VisualizationOperator.this.resolutionX || ((Pixel)((Object)pixelColor._1())).getY() < 0.0 || ((Pixel)((Object)pixelColor._1())).getY() >= (double)VisualizationOperator.this.resolutionY) {
                            pixelColor = null;
                            continue;
                        }
                        imagePartition.setRGB((int)((Pixel)((Object)pixelColor._1())).getX() % VisualizationOperator.this.partitionIntervalX, VisualizationOperator.this.partitionIntervalY - 1 - (int)((Pixel)((Object)pixelColor._1())).getY() % VisualizationOperator.this.partitionIntervalY, (Integer)pixelColor._2);
                    }
                    ArrayList<Tuple2> result = new ArrayList<Tuple2>();
                    if (pixelColor == null) {
                        return result.iterator();
                    }
                    logger.info((Object)("[GeoSparkViz][Render]add a image partition into result set " + ((Pixel)((Object)pixelColor._1())).getCurrentPartitionId()));
                    result.add(new Tuple2((Object)((Pixel)((Object)pixelColor._1())).getCurrentPartitionId(), (Object)new ImageSerializableWrapper(imagePartition)));
                    return result.iterator();
                }
            });
        } else if (!this.parallelRenderImage && !this.generateVectorImage) {
            this.distributedRasterImage = this.distributedRasterColorMatrix.mapPartitionsToPair((PairFlatMapFunction)new PairFlatMapFunction<Iterator<Tuple2<Pixel, Integer>>, Integer, ImageSerializableWrapper>(){

                public Iterator<Tuple2<Integer, ImageSerializableWrapper>> call(Iterator<Tuple2<Pixel, Integer>> currentPartition) throws Exception {
                    BufferedImage imagePartition = new BufferedImage(VisualizationOperator.this.resolutionX, VisualizationOperator.this.resolutionY, 2);
                    Tuple2<Pixel, Integer> pixelColor = null;
                    while (currentPartition.hasNext()) {
                        pixelColor = currentPartition.next();
                        if (((Pixel)((Object)pixelColor._1())).getX() < 0.0 || ((Pixel)((Object)pixelColor._1())).getX() >= (double)VisualizationOperator.this.resolutionX || ((Pixel)((Object)pixelColor._1())).getY() < 0.0 || ((Pixel)((Object)pixelColor._1())).getY() >= (double)VisualizationOperator.this.resolutionY) {
                            pixelColor = null;
                            continue;
                        }
                        imagePartition.setRGB((int)((Pixel)((Object)pixelColor._1())).getX(), VisualizationOperator.this.resolutionY - 1 - (int)((Pixel)((Object)pixelColor._1())).getY(), (Integer)pixelColor._2);
                    }
                    ArrayList<Tuple2> result = new ArrayList<Tuple2>();
                    if (pixelColor == null) {
                        return result.iterator();
                    }
                    result.add(new Tuple2((Object)1, (Object)new ImageSerializableWrapper(imagePartition)));
                    return result.iterator();
                }
            });
            this.distributedRasterImage = this.distributedRasterImage.reduceByKey((Function2)new Function2<ImageSerializableWrapper, ImageSerializableWrapper, ImageSerializableWrapper>(){

                public ImageSerializableWrapper call(ImageSerializableWrapper image1, ImageSerializableWrapper image2) throws Exception {
                    BufferedImage combinedImage = new BufferedImage(VisualizationOperator.this.resolutionX, VisualizationOperator.this.resolutionY, 2);
                    Graphics graphics = combinedImage.getGraphics();
                    graphics.drawImage(image1.image, 0, 0, null);
                    graphics.drawImage(image2.image, 0, 0, null);
                    return new ImageSerializableWrapper(combinedImage);
                }
            });
            List imageList = this.distributedRasterImage.collect();
            this.rasterImage = ((ImageSerializableWrapper)((Tuple2)imageList.get((int)0))._2()).image;
        }
        logger.info((Object)"[GeoSparkViz][RenderImage][Stop]");
        return true;
    }

    public boolean setMaxPixelCount(Double maxPixelCount) {
        this.maxPixelCount = maxPixelCount;
        return true;
    }

    public boolean CustomizeColor(int red, int green, int blue, int colorAlpha, Color controlColorChannel, boolean useInverseRatioForControlColorChannel) {
        logger.info((Object)"[GeoSparkViz][CustomizeColor][Start]");
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.colorAlpha = colorAlpha;
        this.controlColorChannel = controlColorChannel;
        this.useInverseRatioForControlColorChannel = useInverseRatioForControlColorChannel;
        logger.info((Object)"[GeoSparkViz][CustomizeColor][Stop]");
        return true;
    }

    protected Color EncodeToColor(int normailizedCount) throws Exception {
        if (this.controlColorChannel.equals(Color.RED)) {
            this.red = this.useInverseRatioForControlColorChannel ? 255 - normailizedCount : normailizedCount;
        } else if (this.controlColorChannel.equals(Color.GREEN)) {
            this.green = this.useInverseRatioForControlColorChannel ? 255 - normailizedCount : normailizedCount;
        } else if (this.controlColorChannel.equals(Color.BLUE)) {
            this.blue = this.useInverseRatioForControlColorChannel ? 255 - normailizedCount : normailizedCount;
        } else {
            throw new Exception("[GeoSparkViz][GenerateColor] Unsupported changing color color type. It should be in R,G,B");
        }
        if (normailizedCount == 0) {
            return new Color(this.red, this.green, this.blue, 0);
        }
        return new Color(this.red, this.green, this.blue, this.colorAlpha);
    }

    protected Integer EncodeToRGB(int normailizedCount) throws Exception {
        if (this.controlColorChannel.equals(Color.RED)) {
            this.red = this.useInverseRatioForControlColorChannel ? 255 - normailizedCount : normailizedCount;
        } else if (this.controlColorChannel.equals(Color.GREEN)) {
            this.green = this.useInverseRatioForControlColorChannel ? 255 - normailizedCount : normailizedCount;
        } else if (this.controlColorChannel.equals(Color.BLUE)) {
            this.blue = this.useInverseRatioForControlColorChannel ? 255 - normailizedCount : normailizedCount;
        } else {
            throw new Exception("[GeoSparkViz][GenerateColor] Unsupported changing color color type. It should be in R,G,B");
        }
        if (normailizedCount == 0) {
            return new Color(this.red, this.green, this.blue, 0).getRGB();
        }
        return new Color(this.red, this.green, this.blue, this.colorAlpha).getRGB();
    }

    protected JavaPairRDD<Pixel, Double> Rasterize(JavaSparkContext sparkContext, SpatialRDD spatialRDD, boolean useSparkDefaultPartition) {
        logger.info((Object)"[GeoSparkViz][Rasterize][Start]");
        JavaRDD rawSpatialRDD = spatialRDD.rawSpatialRDD;
        if (this.generateVectorImage) {
            this.distributedVectorObjects = rawSpatialRDD.flatMapToPair((PairFlatMapFunction)new PairFlatMapFunction<Object, Object, Double>(){

                public Iterator<Tuple2<Object, Double>> call(Object spatialObject) throws Exception {
                    GeometryFactory geometryFactory = new GeometryFactory();
                    ArrayList<Tuple2> result = new ArrayList<Tuple2>();
                    if (spatialObject instanceof Point) {
                        if (!VisualizationOperator.this.datasetBoundary.covers(((Point)spatialObject).getEnvelopeInternal())) {
                            return result.iterator();
                        }
                        Coordinate coordinate = RasterizationUtils.FindPixelCoordinates(VisualizationOperator.this.resolutionX, VisualizationOperator.this.resolutionY, VisualizationOperator.this.datasetBoundary, ((Point)spatialObject).getCoordinate(), VisualizationOperator.this.reverseSpatialCoordinate, false, true);
                        Point rasterizedObject = geometryFactory.createPoint(coordinate);
                        if (VisualizationOperator.this.colorizeOption == ColorizeOption.EARTHOBSERVATION) {
                            result.add(new Tuple2((Object)rasterizedObject, (Object)((Point)spatialObject).getCoordinate().z));
                        } else {
                            result.add(new Tuple2((Object)rasterizedObject, (Object)new Double(1.0)));
                        }
                        return result.iterator();
                    }
                    if (spatialObject instanceof Polygon) {
                        if (!VisualizationOperator.this.datasetBoundary.covers(((Polygon)spatialObject).getEnvelopeInternal())) {
                            return result.iterator();
                        }
                        Coordinate[] spatialCoordinates = RasterizationUtils.FindPixelCoordinates(VisualizationOperator.this.resolutionX, VisualizationOperator.this.resolutionY, VisualizationOperator.this.datasetBoundary, ((Polygon)spatialObject).getCoordinates(), VisualizationOperator.this.reverseSpatialCoordinate, false, true);
                        result.add(new Tuple2((Object)geometryFactory.createPolygon(spatialCoordinates), (Object)new Double(1.0)));
                        return result.iterator();
                    }
                    if (spatialObject instanceof LineString) {
                        if (!VisualizationOperator.this.datasetBoundary.covers(((LineString)spatialObject).getEnvelopeInternal())) {
                            return result.iterator();
                        }
                        Coordinate[] spatialCoordinates = RasterizationUtils.FindPixelCoordinates(VisualizationOperator.this.resolutionX, VisualizationOperator.this.resolutionY, VisualizationOperator.this.datasetBoundary, ((LineString)spatialObject).getCoordinates(), VisualizationOperator.this.reverseSpatialCoordinate, false, true);
                        result.add(new Tuple2((Object)geometryFactory.createLineString(spatialCoordinates), (Object)new Double(1.0)));
                        return result.iterator();
                    }
                    throw new Exception("[GeoSparkViz][Rasterize] Unsupported spatial object types. GeoSparkViz only supports Point, Polygon, LineString");
                }
            });
        } else {
            JavaPairRDD spatialRDDwithPixelId = rawSpatialRDD.flatMapToPair((PairFlatMapFunction)new PairFlatMapFunction<Object, Pixel, Double>(){

                public Iterator<Tuple2<Pixel, Double>> call(Object spatialObject) throws Exception {
                    if (spatialObject instanceof Point) {
                        return RasterizationUtils.FindPixelCoordinates(VisualizationOperator.this.resolutionX, VisualizationOperator.this.resolutionY, VisualizationOperator.this.datasetBoundary, (Point)spatialObject, VisualizationOperator.this.colorizeOption, VisualizationOperator.this.reverseSpatialCoordinate).iterator();
                    }
                    if (spatialObject instanceof Polygon) {
                        return RasterizationUtils.FindPixelCoordinates(VisualizationOperator.this.resolutionX, VisualizationOperator.this.resolutionY, VisualizationOperator.this.datasetBoundary, (Polygon)spatialObject, VisualizationOperator.this.reverseSpatialCoordinate).iterator();
                    }
                    if (spatialObject instanceof LineString) {
                        return RasterizationUtils.FindPixelCoordinates(VisualizationOperator.this.resolutionX, VisualizationOperator.this.resolutionY, VisualizationOperator.this.datasetBoundary, (LineString)spatialObject, VisualizationOperator.this.reverseSpatialCoordinate).iterator();
                    }
                    throw new Exception("[GeoSparkViz][Rasterize] Unsupported spatial object types. GeoSparkViz only supports Point, Polygon, LineString");
                }
            });
            this.distributedRasterCountMatrix = spatialRDDwithPixelId = spatialRDDwithPixelId.filter((Function)new Function<Tuple2<Pixel, Double>, Boolean>(){

                public Boolean call(Tuple2<Pixel, Double> pixelCount) throws Exception {
                    if (((Pixel)((Object)pixelCount._1())).getX() < 0.0 || ((Pixel)((Object)pixelCount._1())).getX() > (double)VisualizationOperator.this.resolutionX || ((Pixel)((Object)pixelCount._1())).getY() < 0.0 || ((Pixel)((Object)pixelCount._1())).getY() > (double)VisualizationOperator.this.resolutionY) {
                        return false;
                    }
                    return true;
                }
            });
        }
        logger.info((Object)"[GeoSparkViz][Rasterize][Stop]");
        return this.distributedRasterCountMatrix;
    }

    protected JavaPairRDD<Pixel, Double> Rasterize(JavaSparkContext sparkContext, JavaPairRDD<Polygon, Long> spatialPairRDD, boolean useSparkDefaultPartition) {
        logger.info((Object)"[GeoSparkViz][Rasterize][Start]");
        if (this.generateVectorImage) {
            this.onlyDrawOutline = false;
            this.distributedVectorObjects = spatialPairRDD.flatMapToPair((PairFlatMapFunction)new PairFlatMapFunction<Tuple2<Polygon, Long>, Object, Double>(){

                public Iterator<Tuple2<Object, Double>> call(Tuple2<Polygon, Long> spatialObject) throws Exception {
                    GeometryFactory geometryFactory = new GeometryFactory();
                    ArrayList<Tuple2> result = new ArrayList<Tuple2>();
                    if (!VisualizationOperator.this.datasetBoundary.covers(((Polygon)spatialObject._1()).getEnvelopeInternal())) {
                        return result.iterator();
                    }
                    Coordinate[] spatialCoordinates = RasterizationUtils.FindPixelCoordinates(VisualizationOperator.this.resolutionX, VisualizationOperator.this.resolutionY, VisualizationOperator.this.datasetBoundary, ((Polygon)spatialObject._1()).getCoordinates(), VisualizationOperator.this.reverseSpatialCoordinate, false, true);
                    result.add(new Tuple2((Object)geometryFactory.createPolygon(spatialCoordinates), (Object)new Double(((Long)spatialObject._2()).longValue())));
                    return result.iterator();
                }
            });
        } else {
            JavaPairRDD spatialRDDwithPixelId = spatialPairRDD.flatMapToPair((PairFlatMapFunction)new PairFlatMapFunction<Tuple2<Polygon, Long>, Pixel, Double>(){

                public Iterator<Tuple2<Pixel, Double>> call(Tuple2<Polygon, Long> spatialObject) throws Exception {
                    return RasterizationUtils.FindPixelCoordinates(VisualizationOperator.this.resolutionX, VisualizationOperator.this.resolutionY, VisualizationOperator.this.datasetBoundary, (Polygon)spatialObject._1(), VisualizationOperator.this.reverseSpatialCoordinate, new Double(((Long)spatialObject._2()).longValue())).iterator();
                }
            });
            this.distributedRasterCountMatrix = spatialRDDwithPixelId = spatialRDDwithPixelId.filter((Function)new Function<Tuple2<Pixel, Double>, Boolean>(){

                public Boolean call(Tuple2<Pixel, Double> pixelCount) throws Exception {
                    if (((Pixel)((Object)pixelCount._1())).getX() < 0.0 || ((Pixel)((Object)pixelCount._1())).getX() >= (double)VisualizationOperator.this.resolutionX || ((Pixel)((Object)pixelCount._1())).getY() < 0.0 || ((Pixel)((Object)pixelCount._1())).getY() >= (double)VisualizationOperator.this.resolutionY) {
                        return false;
                    }
                    return true;
                }
            });
        }
        logger.info((Object)"[GeoSparkViz][Rasterize][Stop]");
        return this.distributedRasterCountMatrix;
    }
}

