/*
 * Decompiled with CFR 0.152.
 */
package org.datasyslab.geosparkviz.extension.visualizationEffect;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.Color;
import org.apache.log4j.Logger;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.datasyslab.geosparkviz.core.VisualizationOperator;
import org.datasyslab.geosparkviz.utils.ColorizeOption;

public class ChoroplethMap
extends VisualizationOperator {
    static final Logger logger = Logger.getLogger(ChoroplethMap.class);

    public ChoroplethMap(int resolutionX, int resolutionY, Envelope datasetBoundary, boolean reverseSpatialCoordinate) {
        super(resolutionX, resolutionY, datasetBoundary, ColorizeOption.NORMAL, reverseSpatialCoordinate, -1, -1, false, false, false);
    }

    public ChoroplethMap(int resolutionX, int resolutionY, Envelope datasetBoundary, boolean reverseSpatialCoordinate, boolean generateVectorImage) {
        super(resolutionX, resolutionY, datasetBoundary, ColorizeOption.NORMAL, reverseSpatialCoordinate, -1, -1, false, false, generateVectorImage);
    }

    public ChoroplethMap(int resolutionX, int resolutionY, Envelope datasetBoundary, boolean reverseSpatialCoordinate, int partitionX, int partitionY, boolean parallelRenderImage) {
        super(resolutionX, resolutionY, datasetBoundary, ColorizeOption.NORMAL, reverseSpatialCoordinate, partitionX, partitionY, false, parallelRenderImage, false);
    }

    public ChoroplethMap(int resolutionX, int resolutionY, Envelope datasetBoundary, boolean reverseSpatialCoordinate, int partitionX, int partitionY, boolean parallelRenderImage, boolean generateVectorImage) {
        super(resolutionX, resolutionY, datasetBoundary, ColorizeOption.NORMAL, reverseSpatialCoordinate, partitionX, partitionY, false, parallelRenderImage, generateVectorImage);
    }

    @Override
    protected Color EncodeToColor(int normailizedCount) throws Exception {
        if (this.controlColorChannel.equals(Color.RED)) {
            this.red = this.useInverseRatioForControlColorChannel ? 255 - normailizedCount : normailizedCount;
        } else if (this.controlColorChannel.equals(Color.GREEN)) {
            this.green = this.useInverseRatioForControlColorChannel ? 255 - normailizedCount : normailizedCount;
        } else if (this.controlColorChannel.equals(Color.BLUE)) {
            this.blue = this.useInverseRatioForControlColorChannel ? 255 - normailizedCount : normailizedCount;
        } else {
            throw new Exception("[VisualizationOperator][GenerateColor] Unsupported changing color color type. It should be in R,G,B");
        }
        if (normailizedCount == 0) {
            return new Color(this.red, this.green, this.blue, 255);
        }
        return new Color(this.red, this.green, this.blue, this.colorAlpha);
    }

    public boolean Visualize(JavaSparkContext sparkContext, JavaPairRDD<Polygon, Long> spatialPairRDD) throws Exception {
        logger.info((Object)"[GeoSparkViz][Visualize][Start]");
        this.Rasterize(sparkContext, spatialPairRDD, true);
        this.Colorize();
        this.RenderImage(sparkContext);
        logger.info((Object)"[GeoSparkViz][Visualize][Stop]");
        return true;
    }
}

