/*
 * Decompiled with CFR 0.152.
 */
package org.datasyslab.geosparkviz.showcase;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.Color;
import java.io.FileInputStream;
import java.util.Properties;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaSparkContext$;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.storage.StorageLevel$;
import org.datasyslab.geospark.enums.FileDataSplitter;
import org.datasyslab.geospark.enums.GridType;
import org.datasyslab.geospark.enums.IndexType;
import org.datasyslab.geospark.formatMapper.EarthdataHDFPointMapper;
import org.datasyslab.geospark.spatialOperator.JoinQuery;
import org.datasyslab.geospark.spatialRDD.PointRDD;
import org.datasyslab.geospark.spatialRDD.PolygonRDD;
import org.datasyslab.geospark.spatialRDD.RectangleRDD;
import org.datasyslab.geospark.spatialRDD.SpatialRDD;
import org.datasyslab.geosparkviz.core.ImageGenerator;
import org.datasyslab.geosparkviz.core.ImageSerializableWrapper;
import org.datasyslab.geosparkviz.core.RasterOverlayOperator;
import org.datasyslab.geosparkviz.extension.visualizationEffect.ChoroplethMap;
import org.datasyslab.geosparkviz.extension.visualizationEffect.HeatMap;
import org.datasyslab.geosparkviz.extension.visualizationEffect.ScatterPlot;
import org.datasyslab.geosparkviz.showcase.ScalaExample;
import org.datasyslab.geosparkviz.utils.ColorizeOption;
import org.datasyslab.geosparkviz.utils.ImageType;
import scala.App;
import scala.Function0;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;

public final class ScalaExample$
implements App {
    public static final ScalaExample$ MODULE$;
    private final SparkConf sparkConf;
    private final SparkContext sparkContext;
    private final Properties prop;
    private final String resourcePath;
    private final String demoOutputPath;
    private FileInputStream ConfFile;
    private final String scatterPlotOutputPath;
    private final String heatMapOutputPath;
    private final String choroplethMapOutputPath;
    private final String parallelFilterRenderStitchOutputPath;
    private final String earthdataScatterPlotOutputPath;
    private final String PointInputLocation;
    private final int PointOffset;
    private final FileDataSplitter PointSplitter;
    private final int PointNumPartitions;
    private final String RectangleInputLocation;
    private final int RectangleOffset;
    private final FileDataSplitter RectangleSplitter;
    private final int RectangleNumPartitions;
    private final String PolygonInputLocation;
    private final int PolygonOffset;
    private final FileDataSplitter PolygonSplitter;
    private final int PolygonNumPartitions;
    private final String LineStringInputLocation;
    private final int LineStringOffset;
    private final FileDataSplitter LineStringSplitter;
    private final int LineStringNumPartitions;
    private final Envelope USMainLandBoundary;
    private final String earthdataInputLocation;
    private final int earthdataNumPartitions;
    private final int HDFIncrement;
    private final int HDFOffset;
    private final String HDFRootGroupName;
    private final String HDFDataVariableName;
    private final String[] HDFDataVariableList;
    private final boolean HDFswitchXY;
    private final String urlPrefix;
    private final long executionStart;
    private String[] scala$App$$_args;
    private final ListBuffer<Function0<BoxedUnit>> scala$App$$initCode;

    static {
        new ScalaExample$();
    }

    public long executionStart() {
        return this.executionStart;
    }

    public String[] scala$App$$_args() {
        return this.scala$App$$_args;
    }

    public void scala$App$$_args_$eq(String[] x$1) {
        this.scala$App$$_args = x$1;
    }

    public ListBuffer<Function0<BoxedUnit>> scala$App$$initCode() {
        return this.scala$App$$initCode;
    }

    public void scala$App$_setter_$executionStart_$eq(long x$1) {
        this.executionStart = x$1;
    }

    public void scala$App$_setter_$scala$App$$initCode_$eq(ListBuffer x$1) {
        this.scala$App$$initCode = x$1;
    }

    public String[] args() {
        return App.class.args((App)this);
    }

    public void delayedInit(Function0<BoxedUnit> body2) {
        App.class.delayedInit((App)this, body2);
    }

    public void main(String[] args) {
        App.class.main((App)this, (String[])args);
    }

    public SparkConf sparkConf() {
        return this.sparkConf;
    }

    public SparkContext sparkContext() {
        return this.sparkContext;
    }

    public Properties prop() {
        return this.prop;
    }

    public String resourcePath() {
        return this.resourcePath;
    }

    public String demoOutputPath() {
        return this.demoOutputPath;
    }

    public FileInputStream ConfFile() {
        return this.ConfFile;
    }

    public void ConfFile_$eq(FileInputStream x$1) {
        this.ConfFile = x$1;
    }

    public String scatterPlotOutputPath() {
        return this.scatterPlotOutputPath;
    }

    public String heatMapOutputPath() {
        return this.heatMapOutputPath;
    }

    public String choroplethMapOutputPath() {
        return this.choroplethMapOutputPath;
    }

    public String parallelFilterRenderStitchOutputPath() {
        return this.parallelFilterRenderStitchOutputPath;
    }

    public String earthdataScatterPlotOutputPath() {
        return this.earthdataScatterPlotOutputPath;
    }

    public String PointInputLocation() {
        return this.PointInputLocation;
    }

    public int PointOffset() {
        return this.PointOffset;
    }

    public FileDataSplitter PointSplitter() {
        return this.PointSplitter;
    }

    public int PointNumPartitions() {
        return this.PointNumPartitions;
    }

    public String RectangleInputLocation() {
        return this.RectangleInputLocation;
    }

    public int RectangleOffset() {
        return this.RectangleOffset;
    }

    public FileDataSplitter RectangleSplitter() {
        return this.RectangleSplitter;
    }

    public int RectangleNumPartitions() {
        return this.RectangleNumPartitions;
    }

    public String PolygonInputLocation() {
        return this.PolygonInputLocation;
    }

    public int PolygonOffset() {
        return this.PolygonOffset;
    }

    public FileDataSplitter PolygonSplitter() {
        return this.PolygonSplitter;
    }

    public int PolygonNumPartitions() {
        return this.PolygonNumPartitions;
    }

    public String LineStringInputLocation() {
        return this.LineStringInputLocation;
    }

    public int LineStringOffset() {
        return this.LineStringOffset;
    }

    public FileDataSplitter LineStringSplitter() {
        return this.LineStringSplitter;
    }

    public int LineStringNumPartitions() {
        return this.LineStringNumPartitions;
    }

    public Envelope USMainLandBoundary() {
        return this.USMainLandBoundary;
    }

    public String earthdataInputLocation() {
        return this.earthdataInputLocation;
    }

    public int earthdataNumPartitions() {
        return this.earthdataNumPartitions;
    }

    public int HDFIncrement() {
        return this.HDFIncrement;
    }

    public int HDFOffset() {
        return this.HDFOffset;
    }

    public String HDFRootGroupName() {
        return this.HDFRootGroupName;
    }

    public String HDFDataVariableName() {
        return this.HDFDataVariableName;
    }

    public String[] HDFDataVariableList() {
        return this.HDFDataVariableList;
    }

    public boolean HDFswitchXY() {
        return this.HDFswitchXY;
    }

    public String urlPrefix() {
        return this.urlPrefix;
    }

    public boolean buildScatterPlot(String outputPath) {
        PolygonRDD spatialRDD = new PolygonRDD(JavaSparkContext$.MODULE$.fromSparkContext(this.sparkContext()), this.PolygonInputLocation(), this.PolygonSplitter(), false, Predef$.MODULE$.int2Integer(this.PolygonNumPartitions()));
        ScatterPlot visualizationOperator = new ScatterPlot(1000, 600, this.USMainLandBoundary(), false);
        visualizationOperator.CustomizeColor(255, 255, 255, 255, Color.GREEN, true);
        visualizationOperator.Visualize(JavaSparkContext$.MODULE$.fromSparkContext(this.sparkContext()), (SpatialRDD)spatialRDD);
        ImageGenerator imageGenerator = new ImageGenerator();
        imageGenerator.SaveRasterImageAsLocalFile(visualizationOperator.rasterImage, outputPath, ImageType.PNG);
        visualizationOperator = new ScatterPlot(1000, 600, this.USMainLandBoundary(), false, -1, -1, false, true);
        visualizationOperator.CustomizeColor(255, 255, 255, 255, Color.GREEN, true);
        visualizationOperator.Visualize(JavaSparkContext$.MODULE$.fromSparkContext(this.sparkContext()), (SpatialRDD)spatialRDD);
        imageGenerator = new ImageGenerator();
        imageGenerator.SaveVectorImageAsLocalFile(visualizationOperator.vectorImage, outputPath, ImageType.SVG);
        visualizationOperator = new ScatterPlot(1000, 600, this.USMainLandBoundary(), false, -1, -1, true, true);
        visualizationOperator.CustomizeColor(255, 255, 255, 255, Color.GREEN, true);
        visualizationOperator.Visualize(JavaSparkContext$.MODULE$.fromSparkContext(this.sparkContext()), (SpatialRDD)spatialRDD);
        imageGenerator = new ImageGenerator();
        imageGenerator.SaveVectorImageAsLocalFile((JavaPairRDD<Integer, String>)visualizationOperator.distributedVectorImage, new StringBuilder().append((Object)"file://").append((Object)outputPath).append((Object)"-distributed").toString(), ImageType.SVG);
        return true;
    }

    public boolean buildHeatMap(String outputPath) {
        RectangleRDD spatialRDD = new RectangleRDD(JavaSparkContext$.MODULE$.fromSparkContext(this.sparkContext()), this.RectangleInputLocation(), this.RectangleSplitter(), false, Predef$.MODULE$.int2Integer(this.RectangleNumPartitions()), StorageLevel$.MODULE$.MEMORY_ONLY());
        HeatMap visualizationOperator = new HeatMap(1000, 600, this.USMainLandBoundary(), false, 2);
        visualizationOperator.Visualize(JavaSparkContext$.MODULE$.fromSparkContext(this.sparkContext()), (SpatialRDD)spatialRDD);
        ImageGenerator imageGenerator = new ImageGenerator();
        imageGenerator.SaveRasterImageAsLocalFile(visualizationOperator.rasterImage, outputPath, ImageType.PNG);
        return true;
    }

    public boolean buildChoroplethMap(String outputPath) {
        PointRDD spatialRDD = new PointRDD(JavaSparkContext$.MODULE$.fromSparkContext(this.sparkContext()), this.PointInputLocation(), Predef$.MODULE$.int2Integer(this.PointOffset()), this.PointSplitter(), false, Predef$.MODULE$.int2Integer(this.PointNumPartitions()), StorageLevel$.MODULE$.MEMORY_ONLY());
        PolygonRDD queryRDD = new PolygonRDD(JavaSparkContext$.MODULE$.fromSparkContext(this.sparkContext()), this.PolygonInputLocation(), this.PolygonSplitter(), false, Predef$.MODULE$.int2Integer(this.PolygonNumPartitions()), StorageLevel$.MODULE$.MEMORY_ONLY());
        spatialRDD.spatialPartitioning(GridType.RTREE);
        queryRDD.spatialPartitioning(spatialRDD.grids);
        spatialRDD.buildIndex(IndexType.RTREE, true);
        JavaPairRDD joinResult = JoinQuery.SpatialJoinQueryCountByKey((SpatialRDD)spatialRDD, (SpatialRDD)queryRDD, (boolean)true, (boolean)false);
        ChoroplethMap visualizationOperator = new ChoroplethMap(1000, 600, this.USMainLandBoundary(), false);
        visualizationOperator.CustomizeColor(255, 255, 255, 255, Color.RED, true);
        visualizationOperator.Visualize(JavaSparkContext$.MODULE$.fromSparkContext(this.sparkContext()), (JavaPairRDD<Polygon, Long>)joinResult);
        ScatterPlot frontImage = new ScatterPlot(1000, 600, this.USMainLandBoundary(), false);
        frontImage.CustomizeColor(0, 0, 0, 255, Color.GREEN, true);
        frontImage.Visualize(JavaSparkContext$.MODULE$.fromSparkContext(this.sparkContext()), (SpatialRDD)queryRDD);
        RasterOverlayOperator overlayOperator = new RasterOverlayOperator(visualizationOperator.rasterImage);
        overlayOperator.JoinImage(frontImage.rasterImage);
        ImageGenerator imageGenerator = new ImageGenerator();
        imageGenerator.SaveRasterImageAsLocalFile(overlayOperator.backRasterImage, outputPath, ImageType.PNG);
        return true;
    }

    public boolean parallelFilterRenderNoStitch(String outputPath) {
        RectangleRDD spatialRDD = new RectangleRDD(JavaSparkContext$.MODULE$.fromSparkContext(this.sparkContext()), this.RectangleInputLocation(), this.RectangleSplitter(), false, Predef$.MODULE$.int2Integer(this.RectangleNumPartitions()), StorageLevel$.MODULE$.MEMORY_ONLY());
        HeatMap visualizationOperator = new HeatMap(1000, 600, this.USMainLandBoundary(), false, 2, 4, 4, true, true);
        visualizationOperator.Visualize(JavaSparkContext$.MODULE$.fromSparkContext(this.sparkContext()), (SpatialRDD)spatialRDD);
        ImageGenerator imageGenerator = new ImageGenerator();
        imageGenerator.SaveRasterImageAsLocalFile((JavaPairRDD<Integer, ImageSerializableWrapper>)visualizationOperator.distributedRasterImage, outputPath, ImageType.PNG, 0, 4, 4);
        return true;
    }

    public boolean parallelFilterRenderStitch(String outputPath) {
        RectangleRDD spatialRDD = new RectangleRDD(JavaSparkContext$.MODULE$.fromSparkContext(this.sparkContext()), this.RectangleInputLocation(), this.RectangleSplitter(), false, Predef$.MODULE$.int2Integer(this.RectangleNumPartitions()), StorageLevel$.MODULE$.MEMORY_ONLY());
        HeatMap visualizationOperator = new HeatMap(1000, 600, this.USMainLandBoundary(), false, 2, 4, 4, true, true);
        visualizationOperator.Visualize(JavaSparkContext$.MODULE$.fromSparkContext(this.sparkContext()), (SpatialRDD)spatialRDD);
        ImageGenerator imageGenerator = new ImageGenerator();
        imageGenerator.SaveRasterImageAsLocalFile(visualizationOperator.rasterImage, outputPath, ImageType.PNG);
        return true;
    }

    public boolean earthdataVisualization(String outputPath) {
        EarthdataHDFPointMapper earthdataHDFPoint = new EarthdataHDFPointMapper(this.HDFIncrement(), this.HDFOffset(), this.HDFRootGroupName(), this.HDFDataVariableList(), this.HDFDataVariableName(), this.HDFswitchXY(), this.urlPrefix());
        PointRDD spatialRDD = new PointRDD(JavaSparkContext$.MODULE$.fromSparkContext(this.sparkContext()), this.earthdataInputLocation(), Predef$.MODULE$.int2Integer(this.earthdataNumPartitions()), (FlatMapFunction)earthdataHDFPoint, StorageLevel$.MODULE$.MEMORY_ONLY());
        ScatterPlot visualizationOperator = new ScatterPlot(1000, 600, spatialRDD.boundaryEnvelope, ColorizeOption.EARTHOBSERVATION, false, false);
        visualizationOperator.CustomizeColor(255, 255, 255, 255, Color.BLUE, true);
        visualizationOperator.Visualize(JavaSparkContext$.MODULE$.fromSparkContext(this.sparkContext()), (SpatialRDD)spatialRDD);
        ImageGenerator imageGenerator = new ImageGenerator();
        imageGenerator.SaveRasterImageAsLocalFile(visualizationOperator.rasterImage, outputPath, ImageType.PNG);
        return true;
    }

    public final void delayedEndpoint$org$datasyslab$geosparkviz$showcase$ScalaExample$1() {
        this.sparkConf = new SparkConf().setAppName("GeoSparkVizDemo").setMaster("local[4]");
        this.sparkContext = new SparkContext(this.sparkConf());
        Logger.getLogger((String)"org").setLevel(Level.WARN);
        Logger.getLogger((String)"akka").setLevel(Level.WARN);
        this.prop = new Properties();
        this.resourcePath = "src/test/resources/";
        this.demoOutputPath = "target/demo";
        this.ConfFile = new FileInputStream(new StringBuilder().append((Object)this.resourcePath()).append((Object)"babylon.point.properties").toString());
        this.prop().load(this.ConfFile());
        this.scatterPlotOutputPath = new StringBuilder().append((Object)System.getProperty("user.dir")).append((Object)"/").append((Object)this.demoOutputPath()).append((Object)"/scatterplot").toString();
        this.heatMapOutputPath = new StringBuilder().append((Object)System.getProperty("user.dir")).append((Object)"/").append((Object)this.demoOutputPath()).append((Object)"/heatmap").toString();
        this.choroplethMapOutputPath = new StringBuilder().append((Object)System.getProperty("user.dir")).append((Object)"/").append((Object)this.demoOutputPath()).append((Object)"/choroplethmap").toString();
        this.parallelFilterRenderStitchOutputPath = new StringBuilder().append((Object)System.getProperty("user.dir")).append((Object)"/").append((Object)this.demoOutputPath()).append((Object)"/parallelfilterrenderstitchheatmap").toString();
        this.earthdataScatterPlotOutputPath = new StringBuilder().append((Object)System.getProperty("user.dir")).append((Object)"/").append((Object)this.demoOutputPath()).append((Object)"/earthdatascatterplot").toString();
        this.PointInputLocation = new StringBuilder().append((Object)"file://").append((Object)System.getProperty("user.dir")).append((Object)"/").append((Object)this.resourcePath()).append((Object)this.prop().getProperty("inputLocation")).toString();
        this.PointOffset = new StringOps(Predef$.MODULE$.augmentString(this.prop().getProperty("offset"))).toInt();
        this.PointSplitter = FileDataSplitter.getFileDataSplitter((String)this.prop().getProperty("splitter"));
        this.PointNumPartitions = new StringOps(Predef$.MODULE$.augmentString(this.prop().getProperty("numPartitions"))).toInt();
        this.ConfFile_$eq(new FileInputStream(new StringBuilder().append((Object)this.resourcePath()).append((Object)"babylon.rectangle.properties").toString()));
        this.prop().load(this.ConfFile());
        this.RectangleInputLocation = new StringBuilder().append((Object)"file://").append((Object)System.getProperty("user.dir")).append((Object)"/").append((Object)this.resourcePath()).append((Object)this.prop().getProperty("inputLocation")).toString();
        this.RectangleOffset = new StringOps(Predef$.MODULE$.augmentString(this.prop().getProperty("offset"))).toInt();
        this.RectangleSplitter = FileDataSplitter.getFileDataSplitter((String)this.prop().getProperty("splitter"));
        this.RectangleNumPartitions = new StringOps(Predef$.MODULE$.augmentString(this.prop().getProperty("numPartitions"))).toInt();
        this.ConfFile_$eq(new FileInputStream(new StringBuilder().append((Object)this.resourcePath()).append((Object)"babylon.polygon.properties").toString()));
        this.prop().load(this.ConfFile());
        this.PolygonInputLocation = new StringBuilder().append((Object)"file://").append((Object)System.getProperty("user.dir")).append((Object)"/").append((Object)this.resourcePath()).append((Object)this.prop().getProperty("inputLocation")).toString();
        this.PolygonOffset = new StringOps(Predef$.MODULE$.augmentString(this.prop().getProperty("offset"))).toInt();
        this.PolygonSplitter = FileDataSplitter.getFileDataSplitter((String)this.prop().getProperty("splitter"));
        this.PolygonNumPartitions = new StringOps(Predef$.MODULE$.augmentString(this.prop().getProperty("numPartitions"))).toInt();
        this.ConfFile_$eq(new FileInputStream(new StringBuilder().append((Object)this.resourcePath()).append((Object)"babylon.linestring.properties").toString()));
        this.prop().load(this.ConfFile());
        this.LineStringInputLocation = new StringBuilder().append((Object)"file://").append((Object)System.getProperty("user.dir")).append((Object)"/").append((Object)this.resourcePath()).append((Object)this.prop().getProperty("inputLocation")).toString();
        this.LineStringOffset = new StringOps(Predef$.MODULE$.augmentString(this.prop().getProperty("offset"))).toInt();
        this.LineStringSplitter = FileDataSplitter.getFileDataSplitter((String)this.prop().getProperty("splitter"));
        this.LineStringNumPartitions = new StringOps(Predef$.MODULE$.augmentString(this.prop().getProperty("numPartitions"))).toInt();
        this.USMainLandBoundary = new Envelope(-126.79018, -64.630926, 24.863836, 50.0);
        this.earthdataInputLocation = new StringBuilder().append((Object)System.getProperty("user.dir")).append((Object)"/src/test/resources/modis/modis.csv").toString();
        this.earthdataNumPartitions = 5;
        this.HDFIncrement = 5;
        this.HDFOffset = 2;
        this.HDFRootGroupName = "MOD_Swath_LST";
        this.HDFDataVariableName = "LST";
        this.HDFDataVariableList = (String[])((Object[])new String[]{"LST", "QC", "Error_LST", "Emis_31", "Emis_32"});
        this.HDFswitchXY = true;
        this.urlPrefix = new StringBuilder().append((Object)System.getProperty("user.dir")).append((Object)"/src/test/resources/modis/").toString();
        if (this.buildScatterPlot(this.scatterPlotOutputPath()) && this.buildHeatMap(this.heatMapOutputPath()) && this.buildChoroplethMap(this.choroplethMapOutputPath()) && this.parallelFilterRenderStitch(new StringBuilder().append((Object)this.parallelFilterRenderStitchOutputPath()).append((Object)"-stitched").toString()) && this.parallelFilterRenderNoStitch(this.parallelFilterRenderStitchOutputPath()) && this.earthdataVisualization(this.earthdataScatterPlotOutputPath())) {
            System.out.println("All 5 GeoSparkViz Demos have passed.");
        } else {
            System.out.println("GeoSparkViz Demos failed.");
        }
    }

    private ScalaExample$() {
        MODULE$ = this;
        App.class.$init$((App)this);
        this.delayedInit((Function0<BoxedUnit>)new ScalaExample.delayedInit.body(this));
    }
}

