/*
 * Decompiled with CFR 0.152.
 */
package org.datasyslab.geosparkviz.core;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.Color;
import java.io.Serializable;
import org.apache.log4j.Logger;
import org.datasyslab.geosparkviz.core.ColoringRule;
import org.datasyslab.geosparkviz.core.PhotoFilter;
import org.datasyslab.geosparkviz.extension.coloringRule.ColoringRuleFactory;
import org.datasyslab.geosparkviz.extension.coloringRule.LinearFunction;
import org.datasyslab.geosparkviz.extension.photoFilter.GaussianBlur;

public class GlobalParameter
implements Serializable {
    static final Logger logger = Logger.getLogger(GlobalParameter.class);
    public int resolutionX = -1;
    public int resolutionY = -1;
    public boolean reverseSpatialCoordinate = false;
    public boolean drawOutlineOnly = false;
    public int minTreeLevel = 0;
    public int filterRadius = 0;
    public PhotoFilter photoFilter;
    public double samplingFraction = 0.01;
    public int maxPixelWeight = -1;
    public ColoringRule coloringRule;
    public Color controlColorChannel = Color.GREEN;
    public boolean useInverseRatioForControlColorChannel = false;
    public int colorAlpha = 255;
    public Envelope datasetBoundary = new Envelope(-2.002637639E7, 2.002637639E7, -2.00489661E7, 2.00489661E7);
    public int partitionsOnSingleAxis = -1;
    public double partitionIntervalX = -1.0;
    public double partitionIntervalY = -1.0;
    public boolean useUserSuppliedResolution = false;
    public int maxPartitionTreeLevel = 9;
    public boolean overwriteExistingImages = true;

    private GlobalParameter(int resolutionX, int resolutionY, boolean reverseSpatialCoordinate, boolean drawOutlineOnly, int minTreeLevel, int filterRadius, PhotoFilter photoFilter, Double samplingFraction, int maxPixelWeight, ColoringRule coloringRule, Color controlColorChannel, boolean useInverseRatioForControlColorChannel, int colorAlpha, Envelope datasetBoundary, int maxPartitionTreeLevel, boolean overwriteExistingImages) {
        this.resolutionX = resolutionX;
        this.resolutionY = resolutionY;
        this.reverseSpatialCoordinate = reverseSpatialCoordinate;
        this.drawOutlineOnly = drawOutlineOnly;
        this.minTreeLevel = minTreeLevel;
        this.filterRadius = filterRadius;
        this.photoFilter = photoFilter;
        this.samplingFraction = samplingFraction;
        this.maxPixelWeight = maxPixelWeight;
        this.coloringRule = coloringRule;
        this.controlColorChannel = controlColorChannel;
        this.useInverseRatioForControlColorChannel = useInverseRatioForControlColorChannel;
        this.colorAlpha = colorAlpha;
        this.datasetBoundary = datasetBoundary;
        this.maxPartitionTreeLevel = maxPartitionTreeLevel;
        this.overwriteExistingImages = overwriteExistingImages;
        this.partitionsOnSingleAxis = (int)Math.sqrt(Math.pow(4.0, minTreeLevel));
        if (this.resolutionX <= 0 && this.resolutionY <= 0) {
            this.partitionIntervalX = 256.0;
            this.partitionIntervalY = 256.0;
            this.resolutionX = this.partitionsOnSingleAxis * 256;
            this.resolutionY = this.partitionsOnSingleAxis * 256;
            this.useUserSuppliedResolution = false;
        } else {
            this.partitionIntervalX = (double)resolutionX * 1.0 / (double)this.partitionsOnSingleAxis;
            this.partitionIntervalY = (double)resolutionY * 1.0 / (double)this.partitionsOnSingleAxis;
            this.useUserSuppliedResolution = true;
        }
    }

    private boolean updateIndirectParameters() {
        this.partitionsOnSingleAxis = (int)Math.sqrt(Math.pow(4.0, this.minTreeLevel));
        if (!this.useUserSuppliedResolution) {
            this.partitionIntervalX = 256.0;
            this.partitionIntervalY = 256.0;
            this.resolutionX = this.partitionsOnSingleAxis * 256;
            this.resolutionY = this.partitionsOnSingleAxis * 256;
        } else {
            this.partitionIntervalX = (double)this.resolutionX * 1.0 / (double)this.partitionsOnSingleAxis;
            this.partitionIntervalY = (double)this.resolutionY * 1.0 / (double)this.partitionsOnSingleAxis;
        }
        return true;
    }

    public boolean setDatasetBoundary(Envelope datasetBoundary) {
        this.datasetBoundary = datasetBoundary;
        return true;
    }

    public boolean setColoringRule(ColoringRule coloringRule) {
        this.coloringRule = coloringRule;
        return true;
    }

    public boolean setPhotoFilter(PhotoFilter photoFilter) {
        this.photoFilter = photoFilter;
        return true;
    }

    public boolean set(String keyValuePair) {
        String[] keyValue = keyValuePair.split(":");
        this.set(keyValue[0], keyValue[1]);
        return true;
    }

    public boolean set(String key, String value) {
        if (key.equalsIgnoreCase("resolutionX") || key.equalsIgnoreCase("resX")) {
            this.resolutionX = Integer.parseInt(value);
            this.useUserSuppliedResolution = true;
            this.updateIndirectParameters();
        } else if (key.equalsIgnoreCase("resolutionY") || key.equalsIgnoreCase("resY")) {
            this.resolutionY = Integer.parseInt(value);
            this.useUserSuppliedResolution = true;
            this.updateIndirectParameters();
        } else if (key.equalsIgnoreCase("reverseSpatialCoordinate") || key.equalsIgnoreCase("revCoor")) {
            this.reverseSpatialCoordinate = Boolean.parseBoolean(value);
        } else if (key.equalsIgnoreCase("drawOutlineOnly") || key.equalsIgnoreCase("outline")) {
            this.drawOutlineOnly = Boolean.parseBoolean(value);
        } else if (key.equalsIgnoreCase("minTreeLevel") || key.equalsIgnoreCase("level")) {
            this.minTreeLevel = Integer.parseInt(value);
            this.updateIndirectParameters();
        } else if (key.equalsIgnoreCase("filterRadius") || key.equalsIgnoreCase("radius")) {
            this.filterRadius = Integer.parseInt(value);
        } else if (key.equalsIgnoreCase("samplingfraction") || key.equalsIgnoreCase("fraction")) {
            this.samplingFraction = Double.parseDouble(value);
        } else if (key.equalsIgnoreCase("maxPixelWeight")) {
            this.maxPixelWeight = Integer.parseInt(value);
        } else if (key.equalsIgnoreCase("coloringRule")) {
            this.coloringRule = ColoringRuleFactory.getColoringRule(value);
        } else if (key.equalsIgnoreCase("controlColorChannel") || key.equalsIgnoreCase("ccolor")) {
            this.controlColorChannel = Color.getColor(value);
        } else if (key.equalsIgnoreCase("useInverseRatioForControlColorChannel") || key.equalsIgnoreCase("invColor")) {
            this.useInverseRatioForControlColorChannel = Boolean.parseBoolean(value);
        } else if (key.equalsIgnoreCase("colorAlpha") || key.equalsIgnoreCase("alpha")) {
            this.colorAlpha = Integer.parseInt(value);
        } else if (key.equalsIgnoreCase("datasetBoundary") || key.equalsIgnoreCase("bound")) {
            String[] coordinates = value.split(",");
            double minX = Double.parseDouble(coordinates[0]);
            double maxX = Double.parseDouble(coordinates[1]);
            double minY = Double.parseDouble(coordinates[2]);
            double maxY = Double.parseDouble(coordinates[3]);
            this.datasetBoundary = new Envelope(minX, maxX, minY, maxY);
        } else if (key.equalsIgnoreCase("maxPartitionTreeLevel") || key.equalsIgnoreCase("maxtreelevel")) {
            this.maxPartitionTreeLevel = Integer.parseInt(value);
        } else if (key.equalsIgnoreCase("overwriteexistingimages") || key.equalsIgnoreCase("overwrite")) {
            this.overwriteExistingImages = Boolean.parseBoolean(value);
        } else {
            logger.error((Object)new Exception("[Babylon][set] No such parameter: " + key));
        }
        return true;
    }

    public static GlobalParameter getGlobalParameter(String parameterString) {
        String[] parameters;
        GlobalParameter globalParameter = GlobalParameter.getGlobalParameter();
        for (String parameter : parameters = parameterString.split(" ")) {
            globalParameter.set(parameter);
        }
        return globalParameter;
    }

    public static GlobalParameter getGlobalParameter() {
        GlobalParameter globalParameter = new GlobalParameter(0, 0, false, true, 0, 0, new GaussianBlur(3), 0.01, -1, new LinearFunction(), Color.GREEN, false, 255, new Envelope(-2.002637639E7, 2.002637639E7, -2.00489661E7, 2.00489661E7), 9, true);
        return globalParameter;
    }

    public static GlobalParameter getGlobalParameter(int resolutionX, int resolutionY, boolean reverseSpatialCoordinate, boolean drawOutlineOnly, int minTreeLevel, int filterRadius, PhotoFilter photoFilter, Double samplingFraction, int maxPixelWeight, ColoringRule coloringRule, Color controlColorChannel, boolean useInverseRatioForControlColorChannel, int colorAlpha, Envelope datasetBoundary, int maxPartitionTreeLevel, boolean overwriteExistingImages) {
        return new GlobalParameter(resolutionX, resolutionY, reverseSpatialCoordinate, drawOutlineOnly, minTreeLevel, filterRadius, photoFilter, samplingFraction, maxPixelWeight, coloringRule, controlColorChannel, useInverseRatioForControlColorChannel, colorAlpha, datasetBoundary, maxPartitionTreeLevel, overwriteExistingImages);
    }

    public String toString() {
        String parameterString = "\n";
        parameterString = parameterString + "resolutionX: " + this.resolutionX + "\n";
        parameterString = parameterString + "resolutionY: " + this.resolutionY + "\n";
        parameterString = parameterString + "reverseSpatialCoordinate: " + this.reverseSpatialCoordinate + "\n";
        parameterString = parameterString + "drawOutlineOnly: " + this.drawOutlineOnly + "\n";
        parameterString = parameterString + "minTreeLevel: " + this.minTreeLevel + "\n";
        parameterString = parameterString + "filterRadius: " + this.filterRadius + "\n";
        parameterString = parameterString + "photoFilter: " + this.photoFilter.getClass().getName() + "\n";
        parameterString = parameterString + "samplingFraction: " + this.samplingFraction + "\n";
        parameterString = parameterString + "maxPixelWeight: " + this.maxPixelWeight + "\n";
        parameterString = parameterString + "coloringRule: " + this.coloringRule.getClass().getName() + "\n";
        parameterString = parameterString + "controlColorChannel: " + this.controlColorChannel + "\n";
        parameterString = parameterString + "useInverseRatioForControlColorChannel: " + this.useInverseRatioForControlColorChannel + "\n";
        parameterString = parameterString + "colorAlpha: " + this.colorAlpha + "\n";
        parameterString = parameterString + "datasetBoundary: " + this.datasetBoundary.toString() + "\n";
        parameterString = parameterString + "maxPartitionTreeLevel: " + this.maxPartitionTreeLevel + "\n";
        parameterString = parameterString + "overwriteExistingImages: " + this.overwriteExistingImages + "\n";
        parameterString = parameterString + "partitionIntervalX: " + this.partitionIntervalX + "\n";
        parameterString = parameterString + "partitionIntervalY: " + this.partitionIntervalY + "\n";
        parameterString = parameterString + "partitionsOnSingleAxis: " + this.partitionsOnSingleAxis + "\n";
        return parameterString;
    }
}

