/*
 * Decompiled with CFR 0.152.
 */
package org.datasyslab.geosparkviz.extension.visualizationEffect;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.Color;
import org.apache.log4j.Logger;
import org.apache.spark.api.java.JavaSparkContext;
import org.datasyslab.geospark.spatialRDD.SpatialRDD;
import org.datasyslab.geosparkviz.core.VisualizationOperator;
import org.datasyslab.geosparkviz.extension.photoFilter.GaussianBlur;
import org.datasyslab.geosparkviz.utils.ColorizeOption;

public class HeatMap
extends VisualizationOperator {
    static final Logger logger = Logger.getLogger(HeatMap.class);

    public HeatMap(int resolutionX, int resolutionY, Envelope datasetBoundary, boolean reverseSpatialCoordinate, int blurRadius) {
        super(resolutionX, resolutionY, datasetBoundary, ColorizeOption.SPATIALAGGREGATION, reverseSpatialCoordinate, -1, -1, false, false, false);
        GaussianBlur gaussianBlur = new GaussianBlur(blurRadius);
        this.InitPhotoFilterWeightMatrix(gaussianBlur);
    }

    public HeatMap(int resolutionX, int resolutionY, Envelope datasetBoundary, boolean reverseSpatialCoordinate, int blurRadius, int partitionX, int partitionY, boolean parallelPhotoFilter, boolean parallelRenderImage) {
        super(resolutionX, resolutionY, datasetBoundary, ColorizeOption.SPATIALAGGREGATION, reverseSpatialCoordinate, partitionX, partitionY, parallelPhotoFilter, parallelRenderImage, false);
        GaussianBlur gaussianBlur = new GaussianBlur(blurRadius);
        this.InitPhotoFilterWeightMatrix(gaussianBlur);
    }

    @Override
    protected Integer EncodeToRGB(int normailizedCount) throws Exception {
        int alpha = 150;
        Color[] colors = new Color[]{new Color(153, 255, 0, alpha), new Color(204, 255, 0, alpha), new Color(255, 255, 0, alpha), new Color(255, 204, 0, alpha), new Color(255, 153, 0, alpha), new Color(255, 102, 0, alpha), new Color(255, 51, 0, alpha), new Color(255, 0, 0, alpha)};
        if (normailizedCount < 1) {
            return new Color(255, 255, 255, 0).getRGB();
        }
        if (normailizedCount < 30) {
            return colors[0].getRGB();
        }
        if (normailizedCount < 50) {
            return colors[1].getRGB();
        }
        if (normailizedCount < 70) {
            return colors[2].getRGB();
        }
        if (normailizedCount < 100) {
            return colors[3].getRGB();
        }
        if (normailizedCount < 130) {
            return colors[4].getRGB();
        }
        if (normailizedCount < 160) {
            return colors[5].getRGB();
        }
        if (normailizedCount < 190) {
            return colors[6].getRGB();
        }
        return colors[7].getRGB();
    }

    public boolean Visualize(JavaSparkContext sparkContext, SpatialRDD spatialRDD) throws Exception {
        logger.info((Object)"[GeoSparkViz][Visualize][Start]");
        this.CustomizeColor(255, 255, 0, 255, Color.GREEN, true);
        this.Rasterize(sparkContext, spatialRDD, true);
        this.ApplyPhotoFilter(sparkContext);
        this.Colorize();
        this.RenderImage(sparkContext);
        logger.info((Object)"[GeoSparkViz][Visualize][Stop]");
        return true;
    }
}

