/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.graphics2d.svg;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.jfree.graphics2d.Args;
import org.jfree.graphics2d.svg.FontMapper;

public class StandardFontMapper
implements FontMapper,
Serializable {
    private Map<String, String> alternates = new HashMap<String, String>();

    public StandardFontMapper() {
        this.alternates.put("Dialog", "sans-serif");
        this.alternates.put("DialogInput", "monospace");
        this.alternates.put("SansSerif", "sans-serif");
        this.alternates.put("Serif", "serif");
        this.alternates.put("Monospaced", "monospace");
    }

    public String get(String family) {
        Args.nullNotPermitted(family, "family");
        return this.alternates.get(family);
    }

    public void put(String family, String alternate) {
        Args.nullNotPermitted(family, "family");
        this.alternates.put(family, alternate);
    }

    @Override
    public String mapFont(String family) {
        Args.nullNotPermitted(family, "family");
        String alternate = this.alternates.get(family);
        if (alternate != null) {
            return alternate;
        }
        return family;
    }
}

