/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.cloud.microsoft.cosmos;

import com.microsoft.azure.AzureEnvironment;
import com.microsoft.azure.credentials.ApplicationTokenCredentials;
import com.microsoft.azure.keyvault.KeyVaultClient;
import com.microsoft.azure.keyvault.models.SecretBundle;
import com.microsoft.rest.credentials.ServiceClientCredentials;
import java.io.IOException;
import org.datatransferproject.spi.cloud.storage.AppCredentialStore;
import org.datatransferproject.types.transfer.auth.AppCredentials;

public class AzureKeyVaultStore
implements AppCredentialStore {
    private static final String VAULT_ADDRESS = "https://%s.vault.azure.net/";
    private final String vaultUrl;
    private final KeyVaultClient vaultClient;

    public AzureKeyVaultStore(String keyVaultName, String tenantId, String clientId, String clientSecret) {
        this.vaultUrl = String.format(VAULT_ADDRESS, keyVaultName);
        ApplicationTokenCredentials credentials = new ApplicationTokenCredentials(clientId, tenantId, clientSecret, AzureEnvironment.AZURE);
        this.vaultClient = new KeyVaultClient((ServiceClientCredentials)credentials);
    }

    public AppCredentials getAppCredentials(String keyName, String secretName) throws IOException {
        String normalizedKey = AzureKeyVaultStore.normalize(keyName);
        SecretBundle keyBundle = this.vaultClient.getSecret(this.vaultUrl, normalizedKey);
        if (keyBundle == null) {
            throw new IOException("Key not found: " + secretName);
        }
        String keyValue = keyBundle.value();
        String normalizedSecret = AzureKeyVaultStore.normalize(secretName);
        SecretBundle secretBundle = this.vaultClient.getSecret(this.vaultUrl, normalizedSecret);
        if (secretBundle == null) {
            throw new IOException("Key not found: " + secretName);
        }
        String secretValue = secretBundle.value();
        return new AppCredentials(keyValue, secretValue);
    }

    public String getSecret(String key) {
        String normalizedKey = AzureKeyVaultStore.normalize(key);
        SecretBundle secretBundle = this.vaultClient.getSecret(this.vaultUrl, normalizedKey);
        return secretBundle == null ? null : secretBundle.value();
    }

    private static String normalize(String key) {
        return key.replace("_", "");
    }
}

