/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.cloud.microsoft.cosmos;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.microsoft.azure.storage.CloudStorageAccount;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.blob.CloudBlobClient;
import com.microsoft.azure.storage.blob.CloudBlobContainer;
import com.microsoft.azure.storage.blob.CloudBlockBlob;
import com.microsoft.azure.storage.table.CloudTable;
import com.microsoft.azure.storage.table.CloudTableClient;
import com.microsoft.azure.storage.table.TableEntity;
import com.microsoft.azure.storage.table.TableOperation;
import com.microsoft.azure.storage.table.TableQuery;
import com.microsoft.azure.storage.table.TableResult;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.util.Collection;
import java.util.Iterator;
import java.util.UUID;
import org.datatransferproject.cloud.microsoft.cosmos.DataWrapper;
import org.datatransferproject.cloud.microsoft.cosmos.MicrosoftStorageException;
import org.datatransferproject.cloud.microsoft.cosmos.TableStoreConfiguration;
import org.datatransferproject.spi.cloud.storage.JobStoreWithValidator;
import org.datatransferproject.spi.cloud.storage.TemporaryPerJobDataStore;
import org.datatransferproject.spi.cloud.types.JobAuthorization;
import org.datatransferproject.spi.cloud.types.PortabilityJob;
import org.datatransferproject.types.common.models.DataModel;
import org.datatransferproject.types.transfer.errors.ErrorDetail;

public class AzureTableStore
extends JobStoreWithValidator {
    private static final String COSMOS_CONNECTION_TEMPLATE = "DefaultEndpointsProtocol=https;AccountName=%s;AccountKey=%s;TableEndpoint=%s;";
    private static final String ENDPOINT_TEMPLATE = "https://%s.table.cosmosdb.azure.com:443/";
    private static final String BLOB_CONNECTION_TEMPLATE = "DefaultEndpointsProtocol=https;AccountName=%s;AccountKey=%s;";
    private static final String JOB_TABLE = "DP_JOBS";
    private static final String JOB_DATA_TABLE = "DP_JOB_DATA";
    private static final String BLOB_CONTAINER = "dataportability";
    private static final int UNKNOWN_LENGTH = -1;
    private final TableStoreConfiguration configuration;
    private CloudTableClient tableClient;
    private CloudBlobClient blobClient;

    public AzureTableStore(TableStoreConfiguration configuration) {
        this.configuration = configuration;
    }

    public void init() {
        try {
            String endpoint = String.format(ENDPOINT_TEMPLATE, this.configuration.getAccountName());
            CloudStorageAccount cosmosAccount = CloudStorageAccount.parse((String)String.format(COSMOS_CONNECTION_TEMPLATE, this.configuration.getAccountName(), this.configuration.getAccountKey(), endpoint));
            this.tableClient = cosmosAccount.createCloudTableClient();
            this.tableClient.getTableReference(JOB_TABLE).createIfNotExists();
            this.tableClient.getTableReference(JOB_DATA_TABLE).createIfNotExists();
            CloudStorageAccount blobAccount = CloudStorageAccount.parse((String)String.format(BLOB_CONNECTION_TEMPLATE, this.configuration.getAccountName(), this.configuration.getBlobKey()));
            this.blobClient = blobAccount.createCloudBlobClient();
            this.blobClient.getContainerReference(BLOB_CONTAINER).createIfNotExists();
        }
        catch (StorageException | URISyntaxException | InvalidKeyException e) {
            throw new MicrosoftStorageException(e);
        }
    }

    public void createJob(UUID jobId, PortabilityJob job) throws IOException {
        Preconditions.checkNotNull((Object)jobId, (Object)"Job id is null");
        Preconditions.checkNotNull((Object)job, (Object)"Job is null");
        try {
            this.create(jobId.toString(), JOB_TABLE, job.jobAuthorization().state().name(), job);
        }
        catch (JsonProcessingException e) {
            throw new IOException("Error creating job: " + jobId, e);
        }
    }

    public void updateJob(UUID jobId, PortabilityJob job) throws IOException {
        this.updateJob(jobId, job, null);
    }

    protected void updateJob(UUID jobId, PortabilityJob job, JobStoreWithValidator.JobUpdateValidator validator) throws IOException {
        Preconditions.checkNotNull((Object)jobId, (Object)"Job is null");
        Preconditions.checkNotNull((Object)job, (Object)"Job is null");
        try {
            CloudTable table = this.tableClient.getTableReference(JOB_TABLE);
            String serializedJob = this.configuration.getMapper().writeValueAsString((Object)job);
            DataWrapper wrapper = new DataWrapper(this.configuration.getPartitionKey(), jobId.toString(), job.jobAuthorization().state().name(), serializedJob);
            if (validator != null) {
                PortabilityJob previousJob = this.findJob(jobId);
                if (previousJob == null) {
                    throw new IOException("Could not find record for jobId: " + jobId);
                }
                validator.validate(previousJob, job);
            }
            TableOperation insert = TableOperation.insertOrReplace((TableEntity)wrapper);
            table.execute(insert);
        }
        catch (JsonProcessingException | StorageException | URISyntaxException e) {
            throw new IOException("Error updating job: " + jobId, e);
        }
    }

    public void addErrorsToJob(UUID jobId, Collection<ErrorDetail> errors) throws IOException {
        throw new IOException("Adding errors not yet implemented for Azure");
    }

    public PortabilityJob findJob(UUID jobId) {
        Preconditions.checkNotNull((Object)jobId, (Object)"Job id is null");
        try {
            CloudTable table = this.tableClient.getTableReference(JOB_TABLE);
            TableOperation retrieve = TableOperation.retrieve((String)this.configuration.getPartitionKey(), (String)jobId.toString(), DataWrapper.class);
            TableResult result = table.execute(retrieve);
            DataWrapper wrapper = (DataWrapper)((Object)result.getResultAsType());
            return (PortabilityJob)this.configuration.getMapper().readValue(wrapper.getSerialized(), PortabilityJob.class);
        }
        catch (StorageException | IOException | URISyntaxException e) {
            throw new MicrosoftStorageException("Error finding job: " + jobId, e);
        }
    }

    public void remove(UUID jobId) throws IOException {
        Preconditions.checkNotNull((Object)jobId, (Object)"Job id is null");
        this.remove(jobId, JOB_TABLE);
    }

    public <T extends DataModel> void create(UUID jobId, String key, T model) {
        try {
            this.create(AzureTableStore.createRowKey(jobId, key), JOB_DATA_TABLE, null, model);
        }
        catch (IOException e) {
            throw new MicrosoftStorageException("Error creating job: " + jobId, e);
        }
    }

    public <T extends DataModel> void update(UUID jobId, String key, T model) {
        throw new UnsupportedOperationException("Implement update functionality. ");
    }

    public <T extends DataModel> T findData(UUID jobId, String key, Class<T> type) {
        return (T)((DataModel)this.find(type, AzureTableStore.createRowKey(jobId, key), JOB_DATA_TABLE));
    }

    public void removeData(UUID jobId, String key) {
        try {
            this.remove(jobId, JOB_DATA_TABLE);
        }
        catch (IOException e) {
            throw new MicrosoftStorageException("Unable to remove data for job: " + jobId);
        }
    }

    public void create(UUID jobId, String key, InputStream stream) {
        try {
            CloudBlobContainer reference = this.blobClient.getContainerReference(BLOB_CONTAINER);
            CloudBlockBlob blob = reference.getBlockBlobReference(AzureTableStore.createRowKey(jobId, key));
            blob.upload(stream, -1L);
        }
        catch (StorageException | IOException | URISyntaxException e) {
            throw new MicrosoftStorageException("Error creating stream for job: " + jobId, e);
        }
    }

    public TemporaryPerJobDataStore.InputStreamWrapper getStream(UUID jobId, String key) {
        try {
            CloudBlobContainer reference = this.blobClient.getContainerReference(BLOB_CONTAINER);
            CloudBlockBlob blob = reference.getBlockBlobReference(AzureTableStore.createRowKey(jobId, key));
            return new TemporaryPerJobDataStore.InputStreamWrapper((InputStream)blob.openInputStream(), Long.valueOf(blob.getProperties().getLength()));
        }
        catch (StorageException | URISyntaxException e) {
            throw new MicrosoftStorageException("Error returning stream for job: " + jobId, e);
        }
    }

    public UUID findFirst(JobAuthorization.State jobState) {
        try {
            String partitionFilter = TableQuery.generateFilterCondition((String)"PartitionKey", (String)"eq", (String)this.configuration.getPartitionKey());
            String stateFilter = TableQuery.generateFilterCondition((String)"State", (String)"eq", (String)jobState.name());
            String combinedFilter = TableQuery.combineFilters((String)partitionFilter, (String)"and", (String)stateFilter);
            TableQuery query = TableQuery.from(DataWrapper.class).where(combinedFilter).take(Integer.valueOf(1));
            CloudTable table = this.tableClient.getTableReference(JOB_TABLE);
            Iterator iter = table.execute(query).iterator();
            if (!iter.hasNext()) {
                return null;
            }
            return UUID.fromString(((DataWrapper)((Object)iter.next())).getRowKey());
        }
        catch (StorageException | URISyntaxException e) {
            throw new MicrosoftStorageException("Error finding first job", e);
        }
    }

    private void create(String rowKey, String tableName, String state, Object type) throws IOException {
        try {
            CloudTable table = this.tableClient.getTableReference(tableName);
            String serializedJob = this.configuration.getMapper().writeValueAsString(type);
            DataWrapper wrapper = new DataWrapper(this.configuration.getPartitionKey(), rowKey, state, serializedJob);
            TableOperation insert = TableOperation.insert((TableEntity)wrapper);
            table.execute(insert);
        }
        catch (JsonProcessingException | StorageException | URISyntaxException e) {
            throw new IOException("Error creating data for rowKey: " + rowKey, e);
        }
    }

    private void remove(UUID jobId, String tableName) throws IOException {
        try {
            CloudTable table = this.tableClient.getTableReference(tableName);
            TableOperation retrieve = TableOperation.retrieve((String)this.configuration.getPartitionKey(), (String)jobId.toString(), DataWrapper.class);
            TableResult result = table.execute(retrieve);
            DataWrapper wrapper = (DataWrapper)((Object)result.getResultAsType());
            TableOperation delete = TableOperation.delete((TableEntity)wrapper);
            table.execute(delete);
        }
        catch (StorageException | URISyntaxException e) {
            throw new IOException("Error removing data for job: " + jobId, e);
        }
    }

    private <T> T find(Class<T> type, String rowKey, String tableName) {
        try {
            CloudTable table = this.tableClient.getTableReference(tableName);
            TableOperation retrieve = TableOperation.retrieve((String)this.configuration.getPartitionKey(), (String)rowKey, DataWrapper.class);
            TableResult result = table.execute(retrieve);
            DataWrapper wrapper = (DataWrapper)((Object)result.getResultAsType());
            return (T)this.configuration.getMapper().readValue(wrapper.getSerialized(), type);
        }
        catch (StorageException | IOException | URISyntaxException e) {
            throw new MicrosoftStorageException("Error finding data for rowKey: " + rowKey, e);
        }
    }

    private static String createRowKey(UUID jobId, String key) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)key) ? 1 : 0) != 0);
        return String.format("%s-%s", jobId.toString(), key);
    }
}

