/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.cloud.microsoft.cosmos;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Objects;
import org.datatransferproject.api.launcher.ExtensionContext;
import org.datatransferproject.cloud.microsoft.cosmos.AzureKeyVaultStore;
import org.datatransferproject.cloud.microsoft.cosmos.AzureTableStore;
import org.datatransferproject.cloud.microsoft.cosmos.MicrosoftStorageException;
import org.datatransferproject.cloud.microsoft.cosmos.TableStoreConfiguration;
import org.datatransferproject.spi.cloud.extension.CloudExtension;
import org.datatransferproject.spi.cloud.storage.AppCredentialStore;
import org.datatransferproject.spi.cloud.storage.JobStore;

public class MicrosoftCloudExtension
implements CloudExtension {
    static final String AZURE_VAULT_NAME = "AZURE_VAULT_NAME";
    static final String AZURE_VAULT_TENANT_ID = "AZURE_VAULT_TENANT_ID";
    static final String AZURE_VAULT_CLIENT_ID = "AZURE_VAULT_CLIENT_ID";
    static final String AZURE_VAULT_CLIENT_SECRET = "AZURE_VAULT_CLIENT_SECRET";
    static final String AZURE_COSMOS_ACCOUNT_NAME = "AZURE_COSMOS_ACCOUNT_NAME";
    static final String AZURE_COSMOS_PARTITION_KEY = "AZURE_COSMOS_PARTITION_KEY";
    static final String AZURE_COSMOS_ACCOUNT_KEY = "TABLESTOREACCOUNTKEY";
    static final String AZURE_BLOB_KEY = "AZUREBLOBKEY";
    private AzureTableStore jobStore;
    private AzureKeyVaultStore vaultStore;

    public void initialize(ExtensionContext context) {
        String vaultName = this.loadSecretValue(AZURE_VAULT_NAME, true);
        String tenantId = this.loadSecretValue(AZURE_VAULT_TENANT_ID, true);
        String clientId = this.loadSecretValue(AZURE_VAULT_CLIENT_ID, true);
        String clientSecret = this.loadSecretValue(AZURE_VAULT_CLIENT_SECRET, true);
        this.vaultStore = new AzureKeyVaultStore(vaultName, tenantId, clientId, clientSecret);
        TableStoreConfiguration.Builder builder = TableStoreConfiguration.Builder.newInstance();
        String accountKey = this.getVaultKey(AZURE_COSMOS_ACCOUNT_KEY);
        builder.accountKey(accountKey);
        String blobKey = this.getVaultKey(AZURE_BLOB_KEY);
        builder.blobKey(blobKey);
        String accountName = this.loadSecretValue(AZURE_COSMOS_ACCOUNT_NAME, true);
        builder.accountName(accountName);
        String partitionKey = this.loadSecretValue(AZURE_COSMOS_PARTITION_KEY, false);
        if (partitionKey == null) {
            partitionKey = "DefaultPartition";
        }
        builder.partitionKey(partitionKey);
        ObjectMapper mapper = context.getTypeManager().getMapper();
        builder.mapper(mapper);
        this.jobStore = new AzureTableStore(builder.build());
        this.jobStore.init();
    }

    public JobStore getJobStore() {
        return this.jobStore;
    }

    public AppCredentialStore getAppCredentialStore() {
        return this.vaultStore;
    }

    private String getVaultKey(String key) {
        String secret = this.vaultStore.getSecret(key);
        if (secret == null) {
            throw new MicrosoftStorageException("Unable to retrieve secret from Azure Vault: " + key);
        }
        return secret;
    }

    private String loadSecretValue(String key, boolean required) {
        String tenantId = System.getenv(key);
        if (tenantId == null) {
            tenantId = System.getProperty(key);
        }
        if (required) {
            Objects.requireNonNull(tenantId, key + " not set in environment or configuration");
        }
        return tenantId;
    }
}

