/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.cloud.microsoft.cosmos;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;

class TableStoreConfiguration {
    private String accountName;
    private String accountKey;
    private String blobKey;
    private String partitionKey;
    private ObjectMapper mapper;

    TableStoreConfiguration() {
    }

    public String getAccountName() {
        return this.accountName;
    }

    public String getAccountKey() {
        return this.accountKey;
    }

    public String getPartitionKey() {
        return this.partitionKey;
    }

    public String getBlobKey() {
        return this.blobKey;
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public static class Builder {
        private final TableStoreConfiguration configuration = new TableStoreConfiguration();

        public static Builder newInstance() {
            return new Builder();
        }

        public Builder accountName(String accountName) {
            this.configuration.accountName = accountName;
            return this;
        }

        public Builder accountKey(String accountKey) {
            this.configuration.accountKey = accountKey;
            return this;
        }

        public Builder partitionKey(String partitionKey) {
            this.configuration.partitionKey = partitionKey;
            return this;
        }

        public Builder blobKey(String blobKey) {
            this.configuration.blobKey = blobKey;
            return this;
        }

        public Builder mapper(ObjectMapper mapper) {
            this.configuration.mapper = mapper;
            return this;
        }

        public TableStoreConfiguration build() {
            Preconditions.checkNotNull((Object)this.configuration.accountName);
            Preconditions.checkNotNull((Object)this.configuration.accountKey);
            Preconditions.checkNotNull((Object)this.configuration.partitionKey);
            Preconditions.checkNotNull((Object)this.configuration.blobKey);
            Preconditions.checkNotNull((Object)this.configuration.mapper);
            return this.configuration;
        }

        private Builder() {
        }
    }
}

