/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.nlp.annotator;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import opennlp.tools.postag.POSModel;
import opennlp.tools.postag.POSTaggerME;
import opennlp.uima.postag.POSModelResource;
import opennlp.uima.postag.POSModelResourceImpl;
import opennlp.uima.util.AnnotationComboIterator;
import opennlp.uima.util.AnnotationIteratorPair;
import opennlp.uima.util.AnnotatorUtil;
import opennlp.uima.util.UimaUtil;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.component.CasAnnotator_ImplBase;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.factory.ExternalResourceFactory;
import org.apache.uima.resource.ResourceAccessException;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;
import org.cleartk.token.type.Sentence;
import org.cleartk.token.type.Token;
import org.datavec.nlp.movingwindow.Util;

public class PoStagger
extends CasAnnotator_ImplBase {
    private POSTaggerME posTagger;
    private Type sentenceType;
    private Type tokenType;
    private Feature posFeature;
    private Feature probabilityFeature;
    private UimaContext context;
    private Logger logger;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        POSModel model;
        super.initialize(context);
        this.context = context;
        this.logger = context.getLogger();
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.log(Level.INFO, "Initializing the OpenNLP Part of Speech annotator.");
        }
        try {
            POSModelResource modelResource = (POSModelResource)context.getResourceObject(UimaUtil.MODEL_PARAMETER);
            model = modelResource.getModel();
        }
        catch (ResourceAccessException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
        Integer beamSize = AnnotatorUtil.getOptionalIntegerParameter((UimaContext)context, (String)"opennlp.uima.BeamSize");
        if (beamSize == null) {
            beamSize = 3;
        }
        this.posTagger = new POSTaggerME(model, beamSize.intValue(), 0);
    }

    public void typeSystemInit(TypeSystem typeSystem) throws AnalysisEngineProcessException {
        this.sentenceType = AnnotatorUtil.getRequiredTypeParameter((UimaContext)this.context, (TypeSystem)typeSystem, (String)UimaUtil.SENTENCE_TYPE_PARAMETER);
        this.tokenType = AnnotatorUtil.getRequiredTypeParameter((UimaContext)this.context, (TypeSystem)typeSystem, (String)"opennlp.uima.TokenType");
        this.posFeature = AnnotatorUtil.getRequiredFeatureParameter((UimaContext)this.context, (Type)this.tokenType, (String)"opennlp.uima.POSFeature", (String)"uima.cas.String");
        this.probabilityFeature = AnnotatorUtil.getOptionalFeatureParameter((UimaContext)this.context, (Type)this.tokenType, (String)"opennlp.uima.ProbabilityFeature", (String)"uima.cas.Double");
    }

    public synchronized void process(CAS tcas) {
        AnnotationComboIterator comboIterator = new AnnotationComboIterator(tcas, this.sentenceType, this.tokenType);
        for (AnnotationIteratorPair annotationIteratorPair : comboIterator) {
            LinkedList<AnnotationFS> sentenceTokenAnnotationList = new LinkedList<AnnotationFS>();
            LinkedList<String> sentenceTokenList = new LinkedList<String>();
            for (AnnotationFS tokenAnnotation : annotationIteratorPair.getSubIterator()) {
                sentenceTokenAnnotationList.add(tokenAnnotation);
                sentenceTokenList.add(tokenAnnotation.getCoveredText());
            }
            List posTags = this.posTagger.tag(sentenceTokenList);
            double[] posProbabilities = null;
            if (this.probabilityFeature != null) {
                posProbabilities = this.posTagger.probs();
            }
            Iterator posTagIterator = posTags.iterator();
            Iterator sentenceTokenIterator = sentenceTokenAnnotationList.iterator();
            int index = 0;
            while (posTagIterator.hasNext() && sentenceTokenIterator.hasNext()) {
                String posTag = (String)posTagIterator.next();
                AnnotationFS tokenAnnotation = (AnnotationFS)sentenceTokenIterator.next();
                tokenAnnotation.setStringValue(this.posFeature, posTag);
                if (posProbabilities != null) {
                    tokenAnnotation.setDoubleValue(this.posFeature, posProbabilities[index]);
                }
                ++index;
            }
            if (!this.logger.isLoggable(Level.FINER)) continue;
            StringBuilder sentenceWithPos = new StringBuilder();
            sentenceWithPos.append("\"");
            for (AnnotationFS token : sentenceTokenAnnotationList) {
                sentenceWithPos.append(token.getCoveredText());
                sentenceWithPos.append('\\');
                sentenceWithPos.append(token.getStringValue(this.posFeature));
                sentenceWithPos.append(' ');
            }
            if (sentenceWithPos.length() > 1) {
                sentenceWithPos.setLength(sentenceWithPos.length() - 1);
            }
            sentenceWithPos.append("\"");
            this.logger.log(Level.FINER, sentenceWithPos.toString());
        }
    }

    public void destroy() {
        this.posTagger = null;
    }

    public static AnalysisEngineDescription getDescription(String languageCode) throws ResourceInitializationException {
        String modelPath = String.format("/models/%s-pos-maxent.bin", languageCode);
        return AnalysisEngineFactory.createEngineDescription(PoStagger.class, (Object[])new Object[]{UimaUtil.MODEL_PARAMETER, ExternalResourceFactory.createExternalResourceDescription(POSModelResourceImpl.class, (String)PoStagger.class.getResource(modelPath).toString(), (Object[])new Object[0]), UimaUtil.SENTENCE_TYPE_PARAMETER, Sentence.class.getName(), "opennlp.uima.TokenType", Token.class.getName(), "opennlp.uima.POSFeature", "pos"});
    }

    static {
        Util.disableLogging();
    }
}

