/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.nlp.metadata;

import org.datavec.api.conf.Configuration;
import org.datavec.nlp.metadata.VocabCache;
import org.nd4j.linalg.primitives.Counter;
import org.nd4j.linalg.util.MathUtils;
import org.nd4j.util.Index;

public class DefaultVocabCache
implements VocabCache {
    private Counter<String> wordFrequencies = new Counter();
    private Counter<String> docFrequencies = new Counter();
    private int minWordFrequency;
    private Index vocabWords = new Index();
    private double numDocs = 0.0;

    public DefaultVocabCache(int minWordFrequency) {
        this.minWordFrequency = minWordFrequency;
    }

    public DefaultVocabCache() {
    }

    @Override
    public void incrementNumDocs(double by) {
        this.numDocs += by;
    }

    @Override
    public double numDocs() {
        return this.numDocs;
    }

    @Override
    public String wordAt(int i) {
        return this.vocabWords.get(i).toString();
    }

    @Override
    public int wordIndex(String word) {
        return this.vocabWords.indexOf((Object)word);
    }

    @Override
    public void initialize(Configuration conf) {
        this.minWordFrequency = conf.getInt("org.nd4j.nlp.minwordfrequency", 5);
    }

    @Override
    public double wordFrequency(String word) {
        return this.wordFrequencies.getCount((Object)word);
    }

    @Override
    public int minWordFrequency() {
        return this.minWordFrequency;
    }

    @Override
    public Index vocabWords() {
        return this.vocabWords;
    }

    @Override
    public void incrementDocCount(String word) {
        this.incrementDocCount(word, 1.0);
    }

    @Override
    public void incrementDocCount(String word, double by) {
        this.docFrequencies.incrementCount((Object)word, by);
    }

    @Override
    public void incrementCount(String word) {
        this.incrementCount(word, 1.0);
    }

    @Override
    public void incrementCount(String word, double by) {
        this.wordFrequencies.incrementCount((Object)word, by);
        if (this.wordFrequencies.getCount((Object)word) >= (double)this.minWordFrequency && this.vocabWords.indexOf((Object)word) < 0) {
            this.vocabWords.add((Object)word);
        }
    }

    @Override
    public double idf(String word) {
        return this.docFrequencies.getCount((Object)word);
    }

    @Override
    public double tfidf(String word, double frequency, boolean smoothIdf) {
        double tf = DefaultVocabCache.tf((int)frequency);
        double docFreq = this.docFrequencies.getCount((Object)word);
        double idf = this.idf(this.numDocs, docFreq, smoothIdf);
        double tfidf = MathUtils.tfidf((double)tf, (double)idf);
        return tfidf;
    }

    public double idf(double totalDocs, double numTimesWordAppearedInADocument, boolean smooth) {
        if (smooth) {
            return Math.log((1.0 + totalDocs) / (1.0 + numTimesWordAppearedInADocument)) + 1.0;
        }
        return Math.log(totalDocs / numTimesWordAppearedInADocument) + 1.0;
    }

    public static double tf(int count) {
        return count;
    }

    public int getMinWordFrequency() {
        return this.minWordFrequency;
    }

    public void setMinWordFrequency(int minWordFrequency) {
        this.minWordFrequency = minWordFrequency;
    }
}

