/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.nlp.movingwindow;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;
import org.datavec.nlp.movingwindow.Window;
import org.datavec.nlp.tokenization.tokenizer.DefaultStreamTokenizer;
import org.datavec.nlp.tokenization.tokenizer.Tokenizer;
import org.datavec.nlp.tokenization.tokenizerfactory.TokenizerFactory;

public class Windows {
    public static List<Window> windows(InputStream words, int windowSize) {
        DefaultStreamTokenizer tokenizer = new DefaultStreamTokenizer(words);
        ArrayList<String> list = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            list.add(tokenizer.nextToken());
        }
        return Windows.windows(list, windowSize);
    }

    public static List<Window> windows(InputStream words, TokenizerFactory tokenizerFactory, int windowSize) {
        Tokenizer tokenizer = tokenizerFactory.create(words);
        ArrayList<String> list = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            list.add(tokenizer.nextToken());
        }
        if (list.isEmpty()) {
            throw new IllegalStateException("No tokens found for windows");
        }
        return Windows.windows(list, windowSize);
    }

    public static List<Window> windows(String words, int windowSize) {
        StringTokenizer tokenizer = new StringTokenizer(words);
        ArrayList<String> list = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            list.add(tokenizer.nextToken());
        }
        return Windows.windows(list, windowSize);
    }

    public static List<Window> windows(String words, TokenizerFactory tokenizerFactory, int windowSize) {
        Tokenizer tokenizer = tokenizerFactory.create(words);
        ArrayList<String> list = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            list.add(tokenizer.nextToken());
        }
        if (list.isEmpty()) {
            throw new IllegalStateException("No tokens found for windows");
        }
        return Windows.windows(list, windowSize);
    }

    public static List<Window> windows(String words) {
        StringTokenizer tokenizer = new StringTokenizer(words);
        ArrayList<String> list = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            list.add(tokenizer.nextToken());
        }
        return Windows.windows(list, 5);
    }

    public static List<Window> windows(String words, TokenizerFactory tokenizerFactory) {
        Tokenizer tokenizer = tokenizerFactory.create(words);
        ArrayList<String> list = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            list.add(tokenizer.nextToken());
        }
        return Windows.windows(list, 5);
    }

    public static Window windowForWordInPosition(int windowSize, int wordPos, List<String> sentence) {
        ArrayList<String> window = new ArrayList<String>();
        ArrayList<String> onlyTokens = new ArrayList<String>();
        int contextSize = (int)Math.floor((windowSize - 1) / 2);
        for (int i = wordPos - contextSize; i <= wordPos + contextSize; ++i) {
            if (i < 0) {
                window.add("<s>");
                continue;
            }
            if (i >= sentence.size()) {
                window.add("</s>");
                continue;
            }
            onlyTokens.add(sentence.get(i));
            window.add(sentence.get(i));
        }
        String wholeSentence = StringUtils.join((Object[])new List[]{sentence});
        String window2 = StringUtils.join((Object[])new List[]{onlyTokens});
        int begin = wholeSentence.indexOf(window2);
        int end = begin + window2.length();
        return new Window(window, begin, end);
    }

    public static List<Window> windows(List<String> words, int windowSize) {
        ArrayList<Window> ret = new ArrayList<Window>();
        for (int i = 0; i < words.size(); ++i) {
            ret.add(Windows.windowForWordInPosition(windowSize, i, words));
        }
        return ret;
    }
}

