/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.nlp.reader;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.datavec.api.conf.Configuration;
import org.datavec.api.records.impl.Record;
import org.datavec.api.records.metadata.RecordMetaData;
import org.datavec.api.records.metadata.RecordMetaDataURI;
import org.datavec.api.records.reader.RecordReader;
import org.datavec.api.records.reader.impl.FileRecordReader;
import org.datavec.api.split.InputSplit;
import org.datavec.api.vector.Vectorizer;
import org.datavec.api.writable.NDArrayWritable;
import org.datavec.api.writable.Writable;
import org.datavec.nlp.vectorizer.TfidfVectorizer;
import org.nd4j.linalg.api.ndarray.INDArray;

public class TfidfRecordReader
extends FileRecordReader {
    private TfidfVectorizer tfidfVectorizer;
    private List<org.datavec.api.records.Record> records = new ArrayList<org.datavec.api.records.Record>();
    private Iterator<org.datavec.api.records.Record> recordIter;
    private int numFeatures;
    private boolean initialized = false;

    public void initialize(InputSplit split) throws IOException, InterruptedException {
        this.initialize(new Configuration(), split);
    }

    public void initialize(Configuration conf, InputSplit split) throws IOException, InterruptedException {
        super.initialize(conf, split);
        if (this.tfidfVectorizer == null) {
            this.tfidfVectorizer = new TfidfVectorizer();
            this.tfidfVectorizer.initialize(conf);
            this.records.clear();
            INDArray ret = this.tfidfVectorizer.fitTransform((RecordReader)this, new Vectorizer.RecordCallBack(){

                public void onRecord(org.datavec.api.records.Record fullRecord) {
                    TfidfRecordReader.this.records.add(fullRecord);
                }
            });
            this.numFeatures = ret.columns();
            this.recordIter = this.records.iterator();
        } else {
            this.records = new ArrayList<org.datavec.api.records.Record>();
            while (super.hasNext()) {
                org.datavec.api.records.Record fileContents = super.nextRecord();
                INDArray transform = this.tfidfVectorizer.transform(fileContents);
                Record record = new Record(new ArrayList<NDArrayWritable>(Collections.singletonList(new NDArrayWritable(transform))), (RecordMetaData)new RecordMetaDataURI(fileContents.getMetaData().getURI(), TfidfRecordReader.class));
                if (this.appendLabel) {
                    record.getRecord().add(fileContents.getRecord().get(fileContents.getRecord().size() - 1));
                }
                this.records.add((org.datavec.api.records.Record)record);
            }
            this.recordIter = this.records.iterator();
        }
        this.initialized = true;
    }

    public void reset() {
        if (this.inputSplit == null) {
            throw new UnsupportedOperationException("Cannot reset without first initializing");
        }
        this.recordIter = this.records.iterator();
    }

    public org.datavec.api.records.Record nextRecord() {
        if (this.recordIter == null) {
            return super.nextRecord();
        }
        return this.recordIter.next();
    }

    public List<Writable> next() {
        return this.nextRecord().getRecord();
    }

    public boolean hasNext() {
        if (this.recordIter == null) {
            return super.hasNext();
        }
        return this.recordIter.hasNext();
    }

    public void close() throws IOException {
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public TfidfVectorizer getTfidfVectorizer() {
        return this.tfidfVectorizer;
    }

    public void setTfidfVectorizer(TfidfVectorizer tfidfVectorizer) {
        if (this.initialized) {
            throw new IllegalArgumentException("Setting TfidfVectorizer after TfidfRecordReader initialization doesn't have an effect");
        }
        this.tfidfVectorizer = tfidfVectorizer;
    }

    public int getNumFeatures() {
        return this.numFeatures;
    }

    public void shuffle() {
        this.shuffle(new Random());
    }

    public void shuffle(Random random) {
        Collections.shuffle(this.records, random);
        this.reset();
    }

    public org.datavec.api.records.Record loadFromMetaData(RecordMetaData recordMetaData) throws IOException {
        return this.loadFromMetaData(Collections.singletonList(recordMetaData)).get(0);
    }

    public List<org.datavec.api.records.Record> loadFromMetaData(List<RecordMetaData> recordMetaDatas) throws IOException {
        ArrayList<org.datavec.api.records.Record> out = new ArrayList<org.datavec.api.records.Record>();
        for (org.datavec.api.records.Record fileContents : super.loadFromMetaData(recordMetaDatas)) {
            INDArray transform = this.tfidfVectorizer.transform(fileContents);
            Record record = new Record(new ArrayList<NDArrayWritable>(Collections.singletonList(new NDArrayWritable(transform))), (RecordMetaData)new RecordMetaDataURI(fileContents.getMetaData().getURI(), TfidfRecordReader.class));
            if (this.appendLabel) {
                record.getRecord().add(fileContents.getRecord().get(fileContents.getRecord().size() - 1));
            }
            out.add((org.datavec.api.records.Record)record);
        }
        return out;
    }
}

