/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.nlp.tokenization.tokenizer;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.List;
import org.datavec.nlp.tokenization.tokenizer.TokenPreProcess;
import org.datavec.nlp.tokenization.tokenizer.Tokenizer;

public class DefaultStreamTokenizer
implements Tokenizer {
    private StreamTokenizer streamTokenizer;
    private TokenPreProcess tokenPreProcess;

    public DefaultStreamTokenizer(InputStream is) {
        BufferedReader r = new BufferedReader(new InputStreamReader(is));
        this.streamTokenizer = new StreamTokenizer(r);
    }

    @Override
    public boolean hasMoreTokens() {
        if (this.streamTokenizer.ttype != -1) {
            try {
                this.streamTokenizer.nextToken();
            }
            catch (IOException e1) {
                throw new RuntimeException(e1);
            }
        }
        return this.streamTokenizer.ttype != -1 && this.streamTokenizer.ttype != -1;
    }

    @Override
    public int countTokens() {
        return this.getTokens().size();
    }

    @Override
    public String nextToken() {
        StringBuilder sb = new StringBuilder();
        if (this.streamTokenizer.ttype == -3) {
            sb.append(this.streamTokenizer.sval);
        } else if (this.streamTokenizer.ttype == -2) {
            sb.append(this.streamTokenizer.nval);
        } else if (this.streamTokenizer.ttype == 10) {
            try {
                while (this.streamTokenizer.ttype == 10) {
                    this.streamTokenizer.nextToken();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else if (this.hasMoreTokens()) {
            return this.nextToken();
        }
        String ret = sb.toString();
        if (this.tokenPreProcess != null) {
            ret = this.tokenPreProcess.preProcess(ret);
        }
        return ret;
    }

    @Override
    public List<String> getTokens() {
        ArrayList<String> tokens = new ArrayList<String>();
        while (this.hasMoreTokens()) {
            tokens.add(this.nextToken());
        }
        return tokens;
    }

    @Override
    public void setTokenPreProcessor(TokenPreProcess tokenPreProcessor) {
        this.tokenPreProcess = tokenPreProcessor;
    }
}

