/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.nlp.tokenization.tokenizer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.cleartk.token.type.Sentence;
import org.cleartk.token.type.Token;
import org.datavec.nlp.annotator.PoStagger;
import org.datavec.nlp.annotator.SentenceAnnotator;
import org.datavec.nlp.annotator.StemmerAnnotator;
import org.datavec.nlp.annotator.TokenizerAnnotator;
import org.datavec.nlp.tokenization.tokenizer.TokenPreProcess;
import org.datavec.nlp.tokenization.tokenizer.Tokenizer;

public class PosUimaTokenizer
implements Tokenizer {
    private static AnalysisEngine engine;
    private List<String> tokens;
    private Collection<String> allowedPosTags;
    private int index;
    private static CAS cas;

    public PosUimaTokenizer(String tokens, AnalysisEngine engine, Collection<String> allowedPosTags) {
        if (engine == null) {
            PosUimaTokenizer.engine = engine;
        }
        this.allowedPosTags = allowedPosTags;
        this.tokens = new ArrayList<String>();
        try {
            if (cas == null) {
                cas = engine.newCAS();
            }
            cas.reset();
            cas.setDocumentText(tokens);
            PosUimaTokenizer.engine.process(cas);
            for (Sentence s : JCasUtil.select((JCas)cas.getJCas(), Sentence.class)) {
                for (Token t : JCasUtil.selectCovered(Token.class, (AnnotationFS)s)) {
                    if (this.valid(t)) {
                        if (t.getLemma() != null) {
                            this.tokens.add(t.getLemma());
                            continue;
                        }
                        if (t.getStem() != null) {
                            this.tokens.add(t.getStem());
                            continue;
                        }
                        this.tokens.add(t.getCoveredText());
                        continue;
                    }
                    this.tokens.add("NONE");
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean valid(Token token) {
        String check = token.getCoveredText();
        if (check.matches("<[A-Z]+>") || check.matches("</[A-Z]+>")) {
            return false;
        }
        return token.getPos() == null || this.allowedPosTags.contains(token.getPos());
    }

    @Override
    public boolean hasMoreTokens() {
        return this.index < this.tokens.size();
    }

    @Override
    public int countTokens() {
        return this.tokens.size();
    }

    @Override
    public String nextToken() {
        String ret = this.tokens.get(this.index);
        ++this.index;
        return ret;
    }

    @Override
    public List<String> getTokens() {
        ArrayList<String> tokens = new ArrayList<String>();
        while (this.hasMoreTokens()) {
            tokens.add(this.nextToken());
        }
        return tokens;
    }

    public static AnalysisEngine defaultAnalysisEngine() {
        try {
            return AnalysisEngineFactory.createEngine((AnalysisEngineDescription)AnalysisEngineFactory.createEngineDescription((AnalysisEngineDescription[])new AnalysisEngineDescription[]{SentenceAnnotator.getDescription(), TokenizerAnnotator.getDescription(), PoStagger.getDescription("en"), StemmerAnnotator.getDescription("English")}), (Object[])new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setTokenPreProcessor(TokenPreProcess tokenPreProcessor) {
    }
}

