/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.nlp.transforms;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.metadata.NDArrayMetaData;
import org.datavec.api.transform.transform.BaseColumnTransform;
import org.datavec.api.writable.NDArrayWritable;
import org.datavec.api.writable.Writable;
import org.datavec.nlp.transforms.BagOfWordsTransform;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.shade.jackson.annotation.JsonCreator;
import org.nd4j.shade.jackson.annotation.JsonIgnoreProperties;
import org.nd4j.shade.jackson.annotation.JsonInclude;
import org.nd4j.shade.jackson.annotation.JsonProperty;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(value={"gazeteer"})
public class GazeteerTransform
extends BaseColumnTransform
implements BagOfWordsTransform {
    private String newColumnName;
    private List<String> wordList;
    private Set<String> gazeteer;

    @JsonCreator
    public GazeteerTransform(@JsonProperty(value="columnName") String columnName, @JsonProperty(value="newColumnName") String newColumnName, @JsonProperty(value="wordList") List<String> wordList) {
        super(columnName);
        this.newColumnName = newColumnName;
        this.wordList = wordList;
        this.gazeteer = new HashSet<String>(wordList);
    }

    public ColumnMetaData getNewColumnMetaData(String newName, ColumnMetaData oldColumnType) {
        return new NDArrayMetaData(newName, new long[]{this.wordList.size()});
    }

    public Writable map(Writable columnWritable) {
        throw new UnsupportedOperationException();
    }

    public Object mapSequence(Object sequence) {
        List sequenceInput = (List)sequence;
        INDArray ret = Nd4j.create((DataType)DataType.FLOAT, (long[])new long[]{this.wordList.size()});
        for (List list : sequenceInput) {
            for (Object token : list) {
                String s = token.toString();
                if (!this.gazeteer.contains(s)) continue;
                ret.putScalar((long)this.wordList.indexOf(s), 1);
            }
        }
        return ret;
    }

    public List<List<Writable>> mapSequence(List<List<Writable>> sequence) {
        INDArray arr = (INDArray)this.mapSequence((Object)sequence);
        return Collections.singletonList(Collections.singletonList(new NDArrayWritable(arr)));
    }

    public String toString() {
        return this.newColumnName;
    }

    public Object map(Object input) {
        return this.gazeteer.contains(input.toString());
    }

    public String outputColumnName() {
        return this.newColumnName;
    }

    public String[] outputColumnNames() {
        return new String[]{this.newColumnName};
    }

    public String[] columnNames() {
        return new String[]{this.columnName()};
    }

    public String columnName() {
        return this.columnName;
    }

    @Override
    public long[] outputShape() {
        return new long[]{this.wordList.size()};
    }

    @Override
    public List<String> vocabWords() {
        return this.wordList;
    }

    @Override
    public INDArray transformFromObject(List<List<Object>> tokens) {
        return (INDArray)this.mapSequence(tokens);
    }

    @Override
    public INDArray transformFrom(List<List<Writable>> tokens) {
        return (INDArray)this.mapSequence((Object)tokens);
    }

    public String getNewColumnName() {
        return this.newColumnName;
    }

    public List<String> getWordList() {
        return this.wordList;
    }

    public Set<String> getGazeteer() {
        return this.gazeteer;
    }

    public void setNewColumnName(String newColumnName) {
        this.newColumnName = newColumnName;
    }

    public void setWordList(List<String> wordList) {
        this.wordList = wordList;
    }

    public void setGazeteer(Set<String> gazeteer) {
        this.gazeteer = gazeteer;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GazeteerTransform)) {
            return false;
        }
        GazeteerTransform other = (GazeteerTransform)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$newColumnName = this.getNewColumnName();
        String other$newColumnName = other.getNewColumnName();
        if (this$newColumnName == null ? other$newColumnName != null : !this$newColumnName.equals(other$newColumnName)) {
            return false;
        }
        List<String> this$wordList = this.getWordList();
        List<String> other$wordList = other.getWordList();
        if (this$wordList == null ? other$wordList != null : !((Object)this$wordList).equals(other$wordList)) {
            return false;
        }
        Set<String> this$gazeteer = this.getGazeteer();
        Set<String> other$gazeteer = other.getGazeteer();
        return !(this$gazeteer == null ? other$gazeteer != null : !((Object)this$gazeteer).equals(other$gazeteer));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GazeteerTransform;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $newColumnName = this.getNewColumnName();
        result = result * 59 + ($newColumnName == null ? 43 : $newColumnName.hashCode());
        List<String> $wordList = this.getWordList();
        result = result * 59 + ($wordList == null ? 43 : ((Object)$wordList).hashCode());
        Set<String> $gazeteer = this.getGazeteer();
        result = result * 59 + ($gazeteer == null ? 43 : ((Object)$gazeteer).hashCode());
        return result;
    }
}

