/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.nlp.transforms;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.metadata.NDArrayMetaData;
import org.datavec.api.transform.transform.BaseColumnTransform;
import org.datavec.api.writable.NDArrayWritable;
import org.datavec.api.writable.Writable;
import org.datavec.nlp.transforms.BagOfWordsTransform;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.list.NDArrayList;
import org.nd4j.shade.jackson.annotation.JsonCreator;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class MultiNlpTransform
extends BaseColumnTransform
implements BagOfWordsTransform {
    private BagOfWordsTransform[] transforms;
    private String newColumnName;
    private List<String> vocabWords;

    @JsonCreator
    public MultiNlpTransform(@JsonProperty(value="columnName") String columnName, @JsonProperty(value="transforms") BagOfWordsTransform[] transforms, @JsonProperty(value="newColumnName") String newColumnName) {
        super(columnName);
        this.transforms = transforms;
        this.vocabWords = transforms[0].vocabWords();
        if (transforms.length > 1) {
            for (int i = 1; i < transforms.length; ++i) {
                if (transforms[i].vocabWords().equals(this.vocabWords)) continue;
                throw new IllegalArgumentException("Vocab words not consistent across transforms!");
            }
        }
        this.newColumnName = newColumnName;
    }

    public Object mapSequence(Object sequence) {
        NDArrayList ndArrayList = new NDArrayList();
        for (BagOfWordsTransform bagofWordsTransform : this.transforms) {
            ndArrayList.addAll((Collection)new NDArrayList(bagofWordsTransform.transformFromObject((List)sequence)));
        }
        return ndArrayList.array();
    }

    public List<List<Writable>> mapSequence(List<List<Writable>> sequence) {
        return Collections.singletonList(Collections.singletonList(new NDArrayWritable(this.transformFrom(sequence))));
    }

    public ColumnMetaData getNewColumnMetaData(String newName, ColumnMetaData oldColumnType) {
        return new NDArrayMetaData(newName, this.outputShape());
    }

    public Writable map(Writable columnWritable) {
        throw new UnsupportedOperationException("Only able to add for time series");
    }

    public String toString() {
        return this.newColumnName;
    }

    public Object map(Object input) {
        throw new UnsupportedOperationException("Only able to add for time series");
    }

    @Override
    public long[] outputShape() {
        int i;
        long[] ret = new long[this.transforms[0].outputShape().length];
        int validatedRank = this.transforms[0].outputShape().length;
        for (i = 1; i < this.transforms.length; ++i) {
            if (this.transforms[i].outputShape().length == validatedRank) continue;
            throw new IllegalArgumentException("Inconsistent shape length at transform " + i + " , should have been: " + validatedRank);
        }
        for (i = 0; i < this.transforms.length; ++i) {
            for (int j = 0; j < validatedRank; ++j) {
                int n = j;
                ret[n] = ret[n] + this.transforms[i].outputShape()[j];
            }
        }
        return ret;
    }

    @Override
    public List<String> vocabWords() {
        return this.vocabWords;
    }

    @Override
    public INDArray transformFromObject(List<List<Object>> tokens) {
        NDArrayList ndArrayList = new NDArrayList();
        for (BagOfWordsTransform bagofWordsTransform : this.transforms) {
            INDArray arr2 = bagofWordsTransform.transformFromObject(tokens);
            arr2 = arr2.reshape(new long[]{arr2.length()});
            NDArrayList newList = new NDArrayList(arr2, (int)arr2.length());
            ndArrayList.addAll((Collection)newList);
        }
        return ndArrayList.array();
    }

    @Override
    public INDArray transformFrom(List<List<Writable>> tokens) {
        NDArrayList ndArrayList = new NDArrayList();
        for (BagOfWordsTransform bagofWordsTransform : this.transforms) {
            INDArray arr2 = bagofWordsTransform.transformFrom(tokens);
            arr2 = arr2.reshape(new long[]{arr2.length()});
            NDArrayList newList = new NDArrayList(arr2, (int)arr2.length());
            ndArrayList.addAll((Collection)newList);
        }
        return ndArrayList.array();
    }
}

