/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.nlp.vectorizer;

import java.util.HashSet;
import org.datavec.api.conf.Configuration;
import org.datavec.api.records.Record;
import org.datavec.api.records.reader.RecordReader;
import org.datavec.nlp.tokenization.tokenizer.TokenPreProcess;
import org.datavec.nlp.tokenization.tokenizer.Tokenizer;
import org.datavec.nlp.tokenization.tokenizerfactory.DefaultTokenizerFactory;
import org.datavec.nlp.tokenization.tokenizerfactory.TokenizerFactory;
import org.datavec.nlp.vectorizer.TextVectorizer;

public abstract class AbstractTfidfVectorizer<VECTOR_TYPE>
extends TextVectorizer<VECTOR_TYPE> {
    @Override
    public void doWithTokens(Tokenizer tokenizer) {
        HashSet<String> seen = new HashSet<String>();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (this.stopWords.contains(token)) continue;
            this.cache.incrementCount(token);
            if (!seen.contains(token)) {
                this.cache.incrementDocCount(token);
            }
            seen.add(token);
        }
    }

    @Override
    public TokenizerFactory createTokenizerFactory(Configuration conf) {
        String clazz = conf.get("org.datavec.nlp.tokenizerfactory", DefaultTokenizerFactory.class.getName());
        try {
            Class<?> tokenizerFactoryClazz = Class.forName(clazz);
            TokenizerFactory tf = (TokenizerFactory)tokenizerFactoryClazz.newInstance();
            String preproc = conf.get("org.datavec.nlp.preprocessor", null);
            if (preproc != null) {
                TokenPreProcess tpp = (TokenPreProcess)Class.forName(preproc).newInstance();
                tf.setTokenPreProcessor(tpp);
            }
            return tf;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public abstract VECTOR_TYPE createVector(Object[] var1);

    public abstract VECTOR_TYPE fitTransform(RecordReader var1);

    public abstract VECTOR_TYPE transform(Record var1);
}

