/*
 * Decompiled with CFR 0.152.
 */
package org.db2code.convert;

import java.util.HashSet;
import java.util.Set;

public final class JavaPropertyConverter {
    private static final Set<String> reservedKeywords = new HashSet<String>();

    private JavaPropertyConverter() {
    }

    public static String camelCaseFromSnakeCaseInitCap(String columnName) {
        return JavaPropertyConverter.camelCaseFromSnakeCase(columnName, true);
    }

    public static String camelCaseFromSnakeCaseInitLow(String columnName) {
        return JavaPropertyConverter.camelCaseFromSnakeCase(columnName, false);
    }

    private static String camelCaseFromSnakeCase(String columnName, boolean initCap) {
        if (reservedKeywords.contains(((String)columnName).toLowerCase())) {
            columnName = (String)columnName + "0";
        }
        if (!JavaPropertyConverter.isValidStartingCharacter((String)columnName)) {
            columnName = "x_" + (String)columnName;
        }
        String[] words = ((String)columnName).split("[\\W_]");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < words.length; ++i) {
            String word = words[i];
            if (word == null || word.isBlank()) continue;
            if (i == 0) {
                if (initCap) {
                    sb.append(Character.toUpperCase(word.charAt(0)));
                    sb.append(word.substring(1).toLowerCase());
                    continue;
                }
                sb.append(word.toLowerCase());
                continue;
            }
            sb.append(Character.toUpperCase(word.charAt(0)));
            sb.append(word.substring(1).toLowerCase());
        }
        return sb.toString();
    }

    private static boolean isValidStartingCharacter(String name) {
        if (name == null || name.isEmpty()) {
            return false;
        }
        Character firstChar = Character.valueOf(name.charAt(0));
        return Character.isLetter(firstChar.charValue()) || firstChar.equals(Character.valueOf('_')) || firstChar.equals(Character.valueOf('$'));
    }

    static {
        reservedKeywords.add("abstract");
        reservedKeywords.add("assert");
        reservedKeywords.add("boolean");
        reservedKeywords.add("break");
        reservedKeywords.add("byte");
        reservedKeywords.add("case");
        reservedKeywords.add("catch");
        reservedKeywords.add("char");
        reservedKeywords.add("class");
        reservedKeywords.add("continue");
        reservedKeywords.add("default");
        reservedKeywords.add("do");
        reservedKeywords.add("double");
        reservedKeywords.add("else");
        reservedKeywords.add("enum");
        reservedKeywords.add("exports");
        reservedKeywords.add("extends");
        reservedKeywords.add("final");
        reservedKeywords.add("finally");
        reservedKeywords.add("float");
        reservedKeywords.add("for");
        reservedKeywords.add("if");
        reservedKeywords.add("implements");
        reservedKeywords.add("import");
        reservedKeywords.add("instanceof");
        reservedKeywords.add("int");
        reservedKeywords.add("interface");
        reservedKeywords.add("long");
        reservedKeywords.add("module");
        reservedKeywords.add("native");
        reservedKeywords.add("new");
        reservedKeywords.add("open");
        reservedKeywords.add("package");
        reservedKeywords.add("private");
        reservedKeywords.add("protected");
        reservedKeywords.add("public");
        reservedKeywords.add("requires");
        reservedKeywords.add("return");
        reservedKeywords.add("short");
        reservedKeywords.add("static");
        reservedKeywords.add("strictfp");
        reservedKeywords.add("super");
        reservedKeywords.add("switch");
        reservedKeywords.add("synchronized");
        reservedKeywords.add("this");
        reservedKeywords.add("throw");
        reservedKeywords.add("throws");
        reservedKeywords.add("transient");
        reservedKeywords.add("try");
        reservedKeywords.add("var");
        reservedKeywords.add("void");
        reservedKeywords.add("volatile");
        reservedKeywords.add("while");
        reservedKeywords.add("yield");
        reservedKeywords.add("record");
        reservedKeywords.add("sealed");
        reservedKeywords.add("non-sealed");
        reservedKeywords.add("permits");
    }
}

