/*
 * Decompiled with CFR 0.152.
 */
package org.db2code.extractors;

import java.util.Arrays;
import org.db2code.extractors.ExtractionParameters;

public class DatabaseExtractionParameters
implements ExtractionParameters {
    private String catalog;
    private String schemaPattern;
    private String tableNamePattern;
    private String[] types;
    private String exportFile;
    private String procedureNamePattern;
    boolean includeStoredProcedures;

    public static DatabaseExtractionParametersBuilder builder() {
        return new DatabaseExtractionParametersBuilder();
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getSchemaPattern() {
        return this.schemaPattern;
    }

    public String getTableNamePattern() {
        return this.tableNamePattern;
    }

    public String[] getTypes() {
        return this.types;
    }

    public String getExportFile() {
        return this.exportFile;
    }

    public String getProcedureNamePattern() {
        return this.procedureNamePattern;
    }

    public boolean isIncludeStoredProcedures() {
        return this.includeStoredProcedures;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public void setSchemaPattern(String schemaPattern) {
        this.schemaPattern = schemaPattern;
    }

    public void setTableNamePattern(String tableNamePattern) {
        this.tableNamePattern = tableNamePattern;
    }

    public void setTypes(String[] types) {
        this.types = types;
    }

    public void setExportFile(String exportFile) {
        this.exportFile = exportFile;
    }

    public void setProcedureNamePattern(String procedureNamePattern) {
        this.procedureNamePattern = procedureNamePattern;
    }

    public void setIncludeStoredProcedures(boolean includeStoredProcedures) {
        this.includeStoredProcedures = includeStoredProcedures;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DatabaseExtractionParameters)) {
            return false;
        }
        DatabaseExtractionParameters other = (DatabaseExtractionParameters)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isIncludeStoredProcedures() != other.isIncludeStoredProcedures()) {
            return false;
        }
        String this$catalog = this.getCatalog();
        String other$catalog = other.getCatalog();
        if (this$catalog == null ? other$catalog != null : !this$catalog.equals(other$catalog)) {
            return false;
        }
        String this$schemaPattern = this.getSchemaPattern();
        String other$schemaPattern = other.getSchemaPattern();
        if (this$schemaPattern == null ? other$schemaPattern != null : !this$schemaPattern.equals(other$schemaPattern)) {
            return false;
        }
        String this$tableNamePattern = this.getTableNamePattern();
        String other$tableNamePattern = other.getTableNamePattern();
        if (this$tableNamePattern == null ? other$tableNamePattern != null : !this$tableNamePattern.equals(other$tableNamePattern)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getTypes(), other.getTypes())) {
            return false;
        }
        String this$exportFile = this.getExportFile();
        String other$exportFile = other.getExportFile();
        if (this$exportFile == null ? other$exportFile != null : !this$exportFile.equals(other$exportFile)) {
            return false;
        }
        String this$procedureNamePattern = this.getProcedureNamePattern();
        String other$procedureNamePattern = other.getProcedureNamePattern();
        return !(this$procedureNamePattern == null ? other$procedureNamePattern != null : !this$procedureNamePattern.equals(other$procedureNamePattern));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DatabaseExtractionParameters;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isIncludeStoredProcedures() ? 79 : 97);
        String $catalog = this.getCatalog();
        result = result * 59 + ($catalog == null ? 43 : $catalog.hashCode());
        String $schemaPattern = this.getSchemaPattern();
        result = result * 59 + ($schemaPattern == null ? 43 : $schemaPattern.hashCode());
        String $tableNamePattern = this.getTableNamePattern();
        result = result * 59 + ($tableNamePattern == null ? 43 : $tableNamePattern.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getTypes());
        String $exportFile = this.getExportFile();
        result = result * 59 + ($exportFile == null ? 43 : $exportFile.hashCode());
        String $procedureNamePattern = this.getProcedureNamePattern();
        result = result * 59 + ($procedureNamePattern == null ? 43 : $procedureNamePattern.hashCode());
        return result;
    }

    public DatabaseExtractionParameters() {
    }

    public DatabaseExtractionParameters(String catalog, String schemaPattern, String tableNamePattern, String[] types, String exportFile, String procedureNamePattern, boolean includeStoredProcedures) {
        this.catalog = catalog;
        this.schemaPattern = schemaPattern;
        this.tableNamePattern = tableNamePattern;
        this.types = types;
        this.exportFile = exportFile;
        this.procedureNamePattern = procedureNamePattern;
        this.includeStoredProcedures = includeStoredProcedures;
    }

    public String toString() {
        return "DatabaseExtractionParameters(catalog=" + this.getCatalog() + ", schemaPattern=" + this.getSchemaPattern() + ", tableNamePattern=" + this.getTableNamePattern() + ", types=" + Arrays.deepToString(this.getTypes()) + ", exportFile=" + this.getExportFile() + ", procedureNamePattern=" + this.getProcedureNamePattern() + ", includeStoredProcedures=" + this.isIncludeStoredProcedures() + ")";
    }

    public static class DatabaseExtractionParametersBuilder {
        private String catalog;
        private String schemaPattern;
        private String tableNamePattern;
        private String[] types;
        private String exportFile;
        private String procedureNamePattern;
        private boolean includeStoredProcedures;

        DatabaseExtractionParametersBuilder() {
        }

        public DatabaseExtractionParametersBuilder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public DatabaseExtractionParametersBuilder schemaPattern(String schemaPattern) {
            this.schemaPattern = schemaPattern;
            return this;
        }

        public DatabaseExtractionParametersBuilder tableNamePattern(String tableNamePattern) {
            this.tableNamePattern = tableNamePattern;
            return this;
        }

        public DatabaseExtractionParametersBuilder types(String[] types) {
            this.types = types;
            return this;
        }

        public DatabaseExtractionParametersBuilder exportFile(String exportFile) {
            this.exportFile = exportFile;
            return this;
        }

        public DatabaseExtractionParametersBuilder procedureNamePattern(String procedureNamePattern) {
            this.procedureNamePattern = procedureNamePattern;
            return this;
        }

        public DatabaseExtractionParametersBuilder includeStoredProcedures(boolean includeStoredProcedures) {
            this.includeStoredProcedures = includeStoredProcedures;
            return this;
        }

        public DatabaseExtractionParameters build() {
            return new DatabaseExtractionParameters(this.catalog, this.schemaPattern, this.tableNamePattern, this.types, this.exportFile, this.procedureNamePattern, this.includeStoredProcedures);
        }

        public String toString() {
            return "DatabaseExtractionParameters.DatabaseExtractionParametersBuilder(catalog=" + this.catalog + ", schemaPattern=" + this.schemaPattern + ", tableNamePattern=" + this.tableNamePattern + ", types=" + Arrays.deepToString(this.types) + ", exportFile=" + this.exportFile + ", procedureNamePattern=" + this.procedureNamePattern + ", includeStoredProcedures=" + this.includeStoredProcedures + ")";
        }
    }
}

