/*
 * Decompiled with CFR 0.152.
 */
package org.db2code.extractors;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.db2code.convert.JavaPropertyConverter;
import org.db2code.extractors.AbstractExtractor;
import org.db2code.extractors.DatabaseExtractionParameters;
import org.db2code.md.ProcedureColumnMetadata;
import org.db2code.rawmodel.RawProcedureParameter;

public class ProcedureParametersExtractor
extends AbstractExtractor<DatabaseExtractionParameters> {
    @Override
    public List<RawProcedureParameter> extract(DatabaseMetaData databaseMetaData, DatabaseExtractionParameters params) {
        try {
            return this._extract(databaseMetaData, params);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private List<RawProcedureParameter> _extract(DatabaseMetaData databaseMetaData, DatabaseExtractionParameters params) throws SQLException {
        ArrayList<RawProcedureParameter> rawProcedureParameters = new ArrayList<RawProcedureParameter>();
        try (ResultSet procedureColumnsRs = databaseMetaData.getProcedureColumns(params.getCatalog(), params.getSchemaPattern(), params.getProcedureNamePattern(), null);){
            while (procedureColumnsRs.next()) {
                RawProcedureParameter procedureParameter = new RawProcedureParameter();
                for (ProcedureColumnMetadata procedureColumnMetadata : ProcedureColumnMetadata.values()) {
                    String mdValue = this.tryGetFromMetadata(procedureColumnMetadata, procedureColumnsRs);
                    String propName = JavaPropertyConverter.camelCaseFromSnakeCaseInitLow(procedureColumnMetadata.getName());
                    this.setProperty(procedureParameter, mdValue, propName);
                }
                rawProcedureParameters.add(procedureParameter);
            }
        }
        return rawProcedureParameters;
    }
}

