/*
 * Decompiled with CFR 0.152.
 */
package org.dbtools.codegen;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.dbtools.codegen.Access;
import org.dbtools.codegen.ClassType;
import org.dbtools.codegen.JavaInnerEnum;
import org.dbtools.codegen.JavaMethod;
import org.dbtools.codegen.JavaVariable;
import org.dbtools.codegen.MethodType;

public class JavaClass {
    private ClassType classType = ClassType.CLASS;
    private static String tab = "    ";
    private String fileHeaderComment = "";
    private String classHeaderComment = "";
    private String packageName = "";
    private List<String> imports;
    private Access access = Access.PUBLIC;
    private boolean abstractClass = false;
    private boolean staticClass = false;
    private boolean finalClass = false;
    private List<String> annotations;
    private String name;
    private List<String> implementsInterfaces;
    private String extendsClass;
    private String staticInitializerBlock = "";
    private List<JavaInnerEnum> enums;
    private List<JavaVariable> variables;
    private List<JavaMethod> constructors;
    private List<JavaMethod> methods;
    private boolean createDefaultConstructor = true;

    public JavaClass(String name) {
        this.setName(name);
        this.init();
    }

    public JavaClass(String packageName, String name) {
        this.setName(name);
        this.setPackageName(packageName);
        this.init();
    }

    private void init() {
        this.imports = new ArrayList<String>();
        this.annotations = new ArrayList<String>();
        this.implementsInterfaces = new ArrayList<String>();
        this.enums = new ArrayList<JavaInnerEnum>();
        this.variables = new ArrayList<JavaVariable>();
        this.constructors = new ArrayList<JavaMethod>();
        this.methods = new ArrayList<JavaMethod>();
    }

    public void setDefaultCVSFileHeaderComment() {
        this.setFileHeaderComment("/*\n");
        this.setFileHeaderComment(this.getFileHeaderComment() + " * $Author: jeff $\n");
        this.setFileHeaderComment(this.getFileHeaderComment() + " * $RCSfile$\n");
        this.setFileHeaderComment(this.getFileHeaderComment() + " * $Revision: 1717 $\n");
        this.setFileHeaderComment(this.getFileHeaderComment() + " * $Date: 2006-08-01 22:43:52 -0600 (Tue, 01 Aug 2006) $\n");
        this.setFileHeaderComment(this.getFileHeaderComment() + " */\n\n");
    }

    public void setDefaultClassHeaderComment(String shortDescription, String copyright, String author, String version, boolean useCVSDate) {
        this.setClassHeaderComment("\n/**\n");
        this.setClassHeaderComment(this.getClassHeaderComment() + " * " + shortDescription + "<br>\n");
        if (useCVSDate) {
            this.setClassHeaderComment(this.getClassHeaderComment() + " * CVS last modified: $Date: 2006-08-01 22:43:52 -0600 (Tue, 01 Aug 2006) $<br>\n");
        }
        this.setClassHeaderComment(this.getClassHeaderComment() + " * " + copyright + "\n");
        this.setClassHeaderComment(this.getClassHeaderComment() + " *\n");
        this.setClassHeaderComment(this.getClassHeaderComment() + " * @author " + author + "\n");
        this.setClassHeaderComment(this.getClassHeaderComment() + " * @version " + version + "\n");
        this.setClassHeaderComment(this.getClassHeaderComment() + " */\n\n");
    }

    public void addImport(String newImport) {
        if (!this.imports.contains(newImport)) {
            this.imports.add(newImport);
        }
    }

    public void addAnnotation(String annotation) {
        if (annotation == null || annotation.length() == 0) {
            throw new IllegalArgumentException("annotation cannot be null or empty");
        }
        if (annotation.charAt(0) != '@') {
            this.annotations.add('@' + annotation);
        } else {
            this.annotations.add(annotation);
        }
    }

    public void addImplements(String className) {
        if (className == null || className.length() == 0) {
            throw new IllegalArgumentException("className for Implements cannot be null or empty");
        }
        this.implementsInterfaces.add(className);
    }

    public JavaInnerEnum addEnum(String enumName, List<String> enumValues) {
        return this.addEnum(new JavaInnerEnum(enumName, enumValues));
    }

    public JavaInnerEnum addEnum(JavaInnerEnum newEnum) {
        if (newEnum == null) {
            throw new IllegalArgumentException("newEnum cannot be null");
        }
        this.enums.add(newEnum);
        return newEnum;
    }

    public JavaVariable addVariable(JavaVariable newVariable) {
        if (newVariable == null) {
            throw new IllegalArgumentException("newVariable cannot be null");
        }
        this.variables.add(newVariable);
        return newVariable;
    }

    public JavaVariable addVariable(JavaVariable newVariable, boolean generateSetterGetter) {
        if (newVariable == null) {
            throw new IllegalArgumentException("newVariable cannot be null");
        }
        newVariable.setGenerateSetterGetter(generateSetterGetter);
        return this.addVariable(newVariable);
    }

    public JavaVariable addVariable(String datatype, String name) {
        JavaVariable newVariable = new JavaVariable(datatype, name);
        return this.addVariable(newVariable);
    }

    public JavaVariable addVariable(String datatype, String name, String defaultValue) {
        JavaVariable newVariable = new JavaVariable(datatype, name);
        newVariable.setDefaultValue(defaultValue);
        return this.addVariable(newVariable);
    }

    public JavaVariable addVariable(String datatype, String name, boolean generateSetterGetter) {
        JavaVariable newVariable = new JavaVariable(datatype, name);
        newVariable.setGenerateSetterGetter(generateSetterGetter);
        return this.addVariable(newVariable);
    }

    public JavaVariable addConstant(String datatype, String name, String defaultValue) {
        return this.addConstant(datatype, name, defaultValue, true);
    }

    public JavaVariable addConstant(String datatype, String name, String defaultValue, boolean formatDefaultValue) {
        JavaVariable constant = new JavaVariable(datatype, name);
        constant.setAccess(Access.PUBLIC);
        constant.setStatic(true);
        constant.setFinal(true);
        constant.setDefaultValue(defaultValue, formatDefaultValue);
        this.addVariable(constant);
        return constant;
    }

    public JavaMethod addConstructor(Access access, List<JavaVariable> parameters, String content) {
        if (this.isInterface()) {
            throw new IllegalStateException("Cannot add a constructor to an Interface");
        }
        return this.addMethod(MethodType.CONSTRUCTOR, access, "", this.name, parameters, content);
    }

    public JavaMethod addMethod(JavaMethod newMethod) {
        if (newMethod == null) {
            throw new IllegalArgumentException("newMethod cannot be null");
        }
        switch (newMethod.getMethodType()) {
            case CONSTRUCTOR: {
                this.constructors.add(newMethod);
                break;
            }
            default: {
                this.methods.add(newMethod);
            }
        }
        return newMethod;
    }

    public JavaMethod addMethod(Access access, String returnType, String name, String content) {
        JavaMethod newMethod = new JavaMethod(access, returnType, name);
        newMethod.setContent(content);
        this.addMethod(newMethod);
        return newMethod;
    }

    public JavaMethod addMethod(Access access, String returnType, String name, List<JavaVariable> parameters, String content) {
        return this.addMethod(MethodType.STANDARD, access, returnType, name, parameters, content);
    }

    private JavaMethod addMethod(MethodType methodType, Access access, String returnType, String name, List<JavaVariable> parameters, String content) {
        JavaMethod newMethod = new JavaMethod(access, returnType, name);
        newMethod.setMethodType(methodType);
        if (parameters != null) {
            newMethod.setParameters(parameters);
        }
        newMethod.setContent(content);
        this.addMethod(newMethod);
        return newMethod;
    }

    private String buildPackage() {
        return "package " + this.packageName + ";\n\n";
    }

    private String buildImports() {
        if (this.imports.isEmpty()) {
            return "";
        }
        StringBuilder out = new StringBuilder();
        for (String newImport : this.imports) {
            out.append("import ").append(newImport).append(";\n");
        }
        out.append("\n");
        return out.toString();
    }

    private String buildClassHeader(String genericsTypeVar) {
        StringBuilder classHeader = new StringBuilder();
        classHeader.append("\n");
        for (String annotation : this.annotations) {
            classHeader.append(annotation).append("\n");
        }
        String genericsVar = genericsTypeVar == null ? "" : "<" + genericsTypeVar + ">";
        String extendsNameString = "";
        if (this.getExtends() != null && this.getExtends().length() > 0) {
            extendsNameString = " extends " + this.getExtends();
        }
        String implementsNamesString = "";
        if (this.implementsInterfaces != null && !this.implementsInterfaces.isEmpty()) {
            implementsNamesString = " implements ";
            for (int i = 0; i < this.implementsInterfaces.size(); ++i) {
                if (i > 0) {
                    implementsNamesString = implementsNamesString + ", ";
                }
                implementsNamesString = implementsNamesString + this.implementsInterfaces.get(i);
            }
        }
        classHeader.append(JavaClass.getAccessString(this.getAccess())).append(" ");
        if (this.isAbstract()) {
            classHeader.append("abstract ");
        }
        if (this.isStatic()) {
            classHeader.append("static ");
        }
        if (this.isFinal()) {
            classHeader.append("final ");
        }
        switch (this.classType) {
            case CLASS: {
                classHeader.append("class ").append(this.getName()).append(genericsVar);
                break;
            }
            case INTERFACE: {
                classHeader.append("interface ").append(this.getName()).append(genericsVar);
                break;
            }
            case ENUM: {
                classHeader.append("enum ").append(this.getName()).append(genericsVar);
                break;
            }
        }
        classHeader.append(extendsNameString);
        classHeader.append(implementsNamesString);
        classHeader.append(" {\n");
        return classHeader.toString();
    }

    public static String getAccessString(Access access) {
        switch (access) {
            case DEFAULT_NONE: {
                return "";
            }
            case PUBLIC: {
                return "public";
            }
            case PRIVATE: {
                return "private";
            }
            case PROTECTED: {
                return "protected";
            }
        }
        throw new IllegalArgumentException("Illegal Access type: " + access.toString());
    }

    public static String getTab() {
        return tab;
    }

    public static void setTab(String newTab) {
        tab = newTab;
    }

    private String buildEnums() {
        String enumsText = "";
        String TAB = JavaClass.getTab();
        for (JavaInnerEnum enumItem : this.enums) {
            enumsText = enumsText + TAB + enumItem.toString() + "\n";
        }
        enumsText = enumsText + "\n";
        return enumsText;
    }

    private String buildVariables() {
        String variablesText = "";
        for (JavaVariable variable : this.variables) {
            variablesText = variablesText + variable.toString() + ";\n";
            this.addAccessorMethods(variable);
        }
        variablesText = variablesText + "\n";
        return variablesText;
    }

    private void addAccessorMethods(JavaVariable variable) {
        if (this.isInterface()) {
            return;
        }
        String TAB = JavaClass.getTab();
        String type = variable.getDataType();
        String varName = variable.getName();
        if (variable.isGenerateGetter()) {
            String getterContent;
            if (variable.isGetterReturnsClone()) {
                getterContent = "if (" + varName + " != null) {\n";
                getterContent = getterContent + TAB + "return (" + variable.getDataType() + ")" + varName + ".clone();\n";
                getterContent = getterContent + "} else {\n";
                getterContent = getterContent + TAB + "return null;\n";
                getterContent = getterContent + "}\n";
            } else {
                getterContent = "return " + varName + ";\n";
            }
            JavaMethod getterMethod = this.addMethod(variable.getGenerateGetterAccess(), type, variable.getGetterMethodName(), getterContent);
            getterMethod.setStatic(variable.isStatic());
        }
        if (variable.isGenerateSetter()) {
            JavaMethod setterMethod = new JavaMethod(variable.getGenerateSetterAccess(), "void", variable.getSetterMethodName());
            setterMethod.addParameter(new JavaVariable(type, varName));
            setterMethod.setStatic(variable.isStatic());
            String thisText = "this";
            if (variable.isStatic()) {
                thisText = this.getName();
            }
            String setterContent = "";
            if (type != null && type.equals("String") && variable.isForceStringLength()) {
                int strLength = variable.getForcedStringLength();
                setterContent = setterContent + "if (" + varName + "!= null && " + varName + ".length() > " + strLength + ") {\n";
                setterContent = setterContent + TAB + thisText + "." + varName + " = " + varName + ".substring(0," + strLength + ");\n";
                setterContent = setterContent + "} else {\n";
                setterContent = setterContent + TAB + thisText + "." + varName + " = " + varName + ";\n";
                setterContent = setterContent + "}\n";
            } else if (variable.isSetterClonesParam()) {
                setterContent = setterContent + "if (" + varName + " != null) {\n";
                setterContent = setterContent + TAB + thisText + "." + varName + " = (" + variable.getDataType() + ") " + varName + ".clone();\n";
                setterContent = setterContent + "} else {\n";
                setterContent = setterContent + TAB + thisText + "." + varName + " = null;\n";
                setterContent = setterContent + "}\n";
            } else {
                setterContent = setterContent + thisText + "." + varName + " = " + varName + ";";
            }
            String postSetterCode = variable.getPostSetterCode();
            if (postSetterCode.length() > 0) {
                setterContent = setterContent + postSetterCode;
            }
            setterMethod.setContent(setterContent);
            this.addMethod(setterMethod);
        }
    }

    public static String createGetterMethodName(Class<?> type, String varName) {
        String methodVarName = varName.substring(0, 1).toUpperCase() + varName.substring(1);
        if (type == Boolean.class || type == Boolean.TYPE) {
            return "is" + methodVarName;
        }
        return "get" + methodVarName;
    }

    public static String createSetterMethodName(String varName) {
        String methodVarName = varName.substring(0, 1).toUpperCase() + varName.substring(1);
        return "set" + methodVarName;
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        if (this.getFileHeaderComment().length() > 0) {
            out.append(this.getFileHeaderComment()).append("\n\n");
        }
        if (this.getClassHeaderComment().length() > 0) {
            out.append(this.getClassHeaderComment()).append("\n\n");
        }
        out.append("\n");
        out.append(this.buildPackage());
        out.append(this.buildImports());
        out.append(this.buildClassHeader(null));
        out.append(this.buildPostClassHeader());
        out.append(this.buildEnums());
        out.append(this.buildVariables());
        this.buildStaticInitializer(out);
        this.buildMethods(out);
        out.append("\n}");
        return out.toString();
    }

    private void buildStaticInitializer(StringBuilder out) {
        if (this.staticInitializerBlock != null && this.staticInitializerBlock.length() > 0) {
            out.append(JavaClass.getTab()).append("static {\n");
            out.append(this.staticInitializerBlock).append("\n");
            out.append(JavaClass.getTab()).append("}\n\n");
        }
    }

    private void buildMethods(StringBuilder out) {
        if (!this.isInterface()) {
            if (this.createDefaultConstructor) {
                this.addConstructor(Access.PUBLIC, null, "");
            }
            for (JavaMethod constructor : this.constructors) {
                out.append(constructor.toString());
                out.append("\n");
            }
        }
        for (JavaMethod method : this.methods) {
            out.append(method.toString(this.isInterface()));
            out.append("\n");
        }
    }

    public String getFilename() {
        return this.getName() + ".java";
    }

    public void writeToDisk(String directoryname) {
        this.writeToDisk(directoryname, true);
    }

    public void writeToDisk(String directoryname, boolean overwrite) {
        File directory = new File(directoryname);
        directory.mkdirs();
        try {
            File outFile = new File(directoryname + "/" + this.getFilename());
            if (!overwrite && outFile.exists()) {
                return;
            }
            PrintStream fps = new PrintStream(new FileOutputStream(outFile));
            fps.print(this.toString());
            fps.close();
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public Access getAccess() {
        return this.access;
    }

    public void setAccess(Access access) {
        this.access = access;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getExtends() {
        return this.extendsClass;
    }

    public void setExtends(String extendsClass) {
        this.extendsClass = extendsClass;
    }

    public boolean isAbstract() {
        return this.abstractClass;
    }

    public void setAbstract(boolean abstractClass) {
        this.abstractClass = abstractClass;
    }

    public boolean isStatic() {
        return this.staticClass;
    }

    public void setStatic(boolean staticClass) {
        this.staticClass = staticClass;
    }

    public boolean isFinal() {
        return this.finalClass;
    }

    public void setFinal(boolean finalClass) {
        this.finalClass = finalClass;
    }

    public boolean isCreateDefaultConstructor() {
        return this.createDefaultConstructor;
    }

    public void setCreateDefaultConstructor(boolean createDefaultConstructor) {
        this.createDefaultConstructor = createDefaultConstructor;
    }

    public static String formatConstant(String constant) {
        StringBuilder newConst = new StringBuilder();
        for (int i = 0; i < constant.length(); ++i) {
            newConst.append(Character.toUpperCase(constant.charAt(i)));
            char current = constant.charAt(i);
            char nextChar = ' ';
            if (i + 1 < constant.length()) {
                nextChar = constant.charAt(i + 1);
            }
            if (Character.isUpperCase(current) || nextChar == 32 || !Character.isUpperCase(nextChar)) continue;
            newConst.append('_');
        }
        return newConst.toString();
    }

    public static String formatDefaultValue(String fieldType, String defaultValue) {
        String newDefaultValue = "";
        if (defaultValue == null || defaultValue.equalsIgnoreCase("NULL")) {
            defaultValue = null;
        }
        if (fieldType == null) {
            return "null";
        }
        if (fieldType.equals("String")) {
            newDefaultValue = defaultValue == null ? "\"\"" : "\"" + defaultValue + "\"";
        } else if (fieldType.equals("int") || fieldType.equals("long") || fieldType.equals("float") || fieldType.equals("double")) {
            newDefaultValue = defaultValue == null || defaultValue.equals("") ? "0" : defaultValue;
        } else if (fieldType.equals("Integer") || fieldType.equals("Long") || fieldType.equals("Float") || fieldType.equals("Double")) {
            newDefaultValue = defaultValue == null || defaultValue.equals("") ? "null" : defaultValue;
        } else if (fieldType.equals("char") || fieldType.equals("Character")) {
            if (defaultValue == null || defaultValue.equals("")) {
                newDefaultValue = "''";
            } else {
                defaultValue = "'" + defaultValue + "'";
            }
        } else {
            newDefaultValue = fieldType.equals("boolean") || fieldType.equals("Boolean") ? (defaultValue == null || defaultValue.equals("") ? "false" : (defaultValue.equals("1") ? "true" : (defaultValue.equals("0") ? "false" : defaultValue))) : (fieldType.equals("Date") && defaultValue != null && defaultValue.equalsIgnoreCase("NOW") ? "new Date()" : (fieldType.equals("BigInteger") ? (defaultValue != null ? "new java.math.BigInteger(\"" + defaultValue + "\")" : "new java.math.BigInteger(\"0\")") : (fieldType.equals("BigDecimal") ? (defaultValue != null ? "new java.math.BigDecimal(" + defaultValue + ")" : "new java.math.BigDecimal(0)") : (defaultValue != null && defaultValue.length() > 0 ? defaultValue : "null"))));
        }
        return newDefaultValue;
    }

    public static String createPackageFromFilePath(String filepath) {
        if (filepath.contains("src/main/java")) {
            return JavaClass.createPackageFromFilePath(filepath, "src.main.java");
        }
        if (filepath.contains("src\\main\\java")) {
            return JavaClass.createPackageFromFilePath(filepath, "src.main.java");
        }
        if (filepath.contains("src/java")) {
            return JavaClass.createPackageFromFilePath(filepath, "src.java");
        }
        if (filepath.contains("src\\java")) {
            return JavaClass.createPackageFromFilePath(filepath, "src.java");
        }
        if (filepath.contains("src")) {
            return JavaClass.createPackageFromFilePath(filepath, "src");
        }
        return JavaClass.createPackageFromFilePath(filepath, "source");
    }

    public static String createPackageFromFilePath(String filepath, String srcDirName) {
        String dotFilepath = "";
        String packageName = "";
        if (filepath == null || filepath.equals("")) {
            return "";
        }
        for (int i = 0; i < filepath.length(); ++i) {
            char c = filepath.charAt(i);
            dotFilepath = c == '\\' || c == '/' ? dotFilepath + '.' : dotFilepath + c;
        }
        int start = dotFilepath.indexOf(srcDirName);
        packageName = start > 0 ? dotFilepath.substring(start + srcDirName.length()) : dotFilepath;
        if (packageName.length() >= 2 && packageName.charAt(1) == ':') {
            packageName = packageName.substring(2);
        }
        if (packageName.length() > 0 && packageName.charAt(0) == '.') {
            packageName = packageName.substring(1);
        }
        if (packageName.length() > 0 && packageName.charAt(packageName.length() - 1) == '.') {
            packageName = packageName.substring(0, packageName.length() - 1);
        }
        return packageName;
    }

    public static String formatToJavaVariable(String item) {
        return item.substring(0, 1).toLowerCase() + item.substring(1);
    }

    public static String formatToJavaMethod(String item) {
        return item.substring(0, 1).toUpperCase() + item.substring(1);
    }

    public String getFileHeaderComment() {
        return this.fileHeaderComment;
    }

    public void setFileHeaderComment(String fileHeaderComment) {
        this.fileHeaderComment = fileHeaderComment;
    }

    public String getClassHeaderComment() {
        return this.classHeaderComment;
    }

    public void setClassHeaderComment(String classHeaderComment) {
        this.classHeaderComment = classHeaderComment;
    }

    protected ClassType getClassType() {
        return this.classType;
    }

    protected void setClassType(ClassType classType) {
        this.classType = classType;
    }

    public boolean isInterface() {
        return this.classType == ClassType.INTERFACE;
    }

    public boolean isEnum() {
        return this.classType == ClassType.ENUM;
    }

    protected String buildPostClassHeader() {
        return "";
    }

    public void appendStaticInitializer(String code) {
        String TAB = JavaClass.getTab();
        this.staticInitializerBlock = this.staticInitializerBlock + TAB + TAB + code + "\n";
    }

    public void setStaticInitializer(String code) {
        String TAB = JavaClass.getTab();
        this.staticInitializerBlock = TAB + TAB + code + "\n";
    }
}

