/*
 * Decompiled with CFR 0.152.
 */
package org.dbtools.codegen;

import java.util.Collections;
import java.util.List;
import org.dbtools.codegen.ClassType;
import org.dbtools.codegen.JavaClass;

public class JavaEnum
extends JavaClass {
    private List<String> enums;

    public JavaEnum(String name, List<String> enums) {
        super(name);
        this.setClassType(ClassType.ENUM);
        this.setEnums(enums);
    }

    public JavaEnum(String packageName, String name, List<String> enums) {
        super(packageName, name);
        this.setClassType(ClassType.ENUM);
        this.setEnums(enums);
    }

    public List<String> getEnums() {
        return Collections.unmodifiableList(this.enums);
    }

    public void setEnums(List<String> enums) {
        if (enums == null || enums.isEmpty()) {
            throw new IllegalArgumentException("enums cannot be null or empty");
        }
        this.enums = enums;
    }

    @Override
    protected String buildPostClassHeader() {
        String enumStr = "";
        int count = 0;
        for (String enumItem : this.enums) {
            if (count > 0) {
                enumStr = enumStr + ", ";
            }
            enumStr = enumStr + enumItem;
            ++count;
        }
        enumStr = enumStr + ";\n";
        return enumStr;
    }
}

