/*
 * Decompiled with CFR 0.152.
 */
package org.dbtools.codegen;

import java.util.Collections;
import java.util.List;
import org.dbtools.codegen.Access;
import org.dbtools.codegen.JavaClass;

public class JavaInnerEnum {
    private Access access = Access.PUBLIC;
    private String name;
    private List<String> values;

    public JavaInnerEnum(String enumName, List<String> enumValues) {
        this.setName(enumName);
        if (enumValues == null) {
            throw new IllegalArgumentException("enumValues cannot be null");
        }
        this.setValues(enumValues);
    }

    public String toString() {
        String enumStr = "";
        String accessText = JavaClass.getAccessString(this.getAccess());
        enumStr = enumStr + accessText;
        enumStr = enumStr + " static enum " + this.getName() + " {\n        ";
        int numItems = 0;
        for (String enumItem : this.values) {
            if (++numItems > 1) {
                enumStr = enumStr + ", ";
            }
            enumStr = enumStr + enumItem;
        }
        enumStr = enumStr + "\n    }";
        return enumStr;
    }

    public Access getAccess() {
        return this.access;
    }

    public void setAccess(Access access) {
        this.access = access;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getValues() {
        return Collections.unmodifiableList(this.values);
    }

    public void setValues(List<String> values) {
        this.values = values;
    }
}

