/*
 * Decompiled with CFR 0.152.
 */
package org.dbtools.codegen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.dbtools.codegen.Access;
import org.dbtools.codegen.JavaClass;
import org.dbtools.codegen.JavaVariable;
import org.dbtools.codegen.MethodType;
import org.dbtools.codegen.VariableType;

public class JavaMethod {
    private MethodType methodType = MethodType.STANDARD;
    private String returnType = "void";
    private String name;
    private Access access = Access.PRIVATE;
    private boolean abstractMethod = false;
    private boolean staticMethod = false;
    private boolean constMethod = false;
    private List<String> annotations;
    private List<JavaVariable> parameters;
    private List<String> exceptions;
    private String content = "";

    public JavaMethod(String name) {
        this.name = name;
        this.init();
    }

    public JavaMethod(Access access, String returnType, String name) {
        this.access = access;
        this.returnType = returnType;
        this.name = name;
        this.init();
    }

    public JavaMethod(Access access, MethodType type, String returnType, String name) {
        this.access = access;
        this.setMethodType(type);
        this.returnType = returnType;
        this.name = name;
        this.init();
    }

    private void init() {
        this.setParameters(new ArrayList<JavaVariable>());
        this.annotations = new ArrayList<String>();
        this.exceptions = new ArrayList<String>();
    }

    public MethodType getMethodType() {
        return this.methodType;
    }

    public void setMethodType(MethodType methodType) {
        this.methodType = methodType;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public void setReturnType(String returnType) {
        this.returnType = returnType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Access getAccess() {
        return this.access;
    }

    public void setAccess(Access access) {
        this.access = access;
    }

    public boolean isStatic() {
        return this.staticMethod;
    }

    public void setStatic(boolean staticMethod) {
        this.staticMethod = staticMethod;
    }

    public boolean isFinal() {
        return this.constMethod;
    }

    public void setFinal(boolean constMethod) {
        this.constMethod = constMethod;
    }

    public String toString() {
        return this.toString(false);
    }

    public void addAnnotation(String annotation) {
        if (annotation == null || annotation.length() == 0) {
            throw new IllegalArgumentException("annotation cannot be null or empty");
        }
        if (annotation.charAt(0) != '@') {
            this.annotations.add('@' + annotation);
        } else {
            this.annotations.add(annotation);
        }
    }

    public String toString(boolean interfaceOnly) {
        String methodString = "";
        String TAB = JavaClass.getTab();
        for (String annotation : this.annotations) {
            methodString = methodString + TAB + annotation + "\n";
        }
        methodString = methodString + TAB + JavaClass.getAccessString(this.getAccess());
        if (this.isAbstract()) {
            methodString = methodString + " abstract";
        }
        if (this.isStatic()) {
            methodString = methodString + " static";
        }
        if (this.isFinal()) {
            methodString = methodString + " final";
        }
        if (this.getMethodType() != MethodType.CONSTRUCTOR) {
            methodString = methodString + " " + this.getReturnType();
        }
        methodString = methodString + " " + this.getName();
        methodString = methodString + "(";
        int paramCounter = 0;
        for (JavaVariable parameter : this.parameters) {
            if (paramCounter > 0) {
                methodString = methodString + ", ";
            }
            methodString = methodString + parameter.toString();
            ++paramCounter;
        }
        methodString = methodString + ")";
        if (!this.exceptions.isEmpty()) {
            methodString = methodString + " throws";
            int expCount = 0;
            for (String exception : this.exceptions) {
                methodString = expCount == 0 ? methodString + " " : methodString + ", ";
                methodString = methodString + exception;
                ++expCount;
            }
        }
        if (interfaceOnly) {
            methodString = methodString + ";\n";
            return methodString;
        }
        methodString = methodString + " {\n";
        if (this.content != null && this.content.length() > 0) {
            String[] splitContent;
            for (String aSplitContent : splitContent = this.content.split("\n")) {
                methodString = methodString + TAB + TAB + aSplitContent + "\n";
            }
        }
        methodString = methodString + TAB + "}\n";
        return methodString;
    }

    public boolean isAbstract() {
        return this.abstractMethod;
    }

    public void setAbstract(boolean abstractMethod) {
        this.abstractMethod = abstractMethod;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void addParameter(JavaVariable parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException("parameter cannot be null");
        }
        parameter.setVariableType(VariableType.METHOD_PARAMETER);
        this.parameters.add(parameter);
    }

    public List<JavaVariable> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    public void setParameters(List<JavaVariable> parameters) {
        for (JavaVariable parameter : parameters) {
            parameter.setVariableType(VariableType.METHOD_PARAMETER);
        }
        this.parameters = parameters;
    }

    public void addThrowsException(String exceptionClass) {
        if (exceptionClass == null || exceptionClass.length() == 0) {
            throw new IllegalArgumentException("exceptionClass cannot be empty or null");
        }
        this.exceptions.add(exceptionClass);
    }
}

