/*
 * Decompiled with CFR 0.152.
 */
package org.dbtools.codegen;

import java.util.ArrayList;
import java.util.List;
import org.dbtools.codegen.Access;
import org.dbtools.codegen.JavaClass;
import org.dbtools.codegen.VariableType;

public class JavaVariable {
    private VariableType variableType = VariableType.CLASS_VARIABLE;
    private String datatype;
    private String name;
    private Access access = Access.PRIVATE;
    private boolean staticVar = false;
    private boolean finalVar = false;
    private boolean volatileVar = false;
    private List<String> annotations = new ArrayList<String>();
    private String defaultValue;
    private boolean generateSetter = false;
    private boolean generateGetter = false;
    private boolean getterReturnsClone = false;
    private boolean setterClonesParam = false;
    private Access generateSetterAccess = Access.PUBLIC;
    private Access generateGetterAccess = Access.PUBLIC;
    private String postSetterCode = "";
    private boolean forceStringLength = false;
    private int forcedStringLength = 255;

    public JavaVariable(String datatype, String name) {
        this.datatype = datatype;
        this.name = name;
    }

    public String getDataType() {
        return this.datatype;
    }

    public void setDataType(String datatype) {
        this.datatype = datatype;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Access getAccess() {
        return this.access;
    }

    public void setAccess(Access access) {
        this.access = access;
    }

    public boolean isStatic() {
        return this.staticVar;
    }

    public void setStatic(boolean staticVar) {
        this.staticVar = staticVar;
    }

    public boolean isFinal() {
        return this.finalVar;
    }

    public void setFinal(boolean finalVar) {
        this.finalVar = finalVar;
    }

    public boolean isVolatile() {
        return this.volatileVar;
    }

    public void setVolatile(boolean volatileVar) {
        this.volatileVar = volatileVar;
    }

    public void addAnnotation(String annotation) {
        if (annotation == null || annotation.length() == 0) {
            throw new IllegalArgumentException("annotation cannot be null or empty");
        }
        if (annotation.charAt(0) != '@') {
            this.annotations.add('@' + annotation);
        } else {
            this.annotations.add(annotation);
        }
    }

    public String toString() {
        String varText = "";
        for (String annotation : this.annotations) {
            if (this.getVariableType() == VariableType.CLASS_VARIABLE) {
                varText = varText + JavaClass.getTab();
            }
            varText = varText + annotation + "\n";
        }
        if (this.getVariableType() == VariableType.CLASS_VARIABLE) {
            String accessText = JavaClass.getAccessString(this.access);
            varText = varText + JavaClass.getTab();
            varText = varText + accessText;
        }
        if (this.staticVar) {
            varText = varText + " static";
        }
        if (this.finalVar) {
            varText = varText + " final";
        }
        if (this.volatileVar) {
            varText = varText + " volatile";
        }
        switch (this.getVariableType()) {
            case METHOD_PARAMETER: {
                varText = varText + this.datatype + " " + this.name;
                break;
            }
            default: {
                varText = varText + " " + this.datatype + " " + this.name;
                if (this.defaultValue == null || this.defaultValue.length() <= 0) break;
                varText = varText + " = " + this.defaultValue;
            }
        }
        return varText;
    }

    public boolean isGenerateSetterGetter() {
        return this.isGenerateSetter() && this.isGenerateGetter();
    }

    public void setGenerateSetterGetter(boolean generateSetterGetter) {
        this.setGenerateSetter(generateSetterGetter);
        this.setGenerateGetter(generateSetterGetter);
    }

    public boolean isForceStringLength() {
        return this.forceStringLength;
    }

    public void setForceStringLength(boolean forceStringLength) {
        this.forceStringLength = forceStringLength;
    }

    public int getForcedStringLength() {
        return this.forcedStringLength;
    }

    public void setForcedStringLength(int forcedStringLength) {
        this.forcedStringLength = forcedStringLength;
    }

    protected VariableType getVariableType() {
        return this.variableType;
    }

    protected void setVariableType(VariableType variableType) {
        this.variableType = variableType;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.setDefaultValue(defaultValue, true);
    }

    public void setDefaultValue(String defaultValue, boolean formatDefaultValue) {
        if (this.getVariableType() == VariableType.METHOD_PARAMETER) {
            throw new IllegalArgumentException("Cannot set a default value for a method parameter for variable [" + this.getName() + "]");
        }
        this.defaultValue = formatDefaultValue ? JavaClass.formatDefaultValue(this.getDataType(), defaultValue) : defaultValue;
    }

    public String getPostSetterCode() {
        return this.postSetterCode;
    }

    public void setPostSetterCode(String postSetterCode) {
        this.postSetterCode = postSetterCode;
    }

    public String getSetterMethodName() {
        return JavaVariable.getSetterMethodName(this.getName());
    }

    public static String getSetterMethodName(String varName) {
        return "set" + JavaVariable.createBeanMethodName(varName);
    }

    public String getGetterMethodName() {
        return JavaVariable.getGetterMethodName(this.getDataType(), this.getName());
    }

    public static String getGetterMethodName(String type, String varName) {
        String methodVarName = JavaVariable.createBeanMethodName(varName);
        if (type != null && (type.equals("boolean") || type.equals("Boolean"))) {
            return "is" + methodVarName;
        }
        return "get" + methodVarName;
    }

    public static String createBeanMethodName(String varName) {
        return varName.substring(0, 1).toUpperCase() + varName.substring(1);
    }

    public boolean isGenerateSetter() {
        return this.generateSetter;
    }

    public void setGenerateSetter(boolean generateSetter) {
        this.generateSetter = generateSetter;
    }

    public boolean isGenerateGetter() {
        return this.generateGetter;
    }

    public void setGenerateGetter(boolean generateGetter) {
        this.generateGetter = generateGetter;
    }

    public Access getGenerateSetterAccess() {
        return this.generateSetterAccess;
    }

    public void setGenerateSetterAccess(Access generateSetterAccess) {
        this.generateSetterAccess = generateSetterAccess;
    }

    public Access getGenerateGetterAccess() {
        return this.generateGetterAccess;
    }

    public void setGenerateGetterAccess(Access generateGetterAccess) {
        this.generateGetterAccess = generateGetterAccess;
    }

    public boolean isGetterReturnsClone() {
        return this.getterReturnsClone;
    }

    public void setGetterReturnsClone(boolean getterReturnsClone) {
        this.getterReturnsClone = getterReturnsClone;
    }

    public boolean isSetterClonesParam() {
        return this.setterClonesParam;
    }

    public void setSetterClonesParam(boolean setterClonesParam) {
        this.setterClonesParam = setterClonesParam;
    }

    public void setCloneSetterGetterVar(boolean clonesParam) {
        this.setGetterReturnsClone(clonesParam);
        this.setSetterClonesParam(clonesParam);
    }
}

