/*
 * Decompiled with CFR 0.152.
 */
package org.dbtools.gen;

import java.io.File;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import org.dbtools.gen.DBObjectBuilder;
import org.dbtools.schema.SchemaDatabase;
import org.dbtools.schema.SchemaRenderer;
import org.dbtools.schema.SchemaTable;
import org.dbtools.util.PackageUtil;

public class GroupObjectBuilder {
    private String xmlFilename;
    private String schemaDatabaseName;
    private List<SchemaTable> tables;
    private String outputBaseDir;
    private String testOutputBaseDir;
    private String packageBase;
    private String author;
    private String version;
    private PrintStream psLog;
    private DBObjectBuilder objectBuilder;
    private SchemaRenderer schemaRenderer;

    public GroupObjectBuilder() {
        this.author = "";
        this.version = "";
        this.schemaRenderer = new SchemaRenderer();
    }

    public GroupObjectBuilder(String xmlFilename, String packageBase, String outputBaseDir) {
        this.setXmlFilename(xmlFilename);
        this.setPackageBase(packageBase);
        this.setOutputBaseDir(outputBaseDir);
    }

    private void resetData() {
        this.tables = null;
    }

    private boolean validate() {
        if (this.tables.size() == 0) {
            throw new IllegalStateException("No tables specified");
        }
        if (this.outputBaseDir == null || this.outputBaseDir.equals("")) {
            throw new IllegalStateException("No baseDir specified");
        }
        return true;
    }

    public boolean build() {
        if (this.schemaDatabaseName != null && !this.schemaDatabaseName.isEmpty()) {
            return this.build(this.schemaRenderer.getDbSchema().getDatabase(this.schemaDatabaseName));
        }
        return this.buildAllDatabases();
    }

    private boolean buildAllDatabases() {
        for (SchemaDatabase database : this.schemaRenderer.getDbSchema().getSchemaDatabases()) {
            this.resetData();
            if (this.build(database)) continue;
            return false;
        }
        return true;
    }

    private boolean build(SchemaDatabase database) {
        boolean success = true;
        if (this.tables == null) {
            this.tables = this.schemaRenderer.getTablesToGenerate(database, null);
        }
        if (this.validate()) {
            if (this.getObjectBuilder() == null) {
                throw new IllegalStateException("No Renderer specified");
            }
            Iterator<SchemaTable> itr = this.tables.iterator();
            while (itr.hasNext() && success) {
                File newTestDir;
                SchemaTable table = itr.next();
                String outDir = this.outputBaseDir + "/" + table.getClassName().toLowerCase();
                File newDir = new File(outDir);
                if (!newDir.exists()) {
                    newDir.mkdirs();
                }
                String testOutDir = "";
                if (this.createTests() && !(newTestDir = new File(testOutDir = this.testOutputBaseDir + "/" + table.getClassName().toLowerCase())).exists()) {
                    newTestDir.mkdirs();
                }
                String packageName = this.packageBase + "." + table.getClassName().toLowerCase();
                DBObjectBuilder objBuilder = this.getObjectBuilder();
                objBuilder.setDatabase(database);
                objBuilder.setTable(table);
                objBuilder.setPackageName(packageName);
                objBuilder.setSourceOutputDir(outDir);
                objBuilder.setTestOutputDir(testOutDir);
                objBuilder.setAuthor(this.author);
                objBuilder.setVersion(this.version);
                objBuilder.setLogPrintStream(this.psLog);
                success = objBuilder.build();
            }
        }
        return success;
    }

    public boolean createTests() {
        return this.testOutputBaseDir != null && this.testOutputBaseDir.length() > 0;
    }

    private void scanXMLFile() {
        File xmlFile = null;
        String filename = this.xmlFilename;
        if (!filename.equals("") && (xmlFile = new File(filename)) != null) {
            this.schemaRenderer.readXMLSchema(xmlFile.getPath(), "");
        }
    }

    public String getGeneratedPackageName() {
        return PackageUtil.getPackageFromFilePath(this.outputBaseDir);
    }

    public String getSchemaDatabaseName() {
        return this.schemaDatabaseName;
    }

    public void setSchemaDatabaseName(String schemaDatabaseName) {
        this.schemaDatabaseName = schemaDatabaseName;
    }

    public List getTables() {
        return this.tables;
    }

    public void setTables(List tables) {
        this.tables = tables;
    }

    public String getPackageBase() {
        return this.packageBase;
    }

    public void setPackageBase(String packageBase) {
        this.packageBase = packageBase;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public PrintStream getPsLog() {
        return this.psLog;
    }

    public void setPsLog(PrintStream psLog) {
        this.psLog = psLog;
    }

    public String getXmlFilename() {
        return this.xmlFilename;
    }

    public void setXmlFilename(String xmlFilename) {
        this.xmlFilename = xmlFilename;
        this.scanXMLFile();
    }

    public String getOutputBaseDir() {
        return this.outputBaseDir;
    }

    public void setOutputBaseDir(String outputBaseDir) {
        this.outputBaseDir = outputBaseDir;
    }

    public DBObjectBuilder getObjectBuilder() {
        return this.objectBuilder;
    }

    public void setObjectBuilder(DBObjectBuilder objectBuilder) {
        this.objectBuilder = objectBuilder;
    }

    public String getTestOutputBaseDir() {
        return this.testOutputBaseDir;
    }

    public void setTestOutputBaseDir(String testOutputBaseDir) {
        this.testOutputBaseDir = testOutputBaseDir;
    }
}

