/*
 * Decompiled with CFR 0.152.
 */
package org.dbtools.gen.android;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dbtools.codegen.Access;
import org.dbtools.codegen.DataType;
import org.dbtools.codegen.JavaClass;
import org.dbtools.codegen.JavaEnum;
import org.dbtools.codegen.JavaMethod;
import org.dbtools.codegen.JavaVariable;
import org.dbtools.schema.ClassInfo;
import org.dbtools.schema.SchemaDatabase;
import org.dbtools.schema.SchemaField;
import org.dbtools.schema.SchemaRenderer;
import org.dbtools.schema.SchemaTable;
import org.dbtools.schema.SqliteRenderer;

public class AndroidBaseRecordClassRenderer {
    private JavaClass myClass;
    private JavaClass myTestClass;
    private boolean writeTestClass = true;
    private List<JavaEnum> enumerationClasses = new ArrayList<JavaEnum>();
    private StringBuilder toStringContent;
    private StringBuilder cleanupOrphansContent;
    private boolean includeXML = false;
    private boolean useInnerEnums = true;
    public static final String CLEANUP_ORPHANS_METHODNAME = "cleanupOrphans";
    private static final String ALL_KEYS_VARNAME = "ALL_KEYS";
    private boolean uselegacyJUnit = false;
    private boolean useDateTime = false;
    private boolean dateTimeHelperMethodsAdded = false;
    public static final String PRIMARY_KEY_COLUMN = "PRIMARY_KEY_COLUMN";

    public void generateObjectCode(SchemaDatabase database, SchemaTable table, String packageName, PrintStream psLog) {
        String className = AndroidBaseRecordClassRenderer.createClassName(table);
        HashMap<String, String> sqlDataTypes = new HashMap<String, String>();
        HashMap<String, String> javaTypes = new HashMap<String, String>();
        SchemaRenderer.readXMLTypes(this.getClass(), "dbmappings.xml", "sqlite", sqlDataTypes, javaTypes);
        if (table.isEnumerationTable()) {
            String enumClassname = AndroidBaseRecordClassRenderer.createClassName(table);
            List<String> enums = table.getEnumerations();
            this.myClass = new JavaEnum(packageName, enumClassname, enums);
            this.myClass.setCreateDefaultConstructor(false);
            this.writeTestClass = false;
            if (enums.size() > 0) {
                this.myClass.addImport("java.util.Map");
                this.myClass.addImport("java.util.EnumMap");
                JavaVariable enumStringMapVar = this.myClass.addVariable("Map<" + enumClassname + ", String>", "enumStringMap", "new EnumMap<" + enumClassname + ", String>(" + enumClassname + ".class)");
                enumStringMapVar.setStatic(true);
                this.myClass.addImport("java.util.List");
                this.myClass.addImport("java.util.ArrayList");
                JavaVariable stringListVar = this.myClass.addVariable("List<String>", "stringList", "new ArrayList<String>()");
                stringListVar.setStatic(true);
                Map<String, String> enumValues = table.getEnumValues();
                for (String enumItem : enums) {
                    String enumValue = enumValues.get(enumItem);
                    if (enumValue == null) continue;
                    this.myClass.appendStaticInitializer("enumStringMap.put(" + enumItem + ", \"" + enumValue + "\");");
                    this.myClass.appendStaticInitializer("stringList.add(\"" + enumValue + "\");");
                    this.myClass.appendStaticInitializer("");
                }
                ArrayList<JavaVariable> getStringMParam = new ArrayList<JavaVariable>();
                getStringMParam.add(new JavaVariable(enumClassname, "key"));
                JavaMethod getStringM = this.myClass.addMethod(Access.PUBLIC, "String", "getString", getStringMParam, "return enumStringMap.get(key);");
                getStringM.setStatic(true);
                this.myClass.addImport("java.util.Collections");
                JavaMethod getListM = this.myClass.addMethod(Access.PUBLIC, "List<String>", "getList", "return Collections.unmodifiableList(stringList);");
                getListM.setStatic(true);
            }
        } else {
            this.myClass = new JavaClass(packageName, className);
            this.myClass.addImport(packageName.substring(0, packageName.lastIndexOf(46)) + ".BaseRecord");
            this.myClass.setExtends("BaseRecord");
            this.writeTestClass = true;
        }
        this.myTestClass = new JavaClass(packageName, className + "Test");
        this.initTestClass();
        this.toStringContent = new StringBuilder();
        this.toStringContent.append("String text = \"\\n\";\n");
        this.cleanupOrphansContent = new StringBuilder();
        String fileHeaderComment = "/*\n";
        fileHeaderComment = fileHeaderComment + " * " + className + ".java\n";
        fileHeaderComment = fileHeaderComment + " *\n";
        fileHeaderComment = fileHeaderComment + " * GENERATED FILE - DO NOT EDIT\n";
        fileHeaderComment = fileHeaderComment + " * CHECKSTYLE:OFF\n";
        fileHeaderComment = fileHeaderComment + " * \n";
        fileHeaderComment = fileHeaderComment + " */\n";
        this.myClass.setFileHeaderComment(fileHeaderComment);
        this.myClass.addAnnotation("@SuppressWarnings(\"all\")");
        String TAB = JavaClass.getTab();
        if (psLog == null) {
            psLog = System.out;
        }
        StringBuilder constructorElement = new StringBuilder();
        constructorElement.append("try {\n");
        boolean primaryKeyAdded = false;
        String databaseName = database.getName();
        this.myClass.addConstant("String", "DATABASE", databaseName);
        String tableName = table.getName();
        this.myClass.addConstant("String", "TABLE", tableName);
        this.myClass.addConstant("String", "FULL_TABLE", databaseName + "." + tableName);
        if (!this.myClass.isEnum()) {
            this.myClass.addMethod(Access.PUBLIC, "String", "getDatabaseName", "return DATABASE;").addAnnotation("Override");
            this.myClass.addMethod(Access.PUBLIC, "String", "getTableName", "return TABLE;").addAnnotation("Override");
        }
        String contentValuesContent = "ContentValues values = new ContentValues();\n";
        String setContentValuesContent = "";
        String setContentCursorContent = "";
        List<SchemaField> fields = table.getFields();
        ArrayList<String> keys = new ArrayList<String>();
        block6: for (SchemaField field : fields) {
            boolean primaryKey = field.isPrimaryKey();
            String fieldName = field.getName();
            String fieldNameJavaStyle = field.getName(true);
            if (primaryKey && primaryKeyAdded) {
                throw new IllegalStateException("Cannot have more than 1 Primary Key [" + fieldNameJavaStyle + "]");
            }
            primaryKeyAdded = true;
            String constName = JavaClass.formatConstant(fieldNameJavaStyle);
            String fieldKey = "C_" + constName;
            keys.add(fieldKey);
            if (primaryKey) {
                this.myClass.addConstant("String", PRIMARY_KEY_COLUMN, fieldName);
            }
            this.myClass.addConstant("String", fieldKey, fieldName);
            this.myClass.addConstant("String", "FULL_C_" + constName, tableName + "." + fieldName);
            switch (field.getForeignKeyType()) {
                case MANYTOONE: {
                    this.generateManyToOne(database, packageName, field, table);
                    continue block6;
                }
                case ONETOMANY: {
                    this.generateOneToMany(table, field, packageName, database);
                    continue block6;
                }
                case ONETOONE: {
                    this.generateOneToOne(database, table, field, packageName);
                    continue block6;
                }
            }
            this.createToStringMethodContent(field, fieldNameJavaStyle);
            JavaVariable newVariable = null;
            newVariable = field.isEnumeration() ? this.generateEnumeration(field, fieldNameJavaStyle, packageName, database) : this.generateFieldVariable(fieldNameJavaStyle, field);
            if (primaryKey && !this.myClass.isEnum()) {
                this.myClass.addMethod(Access.PUBLIC, "String", "getRowIDKey", "return " + fieldKey + ";").addAnnotation("Override");
                this.myClass.addMethod(Access.PUBLIC, field.getJavaTypeText(), "getPrimaryKeyID", "return " + fieldNameJavaStyle + ";").addAnnotation("Override");
                ArrayList<JavaVariable> setIDParams = new ArrayList<JavaVariable>();
                setIDParams.add(new JavaVariable(newVariable.getDataType(), "id"));
                this.myClass.addMethod(Access.PUBLIC, "void", "setPrimaryKeyID", setIDParams, "this." + fieldNameJavaStyle + " = id;").addAnnotation("Override");
            }
            if (!this.myClass.isEnum()) {
                this.myClass.addVariable(newVariable);
            }
            if (!primaryKey || !field.isIncrement()) {
                String value = fieldNameJavaStyle;
                if (field.isEnumeration()) {
                    value = newVariable.getName() + ".ordinal()";
                } else if (field.getJavaClassType() == Date.class) {
                    if (field.getJdbcType().equals("DATE")) {
                        String methodName = this.useDateTime ? "dateTimeToDBString" : "dateToDBString";
                        value = methodName + "(" + fieldNameJavaStyle + ")";
                    } else {
                        String getTimeMethod = this.useDateTime ? ".getMillis()" : ".getTime()";
                        value = fieldNameJavaStyle + " != null ? " + fieldNameJavaStyle + getTimeMethod + " : null";
                    }
                }
                contentValuesContent = contentValuesContent + "values.put(" + fieldKey + ", " + value + ");\n";
                setContentValuesContent = setContentValuesContent + fieldNameJavaStyle + " = " + this.getContentValuesGetterMethod(field, fieldKey, newVariable) + ";\n";
            }
            setContentCursorContent = setContentCursorContent + fieldNameJavaStyle + " = " + this.getContentValuesCursorGetterMethod(field, fieldKey, newVariable) + ";\n";
        }
        String createTable = SqliteRenderer.generateTableSchema(table, sqlDataTypes);
        createTable = createTable.replace("\n", "\" + \n" + TAB + TAB + "\"");
        createTable = createTable.replace("\t", "");
        this.myClass.addConstant("String", "CREATE_TABLE", createTable);
        this.myClass.addConstant("String", "DROP_TABLE", SchemaRenderer.generateDropSchema(true, table));
        if (!this.myClass.isEnum()) {
            this.myClass.addImport("android.content.ContentValues");
            this.myClass.addImport("android.database.Cursor");
            String allKeysDefaultValue = "new String[] {\n";
            boolean hasKey = false;
            for (String key : keys) {
                if (hasKey) {
                    allKeysDefaultValue = allKeysDefaultValue + ",\n";
                }
                allKeysDefaultValue = allKeysDefaultValue + TAB + TAB + key;
                hasKey = true;
            }
            allKeysDefaultValue = allKeysDefaultValue + "}";
            JavaVariable allKeysVar = this.myClass.addConstant("String[]", ALL_KEYS_VARNAME, allKeysDefaultValue);
            allKeysVar.setAccess(Access.DEFAULT_NONE);
            this.myClass.addMethod(Access.PUBLIC, "String[]", "getAllKeys", "return ALL_KEYS.clone();").addAnnotation("Override");
            contentValuesContent = contentValuesContent + "return values;";
            this.myClass.addMethod(Access.PUBLIC, "ContentValues", "getContentValues", contentValuesContent).addAnnotation("Override");
            ArrayList<JavaVariable> setCValuesParams = new ArrayList<JavaVariable>();
            setCValuesParams.add(new JavaVariable("ContentValues", "values"));
            this.myClass.addMethod(Access.PUBLIC, "void", "setContent", setCValuesParams, setContentValuesContent);
            ArrayList<JavaVariable> setCCursorParams = new ArrayList<JavaVariable>();
            setCCursorParams.add(new JavaVariable("Cursor", "cursor"));
            this.myClass.addMethod(Access.PUBLIC, "void", "setContent", setCCursorParams, setContentCursorContent).addAnnotation("Override");
        }
        this.addForgeignKeyData(database, table, packageName);
        if (!this.myClass.isEnum()) {
            ArrayList<JavaVariable> orphanParams = new ArrayList<JavaVariable>();
            if (this.cleanupOrphansContent.length() > 0) {
                this.myClass.addMethod(Access.PROTECTED, "void", CLEANUP_ORPHANS_METHODNAME, orphanParams, this.cleanupOrphansContent.toString());
            }
            this.toStringContent.append("return text;\n");
            JavaMethod toStringMethod = this.myClass.addMethod(Access.PUBLIC, "String", "toString", this.toStringContent.toString());
            toStringMethod.addAnnotation("Override");
            this.myClass.addMethod(Access.PUBLIC, "boolean", "isNewRecord", "return getPrimaryKeyID() <= 0;");
            JavaMethod toStringTestMethod = this.myTestClass.addMethod(Access.PUBLIC, "void", "testToString", "assertNotNull(testRecord.toString());");
            toStringTestMethod.addAnnotation("Test");
        }
        if (this.myClass.isEnum()) {
            // empty if block
        }
    }

    private String getContentValuesGetterMethod(SchemaField field, String paramValue, JavaVariable newVariable) {
        if (field.isEnumeration()) {
            return newVariable.getDataType() + ".values()[values.getAsInteger(" + paramValue + ")]";
        }
        Class<?> type = field.getJavaClassType();
        if (type == Integer.TYPE || type == Integer.class) {
            return "values.getAsInteger(" + paramValue + ")";
        }
        if (type == String.class) {
            return "values.getAsString(" + paramValue + ")";
        }
        if (type == Long.TYPE || type == Long.class) {
            return "values.getAsLong(" + paramValue + ")";
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return "values.getAsBoolean(" + paramValue + ")";
        }
        if (type == Date.class) {
            if (field.getJdbcType().equals("DATE")) {
                if (this.useDateTime) {
                    return "dbStringToDateTime(values.getAsString(" + paramValue + "))";
                }
                return "dbStringToDate(values.getAsString(" + paramValue + "))";
            }
            if (this.useDateTime) {
                return "new org.joda.time.DateTime(values.getAsLong(" + paramValue + "))";
            }
            return "new java.util.Date(values.getAsLong(" + paramValue + "))";
        }
        if (type == Float.TYPE || type == Float.class) {
            return "values.getAsFloat(" + paramValue + ")";
        }
        if (type == Double.TYPE || type == Double.class) {
            return "values.getAsDouble(" + paramValue + ")";
        }
        return "[[UNHANDLED FIELD TYPE: " + type + "]]";
    }

    private String getContentValuesCursorGetterMethod(SchemaField field, String paramValue, JavaVariable newVariable) {
        if (field.isEnumeration()) {
            return newVariable.getDataType() + ".values()[cursor.getInt(cursor.getColumnIndex(" + paramValue + "))]";
        }
        Class<?> type = field.getJavaClassType();
        if (type == Integer.TYPE || type == Integer.class) {
            return "cursor.getInt(cursor.getColumnIndex(" + paramValue + "))";
        }
        if (type == String.class) {
            return "cursor.getString(cursor.getColumnIndex(" + paramValue + "))";
        }
        if (type == Long.TYPE || type == Long.class) {
            return "cursor.getLong(cursor.getColumnIndex(" + paramValue + "))";
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return "cursor.getInt(cursor.getColumnIndex(" + paramValue + ")) != 0 ? true : false";
        }
        if (type == Date.class) {
            if (field.getJdbcType().equals("DATE")) {
                if (this.useDateTime) {
                    return "dbStringToDateTime(cursor.getString(cursor.getColumnIndex(" + paramValue + ")))";
                }
                return "dbStringToDate(cursor.getString(cursor.getColumnIndex(" + paramValue + ")))";
            }
            if (this.useDateTime) {
                return "!cursor.isNull(cursor.getColumnIndex(" + paramValue + ")) ? new org.joda.time.DateTime(cursor.getLong(cursor.getColumnIndex(" + paramValue + "))) : null";
            }
            return "!cursor.isNull(cursor.getColumnIndex(" + paramValue + ")) ? new java.util.Date(cursor.getLong(cursor.getColumnIndex(" + paramValue + "))) : null";
        }
        if (type == Float.TYPE || type == Float.class) {
            return "cursor.getFloat(cursor.getColumnIndex(" + paramValue + "))";
        }
        if (type == Double.TYPE || type == Double.class) {
            return "cursor.getDouble(cursor.getColumnIndex(" + paramValue + "))";
        }
        return "[[UNHANDLED FIELD TYPE: " + type + "]]";
    }

    private void createToStringMethodContent(SchemaField field, String fieldNameJavaStyle) {
        String fieldType = field.getJdbcType();
        if (!fieldType.equals("BLOB") && !fieldType.equals("CLOB")) {
            this.toStringContent.append("text += \"").append(fieldNameJavaStyle).append(" = \"+ ").append(fieldNameJavaStyle).append(" +\"\\n\";\n");
        }
    }

    private JavaVariable generateEnumeration(SchemaField field, String fieldNameJavaStyle, String packageName, SchemaDatabase database) {
        JavaVariable newVariable;
        if (field.isNumberDataType()) {
            if (field.getForeignKeyTable().length() > 0) {
                ClassInfo enumClassInfo = database.getTableClassInfo(field.getForeignKeyTable());
                String enumName = enumClassInfo.getClassName();
                List<String> localEnumerations = field.getEnumerations();
                if (localEnumerations != null && localEnumerations.size() > 0) {
                    this.myClass.addEnum(enumName, field.getEnumerations());
                } else {
                    String enumPackage = enumClassInfo.getPackageName(packageName) + "." + enumName;
                    this.myClass.addImport(enumPackage);
                }
                newVariable = new JavaVariable(enumName, fieldNameJavaStyle);
                newVariable.setGenerateSetterGetter(true);
                newVariable.setDefaultValue(enumName + "." + field.getEnumerationDefault(), false);
                this.addSetterGetterTest(newVariable);
            } else {
                String javaStyleFieldName = field.getName(true);
                String firstChar = javaStyleFieldName.substring(0, 1).toUpperCase();
                String enumName = firstChar + javaStyleFieldName.substring(1);
                if (this.useInnerEnums) {
                    this.myClass.addEnum(enumName, field.getEnumerations());
                } else {
                    this.enumerationClasses.add(new JavaEnum(enumName, field.getEnumerations()));
                }
                newVariable = new JavaVariable(enumName, fieldNameJavaStyle);
                newVariable.setGenerateSetterGetter(true);
                newVariable.setDefaultValue(enumName + "." + field.getEnumerationDefault(), false);
                this.addSetterGetterTest(newVariable);
            }
        } else {
            newVariable = new JavaVariable(field.getJavaTypeText(), fieldNameJavaStyle);
        }
        return newVariable;
    }

    private JavaVariable generateFieldVariable(String fieldNameJavaStyle, SchemaField field) {
        boolean immutableDate;
        JavaVariable newVariable = null;
        String typeText = field.getJavaTypeText();
        String defaultValue = field.getFormattedClassDefaultValue();
        boolean dateType = typeText.endsWith("Date");
        newVariable = dateType && this.useDateTime ? new JavaVariable("org.joda.time.DateTime", fieldNameJavaStyle) : new JavaVariable(typeText, fieldNameJavaStyle);
        boolean bl = immutableDate = field.getJavaClassType() == Date.class && this.useDateTime;
        if (!(field.isJavaTypePrimative() || field.isJavaTypeImmutable() || immutableDate)) {
            newVariable.setCloneSetterGetterVar(true);
        }
        newVariable.setGenerateSetterGetter(true);
        this.addSetterGetterTest(newVariable);
        newVariable.setDefaultValue(defaultValue);
        return newVariable;
    }

    private void generateManyToOne(SchemaDatabase dbSchema, String packageName, SchemaField field, SchemaTable table) {
        String fkTableName = field.getForeignKeyTable();
        ClassInfo fkTableClassInfo = dbSchema.getTableClassInfo(fkTableName);
        String fkTableClassName = fkTableClassInfo.getClassName();
        String varName = field.getCustomVarName();
        if (varName.equals("")) {
            varName = JavaClass.formatToJavaVariable(fkTableClassName);
        }
        String newImport = fkTableClassInfo.getPackageName(packageName) + ".*";
        this.myClass.addImport(newImport);
        JavaVariable manyToOneVar = new JavaVariable(fkTableClassName, varName);
        this.myClass.addVariable(manyToOneVar, true);
    }

    private void generateOneToMany(SchemaTable table, SchemaField field, String packageName, SchemaDatabase database) {
        String fkTableName = field.getForeignKeyTable();
        ClassInfo fkTableClassInfo = database.getTableClassInfo(fkTableName);
        String fkTableClassName = fkTableClassInfo.getClassName();
        String varName = field.getCustomVarName();
        if (varName.equals("")) {
            varName = JavaClass.formatToJavaVariable(fkTableClassName);
        }
        String newImport = fkTableClassInfo.getPackageName(packageName) + ".*";
        this.myClass.addImport(newImport);
        JavaVariable manyToOneVar = new JavaVariable(fkTableClassName, varName);
        this.myClass.addVariable(manyToOneVar, true);
    }

    private void generateOneToOne(SchemaDatabase database, SchemaTable table, SchemaField field, String packageName) {
        String fkTableName = field.getForeignKeyTable();
        ClassInfo fkTableClassInfo = database.getTableClassInfo(fkTableName);
        String fkTableClassName = fkTableClassInfo.getClassName();
        String varName = field.getCustomVarName();
        if (varName.equals("")) {
            varName = JavaClass.formatToJavaVariable(fkTableClassName);
        }
        String newImport = fkTableClassInfo.getPackageName(packageName) + ".*";
        this.myClass.addImport(newImport);
        JavaVariable oneToOneVar = new JavaVariable(fkTableClassName, varName);
        this.myClass.addVariable(oneToOneVar, true);
    }

    private void addForgeignKeyData(SchemaDatabase database, SchemaTable table, String packageName) {
        String TAB = JavaClass.getTab();
        for (SchemaTable tmpTable : database.getTables()) {
            List<SchemaField> fkFields = tmpTable.getForeignKeyFields(table.getName());
            for (SchemaField fkField : fkFields) {
                switch (fkField.getForeignKeyType()) {
                    case ONETOMANY: {
                        String fkTableName = tmpTable.getName();
                        ClassInfo fkTableClassInfo = database.getTableClassInfo(fkTableName);
                        String fkTableClassName = fkTableClassInfo.getClassName();
                        String fkTableVarName = JavaClass.formatToJavaVariable(fkTableClassName);
                        String newImport = fkTableClassInfo.getPackageName(packageName) + ".*";
                        String items = fkTableVarName + "Items";
                        String itemsToDelete = fkTableVarName + "ItemsToDelete";
                        this.myClass.addImport(newImport);
                        this.myClass.addImport("java.util.Set");
                        this.myClass.addImport("java.util.HashSet");
                        String listType = "Set<" + fkTableClassName + ">";
                        String defaultListTypeValue = "new HashSet<" + fkTableClassName + ">()";
                        JavaVariable itemsList = this.myClass.addVariable(listType, items);
                        itemsList.setDefaultValue(defaultListTypeValue);
                        this.myClass.addMethod(Access.PUBLIC, listType, JavaVariable.getGetterMethodName(listType, items), "return java.util.Collections.unmodifiableSet(" + items + ");");
                        ClassInfo mappedByClassInfo = database.getTableClassInfo(fkField.getForeignKeyTable());
                        String mappedByVarName = JavaClass.formatToJavaVariable(mappedByClassInfo.getClassName());
                        JavaMethod addMethod = new JavaMethod("add" + fkTableClassName);
                        addMethod.setAccess(Access.PUBLIC);
                        addMethod.addParameter(new JavaVariable(fkTableClassName, fkTableVarName));
                        String addMethodContent = "";
                        ClassInfo myTableClassInfo = database.getTableClassInfo(fkField.getForeignKeyTable());
                        String tableClassName = myTableClassInfo.getClassName();
                        String fieldName = fkField.getCustomVarName();
                        if (fieldName == null || fieldName.length() == 0) {
                            fieldName = tableClassName;
                        }
                        String setterMethodName = "set" + fieldName.toUpperCase().charAt(0) + fieldName.substring(1, fieldName.length());
                        addMethodContent = addMethodContent + fkTableVarName + "." + setterMethodName + "((" + tableClassName + ")this);\n";
                        addMethodContent = addMethodContent + items + ".add(" + fkTableVarName + ");\n";
                        addMethod.setContent(addMethodContent);
                        this.myClass.addMethod(addMethod);
                        JavaVariable itemsToDeleteList = this.myClass.addVariable(listType, itemsToDelete);
                        itemsToDeleteList.setDefaultValue(defaultListTypeValue);
                        JavaMethod removeMethod = new JavaMethod("delete" + fkTableClassName);
                        removeMethod.setAccess(Access.PUBLIC);
                        removeMethod.addParameter(new JavaVariable(fkTableClassName, fkTableVarName));
                        String removeMethodContent = "";
                        removeMethodContent = removeMethodContent + "if (" + fkTableVarName + " == null) {\n";
                        removeMethodContent = removeMethodContent + TAB + "return;\n";
                        removeMethodContent = removeMethodContent + "}\n\n";
                        removeMethodContent = removeMethodContent + "java.util.Iterator<" + fkTableClassName + "> itr = " + items + ".iterator();\n";
                        removeMethodContent = removeMethodContent + "while (itr.hasNext()) {\n";
                        removeMethodContent = removeMethodContent + TAB + fkTableClassName + " item = itr.next();\n";
                        removeMethodContent = removeMethodContent + TAB + "if (item.equals(" + fkTableVarName + ")) {\n";
                        removeMethodContent = removeMethodContent + TAB + TAB + "itr.remove();\n";
                        removeMethodContent = removeMethodContent + TAB + TAB + itemsToDelete + ".add(item);\n";
                        removeMethodContent = removeMethodContent + TAB + TAB + "break;\n";
                        removeMethodContent = removeMethodContent + TAB + "}\n";
                        removeMethodContent = removeMethodContent + TAB + "if (!itr.hasNext()) {\n";
                        removeMethodContent = removeMethodContent + TAB + TAB + "throw new IllegalStateException(\"deleteItem failed: Cannot find itemID \"+ " + fkTableVarName + ".getPrimaryKeyID());\n";
                        removeMethodContent = removeMethodContent + TAB + "}\n";
                        removeMethodContent = removeMethodContent + "}";
                        removeMethod.setContent(removeMethodContent);
                        this.myClass.addMethod(removeMethod);
                        this.cleanupOrphansContent.append("for (" + fkTableClassName + " itemToDelete : " + itemsToDelete + ") {\n");
                        this.cleanupOrphansContent.append(TAB + "try {\n");
                        this.cleanupOrphansContent.append(TAB + TAB + "em.remove(itemToDelete);\n");
                        this.cleanupOrphansContent.append(TAB + "} catch(RuntimeException e) {// do nothing... it is ok if it does not exist\n");
                        this.cleanupOrphansContent.append(TAB + "}\n");
                        this.cleanupOrphansContent.append("}\n\n");
                        break;
                    }
                    case ONETOONE: {
                        break;
                    }
                }
            }
        }
    }

    public static String createClassName(SchemaTable table) {
        if (table.isEnumerationTable()) {
            return table.getClassName();
        }
        return table.getClassName() + "BaseRecord";
    }

    public String getFilename() {
        return this.myClass.getFilename();
    }

    public void writeToFile(String directoryname) {
        this.myClass.writeToDisk(directoryname);
        for (JavaEnum enumClass : this.enumerationClasses) {
            enumClass.writeToDisk(directoryname);
        }
    }

    public void writeTestsToFile(String directoryname) {
        if (this.writeTestClass) {
            this.myTestClass.writeToDisk(directoryname);
        }
    }

    private void initTestClass() {
        this.myTestClass.addImport("org.junit.*");
        this.myTestClass.addImport("static org.junit.Assert.*");
        String fileHeaderComment = "/*\n";
        fileHeaderComment = fileHeaderComment + " * " + this.myTestClass.getName() + ".java\n";
        fileHeaderComment = fileHeaderComment + " * \n";
        fileHeaderComment = fileHeaderComment + " * GENERATED FILE - DO NOT EDIT\n";
        fileHeaderComment = fileHeaderComment + " * \n";
        fileHeaderComment = fileHeaderComment + " */\n";
        this.myTestClass.setFileHeaderComment(fileHeaderComment);
        if (this.uselegacyJUnit) {
            ArrayList<JavaVariable> params = new ArrayList<JavaVariable>();
            params.add(new JavaVariable("String", "testName"));
            this.myTestClass.addConstructor(Access.PUBLIC, params, "super(testName);");
        } else {
            this.myTestClass.setCreateDefaultConstructor(true);
        }
        this.myTestClass.addVariable(this.myClass.getName(), "testRecord");
        JavaMethod setUpMethod = this.myTestClass.addMethod(Access.PUBLIC, "void", "setUp", "testRecord = new " + this.myClass.getName() + "();\nassertNotNull(testRecord);");
        if (!this.uselegacyJUnit) {
            setUpMethod.addAnnotation("Before");
        }
        JavaMethod tearDownMethod = this.myTestClass.addMethod(Access.PUBLIC, "void", "tearDown", null);
        if (!this.uselegacyJUnit) {
            tearDownMethod.addAnnotation("After");
        }
    }

    private void addSetterGetterTest(JavaVariable newVariable) {
        DataType dataType = DataType.getDataType(newVariable.getDataType());
        JavaMethod testMethod = new JavaMethod(Access.PUBLIC, "void", "test" + JavaVariable.createBeanMethodName(newVariable.getName()));
        StringBuilder testContent = new StringBuilder();
        if (!this.uselegacyJUnit) {
            testMethod.addAnnotation("Test");
        }
        switch (dataType) {
            case STRING: {
                testContent.append("String testData = \"abc\";\n");
                testContent.append("testRecord." + newVariable.getSetterMethodName() + "(testData);\n");
                testContent.append("String recordData = testRecord." + newVariable.getGetterMethodName() + "();\n");
                testContent.append("assertEquals(testData, recordData);");
                break;
            }
            case CHAR: {
                testContent.append("char testData = 'z';\n");
                testContent.append("testRecord." + newVariable.getSetterMethodName() + "(testData);\n");
                testContent.append("char recordData = testRecord." + newVariable.getGetterMethodName() + "();\n");
                testContent.append("assertEquals(testData, recordData);");
                break;
            }
            case BOOLEAN: {
                testContent.append("boolean testData = false;\n");
                testContent.append("testRecord." + newVariable.getSetterMethodName() + "(testData);\n");
                testContent.append("boolean recordData = testRecord." + newVariable.getGetterMethodName() + "();\n");
                testContent.append("assertEquals(testData, recordData);");
                break;
            }
            case INT: {
                testContent.append("int testData = 123;\n");
                testContent.append("testRecord." + newVariable.getSetterMethodName() + "(testData);\n");
                testContent.append("int recordData = testRecord." + newVariable.getGetterMethodName() + "();\n");
                testContent.append("assertEquals(testData, recordData);");
                break;
            }
            case FLOAT: {
                testContent.append("float testData = 123.56f;\n");
                testContent.append("testRecord." + newVariable.getSetterMethodName() + "(testData);\n");
                testContent.append("float recordData = testRecord." + newVariable.getGetterMethodName() + "();\n");
                testContent.append("assertEquals(testData, recordData, 0);");
                break;
            }
            case DOUBLE: {
                testContent.append("double testData = 123.56;\n");
                testContent.append("testRecord." + newVariable.getSetterMethodName() + "(testData);\n");
                testContent.append("double recordData = testRecord." + newVariable.getGetterMethodName() + "();\n");
                testContent.append("assertEquals(testData, recordData, 0);");
                break;
            }
            case DATE: {
                this.myTestClass.addImport("java.util.Calendar");
                this.myTestClass.addImport("java.util.Date");
                testContent.append("Calendar testData = Calendar.getInstance();\n");
                testContent.append("int testYear = 1980;\n");
                testContent.append("int testMonth = 2;\n");
                testContent.append("int testDay = 1;\n");
                testContent.append("testData.set(1980, 2, 1);\n");
                testContent.append("testRecord." + newVariable.getSetterMethodName() + "(testData.getTime());\n");
                testContent.append("Date recordDataDate = testRecord." + newVariable.getGetterMethodName() + "();\n");
                testContent.append("Calendar recordData = Calendar.getInstance();\n");
                testContent.append("recordData.setTime(recordDataDate);\n");
                testContent.append("int year = recordData.get(Calendar.YEAR);\n");
                testContent.append("int month = recordData.get(Calendar.MONTH);\n");
                testContent.append("int day = recordData.get(Calendar.DATE);\n");
                testContent.append("assertEquals(testYear, year);\n");
                testContent.append("assertEquals(testMonth, month);\n");
                testContent.append("assertEquals(testDay, day);\n");
            }
        }
        testMethod.setContent(testContent.toString());
        this.myTestClass.addMethod(testMethod);
    }

    public boolean isIncludeXML() {
        return this.includeXML;
    }

    public void setIncludeXML(boolean includeXML) {
        this.includeXML = includeXML;
    }

    public void setUseDateTime(boolean useDateTime) {
        this.useDateTime = useDateTime;
    }

    public boolean isUseInnerEnums() {
        return this.useInnerEnums;
    }

    public void setUseInnerEnums(boolean useInnerEnums) {
        this.useInnerEnums = useInnerEnums;
    }
}

