/*
 * Decompiled with CFR 0.152.
 */
package org.dbtools.gen.android;

import java.io.PrintStream;
import java.util.ArrayList;
import org.dbtools.codegen.Access;
import org.dbtools.codegen.JavaClass;
import org.dbtools.codegen.JavaVariable;
import org.dbtools.gen.android.AndroidRecordClassRenderer;
import org.dbtools.schema.SchemaTable;

public class AndroidBaseRecordManager {
    private JavaClass myClass;
    private boolean injectionSupport = false;

    public AndroidBaseRecordManager(boolean injectionSupport) {
        this.injectionSupport = injectionSupport;
    }

    public void generateObjectCode(SchemaTable table, String packageName, String author, String version, PrintStream psLog) {
        String baseManagerCall;
        String TAB = JavaClass.getTab();
        String recordClassName = AndroidRecordClassRenderer.createClassName(table);
        String className = AndroidBaseRecordManager.getClassName(table);
        this.myClass = new JavaClass(packageName, className);
        String fileHeaderComment = "/*\n";
        fileHeaderComment = fileHeaderComment + " * " + className + ".java\n";
        fileHeaderComment = fileHeaderComment + " *\n";
        fileHeaderComment = fileHeaderComment + " * GENERATED FILE - DO NOT EDIT\n";
        fileHeaderComment = fileHeaderComment + " * CHECKSTYLE:OFF\n";
        fileHeaderComment = fileHeaderComment + " * \n";
        fileHeaderComment = fileHeaderComment + " */\n";
        this.myClass.setFileHeaderComment(fileHeaderComment);
        this.myClass.addAnnotation("@SuppressWarnings(\"all\")");
        this.myClass.setCreateDefaultConstructor(true);
        this.myClass.addImport(packageName.substring(0, packageName.lastIndexOf(46)) + ".BaseManager");
        String string = baseManagerCall = this.injectionSupport ? "" : "BaseManager.";
        if (this.injectionSupport) {
            this.myClass.setExtends("BaseManager<" + recordClassName + ">");
            this.myClass.addMethod(Access.PUBLIC, "String", "getDatabaseName", "return " + recordClassName + ".DATABASE;");
            this.myClass.addMethod(Access.PUBLIC, "String", "getTableName", "return " + recordClassName + ".TABLE;");
            this.myClass.addMethod(Access.PUBLIC, "String", "getPrimaryKey", "return " + recordClassName + "." + "PRIMARY_KEY_COLUMN" + ";");
            this.myClass.addMethod(Access.PUBLIC, "String[]", "getAllKeys", "return " + recordClassName + ".ALL_KEYS;");
            this.myClass.addMethod(Access.PUBLIC, "String", "getDropTableSQL", "return " + recordClassName + ".DROP_TABLE;");
            this.myClass.addMethod(Access.PUBLIC, "String", "getCreateTableSQL", "return " + recordClassName + ".CREATE_TABLE;");
            this.myClass.addMethod(Access.PUBLIC, recordClassName, "newRecord", "return new " + recordClassName + "();");
        } else {
            String baseFindContent;
            this.myClass.addImport("android.content.ContentValues");
            this.myClass.addImport("android.database.Cursor");
            String dbParam = "db, ";
            this.myClass.addImport("android.database.sqlite.SQLiteDatabase");
            ArrayList<JavaVariable> sqliteParams = new ArrayList<JavaVariable>();
            sqliteParams.add(new JavaVariable("SQLiteDatabase", "db"));
            String dropTableContent = baseManagerCall + "executeSQL(db, " + recordClassName + ".DROP_TABLE);";
            this.myClass.addMethod(Access.PUBLIC, "void", "dropTable", sqliteParams, dropTableContent).setStatic(!this.injectionSupport);
            String createTableContent = baseManagerCall + "executeSQL(db, " + recordClassName + ".CREATE_TABLE);";
            this.myClass.addMethod(Access.PUBLIC, "void", "createTable", sqliteParams, createTableContent).setStatic(!this.injectionSupport);
            ArrayList<JavaVariable> crudParams = new ArrayList<JavaVariable>();
            crudParams.add(new JavaVariable("SQLiteDatabase", "db"));
            crudParams.add(new JavaVariable(recordClassName, "record"));
            this.myClass.addMethod(Access.PUBLIC, "long", "insert", crudParams, "return " + baseManagerCall + "insert(db, record);").setStatic(!this.injectionSupport);
            this.myClass.addMethod(Access.PUBLIC, "int", "update", crudParams, "return " + baseManagerCall + "update(db, record);").setStatic(!this.injectionSupport);
            this.myClass.addMethod(Access.PUBLIC, "long", "delete", crudParams, "return " + baseManagerCall + "delete(db, record);").setStatic(!this.injectionSupport);
            ArrayList<JavaVariable> updateParams3 = new ArrayList<JavaVariable>();
            if (!this.injectionSupport) {
                updateParams3.add(new JavaVariable("SQLiteDatabase", "db"));
            }
            updateParams3.add(new JavaVariable("ContentValues", "values"));
            updateParams3.add(new JavaVariable("long", "rowID"));
            this.myClass.addMethod(Access.PUBLIC, "int", "update", updateParams3, "return " + baseManagerCall + "update(" + dbParam + recordClassName + ".TABLE, values, " + recordClassName + "." + "PRIMARY_KEY_COLUMN" + ", rowID);").setStatic(!this.injectionSupport);
            ArrayList<JavaVariable> updateParams4 = new ArrayList<JavaVariable>();
            if (!this.injectionSupport) {
                updateParams4.add(new JavaVariable("SQLiteDatabase", "db"));
            }
            updateParams4.add(new JavaVariable("ContentValues", "values"));
            updateParams4.add(new JavaVariable("String", "where"));
            updateParams4.add(new JavaVariable("String[]", "whereArgs"));
            this.myClass.addMethod(Access.PUBLIC, "int", "update", updateParams4, "return " + baseManagerCall + "update(" + dbParam + recordClassName + ".TABLE, values, where, whereArgs);").setStatic(!this.injectionSupport);
            ArrayList<JavaVariable> deleteParams2 = new ArrayList<JavaVariable>();
            if (!this.injectionSupport) {
                deleteParams2.add(new JavaVariable("SQLiteDatabase", "db"));
            }
            deleteParams2.add(new JavaVariable("long", "rowID"));
            this.myClass.addMethod(Access.PUBLIC, "long", "delete", deleteParams2, "return " + baseManagerCall + "delete(" + dbParam + recordClassName + ".TABLE, " + recordClassName + "." + "PRIMARY_KEY_COLUMN" + ", rowID);").setStatic(!this.injectionSupport);
            ArrayList<JavaVariable> deleteParams3 = new ArrayList<JavaVariable>();
            if (!this.injectionSupport) {
                deleteParams3.add(new JavaVariable("SQLiteDatabase", "db"));
            }
            deleteParams3.add(new JavaVariable("String", "where"));
            deleteParams3.add(new JavaVariable("String[]", "whereArgs"));
            this.myClass.addMethod(Access.PUBLIC, "long", "delete", deleteParams3, "return " + baseManagerCall + "delete(" + dbParam + recordClassName + ".TABLE, where, whereArgs);").setStatic(!this.injectionSupport);
            String dbVar = this.injectionSupport ? "getReadableDatabase()" : "db";
            String findCursorBySelectionContent = baseFindContent = "Cursor cursor = " + dbVar + ".query(true, " + recordClassName + ".TABLE, " + recordClassName + ".ALL_KEYS," + " selection," + " null, null, null, orderBy, null);\n\n";
            findCursorBySelectionContent = findCursorBySelectionContent + "if (cursor != null) {\n";
            findCursorBySelectionContent = findCursorBySelectionContent + TAB + "cursor.moveToFirst();\n";
            findCursorBySelectionContent = findCursorBySelectionContent + TAB + "return cursor;\n";
            findCursorBySelectionContent = findCursorBySelectionContent + "} else {\n";
            findCursorBySelectionContent = findCursorBySelectionContent + TAB + "return null;\n";
            findCursorBySelectionContent = findCursorBySelectionContent + "}\n";
            ArrayList<JavaVariable> findParams = new ArrayList<JavaVariable>();
            if (!this.injectionSupport) {
                findParams.add(new JavaVariable("SQLiteDatabase", "db"));
            }
            findParams.add(new JavaVariable("String", "selection"));
            findParams.add(new JavaVariable("String", "orderBy"));
            this.myClass.addMethod(Access.PUBLIC, "Cursor", "findCursorBySelection", findParams, findCursorBySelectionContent).setStatic(!this.injectionSupport);
            String selectionByRowID = recordClassName + "." + "PRIMARY_KEY_COLUMN" + "+ \"=\" + rowID";
            String findCursorByRowIDContent = "return findCursorBySelection(" + dbParam + selectionByRowID + ", null);";
            ArrayList<JavaVariable> findByRowIdParams = new ArrayList<JavaVariable>();
            if (!this.injectionSupport) {
                findByRowIdParams.add(new JavaVariable("SQLiteDatabase", "db"));
            }
            findByRowIdParams.add(new JavaVariable("long", "rowID"));
            this.myClass.addMethod(Access.PUBLIC, "Cursor", "findCursorByRowID", findByRowIdParams, findCursorByRowIDContent).setStatic(!this.injectionSupport);
            String findObjectBySelectionContent = "Cursor cursor = findCursorBySelection(" + dbParam + "selection, null);\n";
            findObjectBySelectionContent = findObjectBySelectionContent + "if (cursor != null) {\n";
            findObjectBySelectionContent = findObjectBySelectionContent + TAB + recordClassName + " record = new " + recordClassName + "();\n";
            findObjectBySelectionContent = findObjectBySelectionContent + TAB + "record.setContent(cursor);\n";
            findObjectBySelectionContent = findObjectBySelectionContent + TAB + "cursor.close();\n";
            findObjectBySelectionContent = findObjectBySelectionContent + TAB + "return record;\n";
            findObjectBySelectionContent = findObjectBySelectionContent + "} else {\n";
            findObjectBySelectionContent = findObjectBySelectionContent + TAB + "return null;\n";
            findObjectBySelectionContent = findObjectBySelectionContent + "}\n";
            ArrayList<JavaVariable> findParams2 = new ArrayList<JavaVariable>();
            if (!this.injectionSupport) {
                findParams2.add(new JavaVariable("SQLiteDatabase", "db"));
            }
            findParams2.add(new JavaVariable("String", "selection"));
            findParams2.add(new JavaVariable("String", "orderBy"));
            this.myClass.addMethod(Access.PUBLIC, recordClassName, "findBySelection", findParams2, findObjectBySelectionContent).setStatic(!this.injectionSupport);
            ArrayList<JavaVariable> findBySelectionParams = new ArrayList<JavaVariable>();
            if (!this.injectionSupport) {
                findBySelectionParams.add(new JavaVariable("SQLiteDatabase", "db"));
            }
            findBySelectionParams.add(new JavaVariable("String", "selection"));
            this.myClass.addMethod(Access.PUBLIC, recordClassName, "findBySelection", findBySelectionParams, "return findBySelection(selection, null);").setStatic(!this.injectionSupport);
            this.myClass.addImport("java.util.List");
            this.myClass.addImport("java.util.ArrayList");
            String findAllObjectBySelectionContent = "Cursor cursor = findCursorBySelection(" + dbParam + "selection, orderBy);\n";
            findAllObjectBySelectionContent = findAllObjectBySelectionContent + "List<" + recordClassName + "> foundItems = new ArrayList<" + recordClassName + ">();\n";
            findAllObjectBySelectionContent = findAllObjectBySelectionContent + "if (cursor != null) {\n";
            findAllObjectBySelectionContent = findAllObjectBySelectionContent + TAB + "while (cursor.moveToNext()) {\n";
            findAllObjectBySelectionContent = findAllObjectBySelectionContent + TAB + TAB + recordClassName + " record = new " + recordClassName + "();\n";
            findAllObjectBySelectionContent = findAllObjectBySelectionContent + TAB + TAB + "record.setContent(cursor);\n";
            findAllObjectBySelectionContent = findAllObjectBySelectionContent + TAB + TAB + "foundItems.add(record);\n";
            findAllObjectBySelectionContent = findAllObjectBySelectionContent + TAB + "}\n";
            findAllObjectBySelectionContent = findAllObjectBySelectionContent + TAB + "cursor.close();\n";
            findAllObjectBySelectionContent = findAllObjectBySelectionContent + "}\n";
            findAllObjectBySelectionContent = findAllObjectBySelectionContent + "return foundItems;\n";
            ArrayList<JavaVariable> findAllParams = new ArrayList<JavaVariable>();
            if (!this.injectionSupport) {
                findAllParams.add(new JavaVariable("SQLiteDatabase", "db"));
            }
            findAllParams.add(new JavaVariable("String", "selection"));
            findAllParams.add(new JavaVariable("String", "orderBy"));
            this.myClass.addMethod(Access.PUBLIC, "List<" + recordClassName + ">", "findAllBySelection", findAllParams, findAllObjectBySelectionContent).setStatic(!this.injectionSupport);
            ArrayList<JavaVariable> findAllNoOrderByParams = new ArrayList<JavaVariable>();
            if (!this.injectionSupport) {
                findAllNoOrderByParams.add(new JavaVariable("SQLiteDatabase", "db"));
            }
            findAllNoOrderByParams.add(new JavaVariable("String", "selection"));
            this.myClass.addMethod(Access.PUBLIC, "List<" + recordClassName + ">", "findAllBySelection", findAllNoOrderByParams, "return findAllBySelection(" + dbParam + "selection, null);").setStatic(!this.injectionSupport);
            String findObjectByRowIDContent = "return findBySelection(" + dbParam + selectionByRowID + ", null);\n";
            ArrayList<JavaVariable> findParams3 = new ArrayList<JavaVariable>();
            if (!this.injectionSupport) {
                findParams3.add(new JavaVariable("SQLiteDatabase", "db"));
            }
            findParams3.add(new JavaVariable("long", "rowID"));
            this.myClass.addMethod(Access.PUBLIC, recordClassName, "findByRowID", findParams3, findObjectByRowIDContent).setStatic(!this.injectionSupport);
            String findCountContent = "long count = -1;\n\n";
            findCountContent = findCountContent + "Cursor c = " + dbVar + ".query(" + recordClassName + ".TABLE, new String[]{\"count(1)\"}, null, null, null, null, null);\n";
            findCountContent = findCountContent + "if (c != null) {\n";
            findCountContent = findCountContent + TAB + "if (c.getCount() > 0) {\n";
            findCountContent = findCountContent + TAB + TAB + "c.moveToFirst();\n";
            findCountContent = findCountContent + TAB + TAB + "count = c.getLong(0);\n";
            findCountContent = findCountContent + TAB + TAB + "}\n";
            findCountContent = findCountContent + TAB + "c.close();\n";
            findCountContent = findCountContent + "}\n";
            findCountContent = findCountContent + "return count;";
            ArrayList<JavaVariable> findCountParams2 = new ArrayList<JavaVariable>();
            if (!this.injectionSupport) {
                findCountParams2.add(new JavaVariable("SQLiteDatabase", "db"));
            }
            this.myClass.addMethod(Access.PUBLIC, "long", "findCount", findCountParams2, findCountContent);
        }
    }

    public static String getClassName(SchemaTable table) {
        String recordClassName = AndroidRecordClassRenderer.createClassName(table);
        return recordClassName + "BaseManager";
    }

    public void writeToFile(String outDir) {
        this.myClass.writeToDisk(outDir);
    }
}

