/*
 * Decompiled with CFR 0.152.
 */
package org.dbtools.gen.android;

import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.dbtools.gen.DBObjectBuilder;
import org.dbtools.gen.GroupObjectBuilder;
import org.dbtools.gen.android.AndroidBaseRecordClassRenderer;
import org.dbtools.gen.android.AndroidBaseRecordManager;
import org.dbtools.gen.android.AndroidRecordClassRenderer;
import org.dbtools.gen.android.AndroidRecordManager;
import org.dbtools.schema.SchemaDatabase;
import org.dbtools.schema.SchemaTable;

public class AndroidDBObjectBuilder
implements DBObjectBuilder {
    private AndroidBaseRecordClassRenderer baseRecordClass = new AndroidBaseRecordClassRenderer();
    private AndroidRecordClassRenderer recordClass = new AndroidRecordClassRenderer();
    private AndroidBaseRecordManager baseManagerClass;
    private AndroidRecordManager managerClass;
    private int filesGeneratedCount = 0;
    private List<String> filesGenerated = new ArrayList<String>();
    private SchemaDatabase database;
    private SchemaTable table;
    private String packageName;
    private String outDir;
    private String testOutDir;
    private PrintStream psLog;
    private String author;
    private String version;
    private boolean injectionSupport;

    public AndroidDBObjectBuilder() {
        this(false);
    }

    public AndroidDBObjectBuilder(boolean injectionSupport) {
        this.injectionSupport = injectionSupport;
        this.baseManagerClass = new AndroidBaseRecordManager(injectionSupport);
        this.managerClass = new AndroidRecordManager(injectionSupport);
    }

    public static void buildAll(String schemaFilename, String baseOutputDir, String basePackageName, boolean injectionSupport, boolean dateTimeSupport) {
        AndroidDBObjectBuilder androidBuilder = new AndroidDBObjectBuilder(injectionSupport);
        androidBuilder.setUseDateTime(dateTimeSupport);
        GroupObjectBuilder groupObjectBuilder = new GroupObjectBuilder();
        groupObjectBuilder.setXmlFilename(schemaFilename);
        groupObjectBuilder.setTables(null);
        groupObjectBuilder.setOutputBaseDir(baseOutputDir);
        groupObjectBuilder.setPackageBase(basePackageName);
        groupObjectBuilder.setObjectBuilder(androidBuilder);
        groupObjectBuilder.build();
        System.out.println("Generated [" + groupObjectBuilder.getObjectBuilder().getNumberFilesGenerated() + "] files.");
    }

    @Override
    public String getName() {
        return "Android Object Builder";
    }

    @Override
    public boolean build() {
        if (this.psLog == null) {
            this.psLog = System.out;
        }
        if (this.table == null) {
            this.psLog.println("ERROR: SchemaTable is null");
            return false;
        }
        this.psLog.println("SchemaTable: " + this.table.getName());
        char lastDirChar = this.outDir.charAt(this.outDir.length() - 1);
        if (lastDirChar != File.separatorChar) {
            this.outDir = this.outDir + File.separatorChar;
        }
        if (!this.table.isEnumerationTable()) {
            String managerFileName = this.outDir + AndroidRecordManager.getClassName(this.table) + ".java";
            File managerFile = new File(managerFileName);
            this.baseManagerClass.generateObjectCode(this.table, this.packageName, this.author, this.version, this.psLog);
            this.baseManagerClass.writeToFile(this.outDir);
            ++this.filesGeneratedCount;
            if (!managerFile.exists()) {
                this.managerClass.generateObjectCode(this.table, this.packageName, this.author, this.version, this.psLog);
                this.managerClass.writeToFile(this.outDir);
                ++this.filesGeneratedCount;
            }
        }
        String baseRecordFileName = this.outDir + AndroidRecordClassRenderer.createClassName(this.table) + ".java";
        String recordFileName = this.outDir + AndroidRecordClassRenderer.createClassName(this.table) + ".java";
        File baseRecordFile = new File(baseRecordFileName);
        File recordFile = new File(recordFileName);
        File recordTestFile = new File(recordFileName + "Test");
        this.baseRecordClass.generateObjectCode(this.database, this.table, this.packageName, this.psLog);
        this.baseRecordClass.writeToFile(this.outDir);
        if (this.testOutDir != null && this.testOutDir.length() > 0) {
            this.baseRecordClass.writeTestsToFile(this.testOutDir);
        }
        this.filesGenerated.add(baseRecordFile.getPath());
        ++this.filesGeneratedCount;
        if (!this.table.isEnumerationTable()) {
            if (!recordFile.exists()) {
                this.recordClass.generateObjectCode(this.database, this.table, this.packageName, this.author, this.version, this.psLog);
                this.recordClass.writeToFile(this.outDir);
                this.filesGenerated.add(recordFile.getPath());
                ++this.filesGeneratedCount;
            }
            if (this.testOutDir != null && this.testOutDir.length() > 0 && !recordTestFile.exists()) {
                this.recordClass.writeTestsToFile(this.testOutDir, this.table, this.packageName);
            }
        }
        return true;
    }

    @Override
    public int getNumberFilesGenerated() {
        return this.filesGeneratedCount;
    }

    @Override
    public List<String> getFilesGenerated() {
        return Collections.unmodifiableList(this.filesGenerated);
    }

    @Override
    public void setIncludeXMLSupport(boolean b) {
        this.baseRecordClass.setIncludeXML(b);
    }

    @Override
    public void setUseDateTime(boolean b) {
        this.baseRecordClass.setUseDateTime(b);
    }

    @Override
    public void setTable(SchemaTable table) {
        this.table = table;
    }

    @Override
    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    @Override
    public void setSourceOutputDir(String outDir) {
        this.outDir = outDir;
    }

    @Override
    public void setTestOutputDir(String outDir) {
        this.testOutDir = outDir;
    }

    @Override
    public void setLogPrintStream(PrintStream psLog) {
        this.psLog = psLog;
    }

    @Override
    public void setAuthor(String author) {
        this.author = author;
    }

    @Override
    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public void setDatabase(SchemaDatabase dbSchema) {
        this.database = dbSchema;
    }

    @Override
    public void setProperty(String key, Object value) {
    }

    @Override
    public void setSpringSupport(boolean b) {
    }
}

