/*
 * Decompiled with CFR 0.152.
 */
package org.dbtools.gen.android;

import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.dbtools.codegen.Access;
import org.dbtools.codegen.JavaClass;
import org.dbtools.codegen.JavaMethod;
import org.dbtools.codegen.JavaVariable;
import org.dbtools.gen.android.AndroidBaseRecordClassRenderer;
import org.dbtools.schema.SchemaDatabase;
import org.dbtools.schema.SchemaTable;

public class AndroidRecordClassRenderer {
    private JavaClass myClass;
    private JavaClass myTestClass;

    public void generateObjectCode(SchemaDatabase database, SchemaTable table, String packageName, String author, String version, PrintStream psLog) {
        if (psLog == null) {
            psLog = System.out;
        }
        String baseClassName = AndroidBaseRecordClassRenderer.createClassName(table);
        String className = AndroidRecordClassRenderer.createClassName(table);
        this.myClass = new JavaClass(packageName, className);
        this.myClass.setExtends(baseClassName);
        Date now = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss");
        String fileHeaderComment = "/*\n";
        fileHeaderComment = fileHeaderComment + " * " + className + ".java\n";
        fileHeaderComment = fileHeaderComment + " *\n";
        fileHeaderComment = fileHeaderComment + " * Created: " + dateFormat.format(now) + "\n";
        fileHeaderComment = fileHeaderComment + " */\n";
        this.myClass.setFileHeaderComment(fileHeaderComment);
        if (!this.myClass.isEnum()) {
            this.myClass.addImport("android.database.Cursor");
            this.myClass.addImport("android.content.ContentValues");
            ArrayList<JavaVariable> constructorVarsCursor = new ArrayList<JavaVariable>();
            constructorVarsCursor.add(new JavaVariable("Cursor", "cursor"));
            this.myClass.addConstructor(Access.PUBLIC, constructorVarsCursor, "setContent(cursor);");
            ArrayList<JavaVariable> constructorVarsValues = new ArrayList<JavaVariable>();
            constructorVarsValues.add(new JavaVariable("ContentValues", "values"));
            this.myClass.addConstructor(Access.PUBLIC, constructorVarsValues, "setContent(values);");
        }
    }

    private void initTestClass(String className) {
        this.myTestClass.addImport("org.junit.*");
        this.myTestClass.addImport("static org.junit.Assert.*");
        this.myTestClass.setCreateDefaultConstructor(true);
        this.myTestClass.addVariable(className, "testRecord");
        JavaMethod setUpMethod = this.myTestClass.addMethod(Access.PUBLIC, "void", "setUp", "testRecord = new " + className + "();\nassertNotNull(testRecord);");
        setUpMethod.addAnnotation("Before");
        JavaMethod tearDownMethod = this.myTestClass.addMethod(Access.PUBLIC, "void", "tearDown", null);
        tearDownMethod.addAnnotation("After");
        JavaMethod emptyTestMethod = this.myTestClass.addMethod(Access.PUBLIC, "void", "emptyTest", "");
        emptyTestMethod.addAnnotation("Test");
    }

    public static String createClassName(SchemaTable table) {
        return table.getClassName();
    }

    public String getFilename() {
        return this.myClass.getFilename();
    }

    public void writeToFile(String directoryname) {
        this.myClass.writeToDisk(directoryname);
    }

    public void writeTestsToFile(String directoryname, SchemaTable table, String packageName) {
        String className = AndroidRecordClassRenderer.createClassName(table);
        this.myTestClass = new JavaClass(packageName, className + "Test");
        this.initTestClass(className);
        this.myTestClass.writeToDisk(directoryname);
    }
}

