/*
 * Decompiled with CFR 0.152.
 */
package org.dbtools.gen.android;

import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.dbtools.codegen.Access;
import org.dbtools.codegen.JavaClass;
import org.dbtools.codegen.JavaVariable;
import org.dbtools.gen.android.AndroidBaseRecordManager;
import org.dbtools.gen.android.AndroidRecordClassRenderer;
import org.dbtools.schema.SchemaTable;

public class AndroidRecordManager {
    private JavaClass myClass;
    private boolean injectionSupport = false;

    public AndroidRecordManager(boolean injectionSupport) {
        this.injectionSupport = injectionSupport;
    }

    public void generateObjectCode(SchemaTable table, String packageName, String author, String version, PrintStream psLog) {
        String className = AndroidRecordManager.getClassName(table);
        this.myClass = new JavaClass(packageName, className);
        this.myClass.setExtends(AndroidBaseRecordManager.getClassName(table));
        Date now = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss");
        String fileHeaderComment = "/*\n";
        fileHeaderComment = fileHeaderComment + " * " + className + ".java\n";
        fileHeaderComment = fileHeaderComment + " *\n";
        fileHeaderComment = fileHeaderComment + " * Generated on: " + dateFormat.format(now) + "\n";
        fileHeaderComment = fileHeaderComment + " *\n";
        fileHeaderComment = fileHeaderComment + " */\n";
        this.myClass.setFileHeaderComment(fileHeaderComment);
        if (this.injectionSupport) {
            this.myClass.addAnnotation("javax.inject.Singleton");
        }
        this.myClass.setCreateDefaultConstructor(false);
        ArrayList<JavaVariable> constParams = new ArrayList<JavaVariable>();
        String constContent = "";
        this.myClass.addConstructor(Access.PUBLIC, constParams, constContent);
    }

    public static String getClassName(SchemaTable table) {
        String recordClassName = AndroidRecordClassRenderer.createClassName(table);
        return recordClassName + "Manager";
    }

    public void writeToFile(String outDir) {
        this.myClass.writeToDisk(outDir);
    }
}

