/*
 * Decompiled with CFR 0.152.
 */
package org.dbtools.gen.jpa;

import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.dbtools.codegen.Access;
import org.dbtools.codegen.DataType;
import org.dbtools.codegen.JavaClass;
import org.dbtools.codegen.JavaEnum;
import org.dbtools.codegen.JavaMethod;
import org.dbtools.codegen.JavaVariable;
import org.dbtools.gen.jpa.JPARecordClassRenderer;
import org.dbtools.schema.ClassInfo;
import org.dbtools.schema.SchemaDatabase;
import org.dbtools.schema.SchemaField;
import org.dbtools.schema.SchemaTable;

public class JPABaseRecordClassRenderer {
    private static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private JavaClass myClass;
    private JavaClass myTestClass;
    private boolean writeTestClass = true;
    private List<JavaEnum> enumerationClasses = new ArrayList<JavaEnum>();
    private StringBuilder toStringContent;
    private StringBuilder cleanupOrphansContent;
    private boolean includeXML = false;
    private boolean useDateTime = false;
    private boolean useInnerEnums = true;
    public static final String CLEANUP_ORPHANS_METHODNAME = "cleanupOrphans";
    boolean uselegacyJUnit = false;
    boolean useBeanValidators = false;

    public void generateObjectCode(SchemaDatabase schemaDatabase, SchemaTable table, String packageName, String author, String version, PrintStream psLog) {
        String className = JPABaseRecordClassRenderer.createClassName(table);
        if (table.isEnumerationTable()) {
            String enumClassname = JPABaseRecordClassRenderer.createClassName(table);
            this.myClass = new JavaEnum(packageName, enumClassname, table.getEnumerations());
            this.myClass.setCreateDefaultConstructor(false);
            this.writeTestClass = false;
            if (table.getEnumValues().size() > 0) {
                this.myClass.addImport("java.util.Map");
                this.myClass.addImport("java.util.HashMap");
                JavaVariable enumStringMapVar = this.myClass.addVariable("Map<" + enumClassname + ", String>", "enumStringMap", "new HashMap<" + enumClassname + ", String>()");
                enumStringMapVar.setStatic(true);
                this.myClass.addImport("java.util.List");
                this.myClass.addImport("java.util.ArrayList");
                JavaVariable stringListVar = this.myClass.addVariable("List<String>", "stringList", "new ArrayList<String>()");
                stringListVar.setStatic(true);
                Map<String, String> enumValues = table.getEnumValues();
                for (String enumItem : table.getEnumerations()) {
                    String enumValue = enumValues.get(enumItem);
                    this.myClass.appendStaticInitializer("enumStringMap.put(" + enumItem + ", \"" + enumValue + "\");");
                    this.myClass.appendStaticInitializer("stringList.add(\"" + enumValue + "\");");
                    this.myClass.appendStaticInitializer("");
                }
                ArrayList<JavaVariable> getStringMParam = new ArrayList<JavaVariable>();
                getStringMParam.add(new JavaVariable(enumClassname, "key"));
                JavaMethod getStringM = this.myClass.addMethod(Access.PUBLIC, "String", "getString", getStringMParam, "return enumStringMap.get(key);");
                getStringM.setStatic(true);
                JavaMethod getListM = this.myClass.addMethod(Access.PUBLIC, "List<String>", "getList", "return stringList;");
                getListM.setStatic(true);
            }
        } else {
            this.myClass = new JavaClass(packageName, className);
            this.writeTestClass = true;
        }
        this.myTestClass = new JavaClass(packageName, className + "Test");
        this.initTestClass();
        this.toStringContent = new StringBuilder();
        this.toStringContent.append("String text = \"\\n\";\n");
        this.cleanupOrphansContent = new StringBuilder();
        String fileHeaderComment = "/*\n";
        fileHeaderComment = fileHeaderComment + " * " + className + ".java\n";
        fileHeaderComment = fileHeaderComment + " *\n";
        fileHeaderComment = fileHeaderComment + " * GENERATED FILE - DO NOT EDIT\n";
        fileHeaderComment = fileHeaderComment + " * CHECKSTYLE:OFF\n";
        fileHeaderComment = fileHeaderComment + " * \n";
        fileHeaderComment = fileHeaderComment + " */\n";
        this.myClass.setFileHeaderComment(fileHeaderComment);
        this.myClass.addAnnotation("@SuppressWarnings(\"all\")");
        if (!this.myClass.isEnum()) {
            this.myClass.addImplements("java.io.Serializable");
            this.myClass.addAnnotation("@javax.persistence.MappedSuperclass()");
        }
        String TAB = JavaClass.getTab();
        StringBuilder constructorElement = new StringBuilder();
        constructorElement.append("try {\n");
        StringBuilder methodToXML = new StringBuilder();
        StringBuilder methodToXMLExt = new StringBuilder();
        methodToXML.append("Element element = parent.addElement(TABLE);\n");
        StringBuffer dtd = new StringBuffer();
        dtd.append("<!ELEMENT ").append(table.getClassName()).append(" EMPTY>\n        <!ATTLIST ").append(table.getClassName()).append("\n");
        boolean primaryKeyAdded = false;
        if (this.includeXML && !this.myClass.isEnum()) {
            this.myClass.addImport("org.dom4j.*");
        }
        String tableName = table.getName();
        this.myClass.addConstant("String", "TABLE", tableName);
        this.myClass.addConstant("String", "TABLE_CLASSNAME", JPARecordClassRenderer.createClassName(table));
        List<SchemaField> fields = table.getFields();
        block6: for (SchemaField field : fields) {
            boolean primaryKey = field.isPrimaryKey();
            String fieldNameJavaStyle = field.getName(true);
            if (primaryKey && primaryKeyAdded) {
                throw new IllegalStateException("Cannot have more than 1 Primary Key [" + fieldNameJavaStyle + "]");
            }
            primaryKeyAdded = true;
            String constName = JavaClass.formatConstant(fieldNameJavaStyle);
            this.myClass.addConstant("String", "C_" + constName, field.getName());
            this.myClass.addConstant("String", "FULL_C_" + constName, tableName + "." + field.getName());
            String propertyName = "P_" + constName;
            switch (field.getForeignKeyType()) {
                case MANYTOONE: {
                    this.generateManyToOne(schemaDatabase, packageName, field, table);
                    continue block6;
                }
                case ONETOMANY: {
                    this.generateOneToMany(table, field, packageName, schemaDatabase);
                    continue block6;
                }
                case ONETOONE: {
                    this.generateOneToOne(schemaDatabase, table, field, packageName);
                    continue block6;
                }
            }
            this.myClass.addConstant("String", propertyName, fieldNameJavaStyle);
            this.createToStringMethodContent(field, fieldNameJavaStyle);
            JavaVariable newVariable = null;
            newVariable = field.isEnumeration() ? this.generateEnumeration(field, fieldNameJavaStyle, packageName, newVariable, schemaDatabase) : this.generateFieldVariable(fieldNameJavaStyle, field);
            if (primaryKey && !this.myClass.isEnum()) {
                this.addFieldVariableAnnotations(field, fieldNameJavaStyle, newVariable);
            }
            if (!this.myClass.isEnum()) {
                this.myClass.addImport("javax.persistence.Column");
                String columnAnnotation = "@Column(name=\"" + field.getName() + "\"";
                if (field.getJdbcType().equals("BLOB") || field.getJdbcType().equals("CLOB")) {
                    this.myClass.addImport("javax.persistence.Basic");
                    this.myClass.addImport("javax.persistence.FetchType");
                    newVariable.addAnnotation("Basic(fetch=FetchType.LAZY)");
                    this.myClass.addImport("javax.persistence.Lob");
                    newVariable.addAnnotation("Lob");
                }
                if (field.getSize() > 0) {
                    columnAnnotation = columnAnnotation + ", length=" + field.getSize();
                }
                if (field.getDecimals() > 0) {
                    columnAnnotation = columnAnnotation + ", precision=" + field.getDecimals();
                }
                if (field.isNotNull()) {
                    columnAnnotation = columnAnnotation + ", nullable=false";
                    if (this.useBeanValidators) {
                        this.myClass.addImport("org.hibernate.validator.NotNull");
                        newVariable.addAnnotation("NotNull");
                    }
                }
                if (field.isUnique()) {
                    columnAnnotation = columnAnnotation + ", unique=true";
                }
                columnAnnotation = columnAnnotation + ")";
                newVariable.addAnnotation(columnAnnotation);
                String temporalImport = "javax.persistence.Temporal";
                String temporalTypeImport = "javax.persistence.TemporalType";
                String temporalAnnotation = "@Temporal(value = TemporalType.{0})";
                if (!this.useDateTime && field.getJdbcType().equals("TIMESTAMP")) {
                    this.myClass.addImport(temporalImport);
                    this.myClass.addImport(temporalTypeImport);
                    newVariable.addAnnotation(MessageFormat.format(temporalAnnotation, "TIMESTAMP"));
                } else if (!this.useDateTime && field.getJdbcType().equals("DATE")) {
                    this.myClass.addImport(temporalImport);
                    this.myClass.addImport(temporalTypeImport);
                    newVariable.addAnnotation(MessageFormat.format(temporalAnnotation, "DATE"));
                } else if (!this.useDateTime && field.getJdbcType().equals("TIMESTAMP")) {
                    this.myClass.addImport(temporalImport);
                    this.myClass.addImport(temporalTypeImport);
                    newVariable.addAnnotation(MessageFormat.format(temporalAnnotation, "TIMESTAMP"));
                }
                if (this.useDateTime && newVariable.getDataType().endsWith("DateTime")) {
                    this.myClass.addImport("org.hibernate.annotations.Type");
                    this.myClass.addImport("org.springframework.format.annotation.DateTimeFormat");
                    newVariable.addAnnotation("@Type(type=\"org.jadira.usertype.dateandtime.joda.PersistentDateTime\")");
                    newVariable.addAnnotation("@DateTimeFormat(style=\"SS\")");
                }
            }
            if (!this.myClass.isEnum()) {
                this.myClass.addVariable(newVariable);
            }
            if (!this.includeXML || this.myClass.isEnum()) continue;
            this.generateXMLCode(schemaDatabase, constructorElement, methodToXML, dtd, TAB, field, constName);
        }
        if (this.includeXML && !this.myClass.isEnum()) {
            constructorElement.append("} catch (Exception e) {\n");
            constructorElement.append(TAB).append("e.printStackTrace();\n");
            constructorElement.append("}\n");
        }
        this.addForgeignKeyData(schemaDatabase, table, packageName);
        if (!this.myClass.isEnum()) {
            ArrayList<JavaVariable> orphanParams = new ArrayList<JavaVariable>();
            orphanParams.add(new JavaVariable("javax.persistence.EntityManager", "em"));
            this.myClass.addMethod(Access.PROTECTED, "void", CLEANUP_ORPHANS_METHODNAME, orphanParams, this.cleanupOrphansContent.toString());
        }
        if (!this.myClass.isEnum()) {
            this.toStringContent.append("return text;\n");
            JavaMethod toStringMethod = this.myClass.addMethod(Access.PUBLIC, "String", "toString", this.toStringContent.toString());
            toStringMethod.addAnnotation("Override");
            this.myClass.addMethod(Access.PUBLIC, "boolean", "isNewRecord", "return getID() <= 0;");
            JavaMethod toStringTestMethod = this.myTestClass.addMethod(Access.PUBLIC, "void", "testToString", "assertNotNull(testRecord.toString());");
            toStringTestMethod.addAnnotation("Test");
        }
        if (this.includeXML && !this.myClass.isEnum()) {
            ArrayList<JavaVariable> xmlConstParams = new ArrayList<JavaVariable>();
            xmlConstParams.add(new JavaVariable("Element", "element"));
            this.myClass.addConstructor(Access.PUBLIC, xmlConstParams, constructorElement.toString());
            String toXMLContent = methodToXML.toString() + "\n// Many to One support (if any)\n" + methodToXMLExt.toString() + "\nreturn element;";
            ArrayList<JavaVariable> xmlToStrParams = new ArrayList<JavaVariable>();
            xmlToStrParams.add(new JavaVariable("Element", "parent"));
            this.myClass.addMethod(Access.PUBLIC, "Element", "toXML", xmlToStrParams, toXMLContent);
        }
    }

    private void addFieldVariableAnnotations(SchemaField field, String fieldNameJavaStyle, JavaVariable newVariable) {
        boolean hasSequencer;
        this.myClass.addImport("javax.persistence.Id");
        newVariable.addAnnotation("@Id");
        String sequencerName = field.getSequencerName();
        boolean bl = hasSequencer = sequencerName != null && sequencerName.length() > 0;
        if (field.isIncrement() && !hasSequencer) {
            this.myClass.addImport("javax.persistence.GeneratedValue");
            this.myClass.addImport("javax.persistence.GenerationType");
            newVariable.addAnnotation("@GeneratedValue(strategy=GenerationType.AUTO)");
        } else if (hasSequencer) {
            this.myClass.addImport("javax.persistence.GeneratedValue");
            this.myClass.addImport("javax.persistence.SequenceGenerator");
            newVariable.addAnnotation("@GeneratedValue(generator=\"" + sequencerName + "\")");
            newVariable.addAnnotation("@SequenceGenerator(name=\"" + sequencerName + "\", sequenceName=\"" + sequencerName + "\", allocationSize=1)");
        }
        this.myClass.addMethod(Access.PUBLIC, field.getJavaTypeText(), "getID", "return " + fieldNameJavaStyle + ";");
    }

    private void createToStringMethodContent(SchemaField field, String fieldNameJavaStyle) {
        String fieldType = field.getJdbcType();
        if (!fieldType.equals("BLOB") && !fieldType.equals("CLOB")) {
            this.toStringContent.append("text += \"").append(fieldNameJavaStyle).append(" = \"+ ").append(fieldNameJavaStyle).append(" +\"\\n\";\n");
        }
    }

    private JavaVariable generateEnumeration(SchemaField field, String fieldNameJavaStyle, String packageName, JavaVariable newVariable, SchemaDatabase dbSchema) {
        this.myClass.addImport("javax.persistence.Enumerated");
        this.myClass.addImport("javax.persistence.EnumType");
        if (field.isNumberDataType()) {
            if (field.getForeignKeyTable().length() > 0) {
                ClassInfo enumClassInfo = dbSchema.getTableClassInfo(field.getForeignKeyTable());
                String enumName = enumClassInfo.getClassName();
                List<String> localEnumerations = field.getEnumerations();
                if (localEnumerations != null && localEnumerations.size() > 0) {
                    this.myClass.addEnum(enumName, field.getEnumerations());
                } else {
                    String enumPackage = enumClassInfo.getPackageName(packageName) + "." + enumName;
                    this.myClass.addImport(enumPackage);
                }
                newVariable = new JavaVariable(enumName, fieldNameJavaStyle);
                newVariable.setGenerateSetterGetter(true);
                newVariable.setDefaultValue(enumName + "." + field.getEnumerationDefault(), false);
                this.addSetterGetterTest(newVariable);
                newVariable.addAnnotation("Enumerated(EnumType.ORDINAL)");
            } else {
                String javaStyleFieldName = field.getName(true);
                String firstChar = javaStyleFieldName.substring(0, 1).toUpperCase();
                String enumName = firstChar + javaStyleFieldName.substring(1);
                if (this.useInnerEnums) {
                    this.myClass.addEnum(enumName, field.getEnumerations());
                } else {
                    this.enumerationClasses.add(new JavaEnum(enumName, field.getEnumerations()));
                }
                newVariable = new JavaVariable(enumName, fieldNameJavaStyle);
                newVariable.setGenerateSetterGetter(true);
                newVariable.setDefaultValue(enumName + "." + field.getEnumerationDefault(), false);
                this.addSetterGetterTest(newVariable);
                newVariable.addAnnotation("Enumerated(EnumType.ORDINAL)");
            }
        } else {
            newVariable = new JavaVariable(field.getJavaTypeText(), fieldNameJavaStyle);
        }
        return newVariable;
    }

    private JavaVariable generateFieldVariable(String fieldNameJavaStyle, SchemaField field) {
        boolean immutableDate;
        String typeText = field.getJavaTypeText();
        String defaultValue = field.getFormattedClassDefaultValue();
        boolean dateType = typeText.endsWith("Date");
        JavaVariable newVariable = dateType && this.useDateTime ? new JavaVariable("org.joda.time.DateTime", fieldNameJavaStyle) : new JavaVariable(typeText, fieldNameJavaStyle);
        boolean bl = immutableDate = field.getJavaClassType() == Date.class && this.useDateTime;
        if (!(field.isJavaTypePrimative() || field.isJavaTypeImmutable() || immutableDate)) {
            newVariable.setCloneSetterGetterVar(true);
        }
        newVariable.setGenerateSetterGetter(true);
        this.addSetterGetterTest(newVariable);
        newVariable.setDefaultValue(defaultValue);
        return newVariable;
    }

    private void generateManyToOne(SchemaDatabase schemaDatabase, String packageName, SchemaField field, SchemaTable table) {
        String fkTableName = field.getForeignKeyTable();
        ClassInfo fkTableClassInfo = schemaDatabase.getTableClassInfo(fkTableName);
        String fkTableClassName = fkTableClassInfo.getClassName();
        String varName = field.getCustomVarName();
        if (varName.equals("")) {
            varName = JavaClass.formatToJavaVariable(fkTableClassName);
        }
        this.myClass.addConstant("String", "P_" + JavaClass.formatConstant(varName), varName);
        String newImport = fkTableClassInfo.getPackageName(packageName) + ".*";
        this.myClass.addImport(newImport);
        JavaVariable manyToOneVar = new JavaVariable(fkTableClassName, varName);
        this.myClass.addImport("javax.persistence.ManyToOne");
        this.myClass.addImport("javax.persistence.FetchType");
        manyToOneVar.addAnnotation("@ManyToOne(fetch=FetchType." + field.getForeignKeyFetchType() + ")");
        this.myClass.addImport("javax.persistence.JoinColumn");
        if (field.isNotNull()) {
            manyToOneVar.addAnnotation("@JoinColumn(name=\"" + field.getName() + "\", nullable=false)");
        } else {
            manyToOneVar.addAnnotation("@JoinColumn(name=\"" + field.getName() + "\")");
        }
        this.myClass.addVariable(manyToOneVar, true);
    }

    private void generateOneToMany(SchemaTable table, SchemaField field, String packageName, SchemaDatabase dbSchema) {
        String fkTableName = field.getForeignKeyTable();
        ClassInfo fkTableClassInfo = dbSchema.getTableClassInfo(fkTableName);
        String fkTableClassName = fkTableClassInfo.getClassName();
        String varName = field.getCustomVarName();
        if (varName.equals("")) {
            varName = JavaClass.formatToJavaVariable(fkTableClassName);
        }
        this.myClass.addConstant("String", "P_" + JavaClass.formatConstant(varName), varName);
        String newImport = fkTableClassInfo.getPackageName(packageName) + ".*";
        this.myClass.addImport(newImport);
        JavaVariable manyToOneVar = new JavaVariable(fkTableClassName, varName);
        this.myClass.addImport("javax.persistence.ManyToOne");
        this.myClass.addImport("javax.persistence.FetchType");
        manyToOneVar.addAnnotation("@ManyToOne(fetch=FetchType." + field.getForeignKeyFetchType() + ")");
        this.myClass.addImport("javax.persistence.JoinColumn");
        if (field.isNotNull()) {
            manyToOneVar.addAnnotation("@JoinColumn(name=\"" + field.getName() + "\", nullable=false)");
        } else {
            manyToOneVar.addAnnotation("@JoinColumn(name=\"" + field.getName() + "\")");
        }
        this.myClass.addVariable(manyToOneVar, true);
    }

    private void generateOneToOne(SchemaDatabase dbSchema, SchemaTable table, SchemaField field, String packageName) {
        String fkTableName = field.getForeignKeyTable();
        ClassInfo fkTableClassInfo = dbSchema.getTableClassInfo(fkTableName);
        String fkTableClassName = fkTableClassInfo.getClassName();
        String varName = field.getCustomVarName();
        if (varName.equals("")) {
            varName = JavaClass.formatToJavaVariable(fkTableClassName);
        }
        this.myClass.addConstant("String", "P_" + JavaClass.formatConstant(varName), varName);
        String newImport = fkTableClassInfo.getPackageName(packageName) + ".*";
        this.myClass.addImport(newImport);
        JavaVariable oneToOneVar = new JavaVariable(fkTableClassName, varName);
        this.myClass.addImport("javax.persistence.OneToOne");
        this.myClass.addImport("javax.persistence.FetchType");
        String cascadeType = field.getForeignKeyCascadeType();
        String cascadeTypeAnnotation = "";
        if (cascadeType != null && cascadeType.length() > 0) {
            this.myClass.addImport("javax.persistence.CascadeType");
            cascadeTypeAnnotation = "cascade=CascadeType." + cascadeType + ", ";
        }
        oneToOneVar.addAnnotation("@OneToOne(" + cascadeTypeAnnotation + "fetch=FetchType." + field.getForeignKeyFetchType() + ")");
        this.myClass.addImport("javax.persistence.JoinColumn");
        if (field.isNotNull()) {
            oneToOneVar.addAnnotation("@JoinColumn(name=\"" + field.getName() + "\", nullable=false)");
        } else {
            oneToOneVar.addAnnotation("@JoinColumn(name=\"" + field.getName() + "\")");
        }
        this.myClass.addVariable(oneToOneVar, true);
    }

    private void generateXMLCode(SchemaDatabase dbSchema, StringBuilder constructorElement, StringBuilder methodToXML, StringBuffer dtd, String TAB, SchemaField field, String constName) {
        String elementGetter;
        String fieldNameJavaStyle = field.getName(true);
        String attributeName = "C_" + constName;
        String elementPreGetter = "";
        Class<?> fClass = field.getJavaClassType();
        if (!field.isEnumeration()) {
            if (fClass == String.class) {
                elementGetter = "element.attributeValue(" + attributeName + ", \"\")";
            } else if (fClass == Integer.TYPE || fClass == Integer.class) {
                elementGetter = "Integer.parseInt(element.attributeValue(" + attributeName + ", \"0\"))";
            } else if (fClass == Float.TYPE || fClass == Float.class) {
                elementGetter = "Float.parseFloat(element.attributeValue(" + attributeName + ", \"0.0\"))";
            } else if (fClass == Boolean.TYPE || fClass == Boolean.class) {
                elementGetter = "Boolean.parseBoolean(element.attributeValue(" + attributeName + ", \"false\"))";
            } else if (fClass == Double.TYPE || fClass == Double.class) {
                elementGetter = "Double.parseDouble(element.attributeValue(" + attributeName + ", \"0.0\"))";
            } else if (fClass == Long.TYPE || fClass == Long.class) {
                elementGetter = "Long.parseLong(element.attributeValue(" + attributeName + ", \"0\"))";
            } else if (fClass == Date.class) {
                String tmpTextName = fieldNameJavaStyle + "Text";
                elementPreGetter = "String " + tmpTextName + " = element.attributeValue(" + attributeName + ");";
                elementGetter = tmpTextName + " != null ? (new java.text.SimpleDateFormat(\"" + DATE_FORMAT + "\")).parse(" + tmpTextName + ")" + " : null";
            } else {
                elementGetter = "element.attributeValue(" + attributeName + ", null)";
            }
        } else {
            ClassInfo myTableClassInfo = dbSchema.getTableClassInfo(field.getForeignKeyTable());
            String enumClassName = myTableClassInfo.getClassName();
            String tmpTextName = fieldNameJavaStyle + "Text";
            elementPreGetter = "String " + tmpTextName + " = element.attributeValue(" + attributeName + ");";
            elementGetter = tmpTextName + " != null ? " + enumClassName + ".valueOf(" + tmpTextName + ")" + " : " + enumClassName + "." + field.getEnumerationDefault() + "";
        }
        String xmlSetterMethodName = field.isCreatedTimeStampField() ? "setCreatedDate" : (field.isLastModifiedTimeStampField() ? "setLastModifiedDate" : JavaClass.createSetterMethodName(fieldNameJavaStyle));
        if (!elementPreGetter.isEmpty()) {
            constructorElement.append(TAB).append(elementPreGetter).append("\n");
        }
        constructorElement.append(TAB).append(xmlSetterMethodName).append("(").append(elementGetter).append(");\n");
        String getterMethodName = JavaClass.createGetterMethodName(fClass, fieldNameJavaStyle);
        if (!field.isEnumeration()) {
            if (fClass == Integer.TYPE || fClass == Float.TYPE || fClass == Double.TYPE || fClass == Long.TYPE) {
                String toStringSeg = "";
                toStringSeg = field.getJavaType().getMatchingNonPrimativeClassText() + ".toString(";
                methodToXML.append("element.addAttribute(").append("C_").append(constName).append(", ").append(toStringSeg).append(getterMethodName).append("()));\n");
            } else if (fClass == String.class) {
                methodToXML.append("element.addAttribute(").append("C_").append(constName).append(", ").append(getterMethodName).append("());\n");
            } else if (fClass.isPrimitive()) {
                methodToXML.append("element.addAttribute(").append("C_").append(constName).append(", new ").append(field.getJavaType().getMatchingNonPrimativeClassText()).append("(").append(getterMethodName).append("()).toString());\n");
            } else if (fClass == Date.class) {
                String dateGetterMethod = field.isCreatedTimeStampField() ? "getCreatedDate()" : (field.isLastModifiedTimeStampField() ? "getLastModifiedDate()" : getterMethodName + "()");
                methodToXML.append("if (").append(dateGetterMethod).append(" != null) {\n");
                methodToXML.append("    java.text.SimpleDateFormat xmlDF = new java.text.SimpleDateFormat(\"yyyy-MM-dd'T'HH:mm:ss.SSSZ\");\n");
                methodToXML.append("    element.addAttribute(").append("C_").append(constName).append(", xmlDF.format(").append(dateGetterMethod).append("));\n");
                methodToXML.append("}\n");
            } else {
                methodToXML.append("element.addAttribute(").append("C_").append(constName).append(", ").append(getterMethodName).append("().toString());\n");
            }
        } else {
            methodToXML.append("element.addAttribute(").append("C_").append(constName).append(", ").append(getterMethodName).append("().toString());\n");
        }
        String dtdType = " CDATA ";
        String dtdDefault = " \"\"";
        if (fClass == Integer.TYPE || fClass == Float.TYPE || fClass == Double.TYPE || fClass == Long.TYPE || fClass == Date.class) {
            dtdType = " NMTOKEN ";
            dtdDefault = " \"0\"";
        } else if (fClass == Boolean.TYPE) {
            dtdType = " (true | false) ";
            dtdDefault = " \"false\"";
        }
        dtd.append(TAB).append(fieldNameJavaStyle).append(dtdType).append(dtdDefault).append("\n");
    }

    private void addForgeignKeyData(SchemaDatabase dbSchema, SchemaTable table, String packageName) {
        String TAB = JavaClass.getTab();
        for (SchemaTable tmpTable : dbSchema.getTables()) {
            List<SchemaField> fkFields = tmpTable.getForeignKeyFields(table.getName());
            for (SchemaField fkField : fkFields) {
                switch (fkField.getForeignKeyType()) {
                    case ONETOMANY: {
                        String fkTableName = tmpTable.getName();
                        ClassInfo fkTableClassInfo = dbSchema.getTableClassInfo(fkTableName);
                        String fkTableClassName = fkTableClassInfo.getClassName();
                        String fkTableVarName = JavaClass.formatToJavaVariable(fkTableClassName);
                        String newImport = fkTableClassInfo.getPackageName(packageName) + ".*";
                        String items = fkTableVarName + "Items";
                        String itemsToDelete = fkTableVarName + "ItemsToDelete";
                        this.myClass.addImport(newImport);
                        this.myClass.addImport("javax.persistence.OneToMany");
                        this.myClass.addImport("java.util.Set");
                        this.myClass.addImport("java.util.HashSet");
                        String listType = "Set<" + fkTableClassName + ">";
                        String defaultListTypeValue = "new HashSet<" + fkTableClassName + ">()";
                        JavaVariable itemsList = this.myClass.addVariable(listType, items);
                        itemsList.setDefaultValue(defaultListTypeValue);
                        this.myClass.addMethod(Access.PUBLIC, listType, JavaVariable.getGetterMethodName(listType, items), "return java.util.Collections.unmodifiableSet(" + items + ");");
                        ClassInfo mappedByClassInfo = dbSchema.getTableClassInfo(fkField.getForeignKeyTable());
                        String mappedByVarName = JavaClass.formatToJavaVariable(mappedByClassInfo.getClassName());
                        this.myClass.addImport("javax.persistence.FetchType");
                        String cascadeType = fkField.getForeignKeyCascadeType();
                        String cascadeTypeAnnotation = "";
                        if (cascadeType != null && cascadeType.length() > 0) {
                            this.myClass.addImport("javax.persistence.CascadeType");
                            cascadeTypeAnnotation = "cascade=CascadeType." + cascadeType + ", ";
                        }
                        itemsList.addAnnotation("@OneToMany(mappedBy=\"" + mappedByVarName + "\", " + cascadeTypeAnnotation + "fetch=FetchType." + fkField.getForeignKeyFetchType() + ")");
                        String orderByColumn = fkField.getForeignKeyOrderByColumn();
                        if (orderByColumn != null && orderByColumn.length() > 0) {
                            this.myClass.addImport("javax.persistence.OrderBy");
                            itemsList.addAnnotation("@OrderBy(\"" + orderByColumn + "\")");
                        }
                        JavaMethod addMethod = new JavaMethod("add" + fkTableClassName);
                        addMethod.setAccess(Access.PUBLIC);
                        addMethod.addParameter(new JavaVariable(fkTableClassName, fkTableVarName));
                        String addMethodContent = "";
                        ClassInfo myTableClassInfo = dbSchema.getTableClassInfo(fkField.getForeignKeyTable());
                        String tableClassName = myTableClassInfo.getClassName();
                        String fieldName = fkField.getCustomVarName();
                        if (fieldName == null || fieldName.length() == 0) {
                            fieldName = tableClassName;
                        }
                        String setterMethodName = "set" + fieldName.toUpperCase().charAt(0) + fieldName.substring(1, fieldName.length());
                        addMethodContent = addMethodContent + fkTableVarName + "." + setterMethodName + "((" + tableClassName + ")this);\n";
                        addMethodContent = addMethodContent + items + ".add(" + fkTableVarName + ");\n";
                        addMethod.setContent(addMethodContent);
                        this.myClass.addMethod(addMethod);
                        this.myClass.addImport("javax.persistence.Transient");
                        JavaVariable itemsToDeleteList = this.myClass.addVariable(listType, itemsToDelete);
                        itemsToDeleteList.setDefaultValue(defaultListTypeValue);
                        itemsToDeleteList.addAnnotation("@Transient");
                        JavaMethod removeMethod = new JavaMethod("delete" + fkTableClassName);
                        removeMethod.setAccess(Access.PUBLIC);
                        removeMethod.addParameter(new JavaVariable(fkTableClassName, fkTableVarName));
                        String removeMethodContent = "";
                        removeMethodContent = removeMethodContent + "if (" + fkTableVarName + " == null) {\n";
                        removeMethodContent = removeMethodContent + TAB + "return;\n";
                        removeMethodContent = removeMethodContent + "}\n\n";
                        removeMethodContent = removeMethodContent + "java.util.Iterator<" + fkTableClassName + "> itr = " + items + ".iterator();\n";
                        removeMethodContent = removeMethodContent + "while (itr.hasNext()) {\n";
                        removeMethodContent = removeMethodContent + TAB + fkTableClassName + " item = itr.next();\n";
                        removeMethodContent = removeMethodContent + TAB + "if (item.equals(" + fkTableVarName + ")) {\n";
                        removeMethodContent = removeMethodContent + TAB + TAB + "itr.remove();\n";
                        removeMethodContent = removeMethodContent + TAB + TAB + itemsToDelete + ".add(item);\n";
                        removeMethodContent = removeMethodContent + TAB + TAB + "break;\n";
                        removeMethodContent = removeMethodContent + TAB + "}\n";
                        removeMethodContent = removeMethodContent + TAB + "if (!itr.hasNext()) {\n";
                        removeMethodContent = removeMethodContent + TAB + TAB + "throw new IllegalStateException(\"deleteItem failed: Cannot find itemID \"+ " + fkTableVarName + ".getID());\n";
                        removeMethodContent = removeMethodContent + TAB + "}\n";
                        removeMethodContent = removeMethodContent + "}";
                        removeMethod.setContent(removeMethodContent);
                        this.myClass.addMethod(removeMethod);
                        this.cleanupOrphansContent.append("for (").append(fkTableClassName).append(" itemToDelete : ").append(itemsToDelete).append(") {\n");
                        this.cleanupOrphansContent.append(TAB).append("try {\n");
                        this.cleanupOrphansContent.append(TAB).append(TAB).append("em.remove(itemToDelete);\n");
                        this.cleanupOrphansContent.append(TAB).append("} catch(RuntimeException e) {// do nothing... it is ok if it does not exist\n");
                        this.cleanupOrphansContent.append(TAB).append("}\n");
                        this.cleanupOrphansContent.append("}\n\n");
                        break;
                    }
                    case ONETOONE: {
                        break;
                    }
                }
            }
        }
    }

    public static String createClassName(SchemaTable table) {
        if (table.isEnumerationTable()) {
            return table.getClassName();
        }
        return table.getClassName() + "BaseRecord";
    }

    public void writeToFile(String directoryname) {
        this.myClass.writeToDisk(directoryname);
        for (JavaEnum enumClass : this.enumerationClasses) {
            enumClass.writeToDisk(directoryname);
        }
    }

    public void writeTestsToFile(String directoryname) {
        if (this.writeTestClass) {
            this.myTestClass.writeToDisk(directoryname);
        }
    }

    private void initTestClass() {
        if (this.uselegacyJUnit) {
            this.myTestClass.addImport("junit.framework.*");
            this.myTestClass.setExtends("TestCase");
        } else {
            this.myTestClass.addImport("org.junit.*");
            this.myTestClass.addImport("static org.junit.Assert.*");
        }
        String fileHeaderComment = "/*\n";
        fileHeaderComment = fileHeaderComment + " * " + this.myTestClass.getName() + ".java\n";
        fileHeaderComment = fileHeaderComment + " * \n";
        fileHeaderComment = fileHeaderComment + " * GENERATED FILE - DO NOT EDIT\n";
        fileHeaderComment = fileHeaderComment + " * \n";
        fileHeaderComment = fileHeaderComment + " */\n";
        this.myTestClass.setFileHeaderComment(fileHeaderComment);
        if (this.uselegacyJUnit) {
            ArrayList<JavaVariable> params = new ArrayList<JavaVariable>();
            params.add(new JavaVariable("String", "testName"));
            this.myTestClass.addConstructor(Access.PUBLIC, params, "super(testName);");
        } else {
            this.myTestClass.setCreateDefaultConstructor(true);
        }
        this.myTestClass.addVariable(this.myClass.getName(), "testRecord");
        JavaMethod setUpMethod = this.myTestClass.addMethod(Access.PUBLIC, "void", "setUp", "testRecord = new " + this.myClass.getName() + "();\nassertNotNull(testRecord);");
        if (!this.uselegacyJUnit) {
            setUpMethod.addAnnotation("Before");
        }
        JavaMethod tearDownMethod = this.myTestClass.addMethod(Access.PUBLIC, "void", "tearDown", null);
        if (!this.uselegacyJUnit) {
            tearDownMethod.addAnnotation("After");
        }
    }

    private void addSetterGetterTest(JavaVariable newVariable) {
        DataType dataType = DataType.getDataType(newVariable.getDataType());
        JavaMethod testMethod = new JavaMethod(Access.PUBLIC, "void", "test" + JavaVariable.createBeanMethodName(newVariable.getName()));
        StringBuilder testContent = new StringBuilder();
        if (!this.uselegacyJUnit) {
            testMethod.addAnnotation("Test");
        }
        switch (dataType) {
            case STRING: {
                testContent.append("String testData = \"abc\";\n");
                testContent.append("testRecord.").append(newVariable.getSetterMethodName()).append("(testData);\n");
                testContent.append("String recordData = testRecord.").append(newVariable.getGetterMethodName()).append("();\n");
                testContent.append("assertEquals(testData, recordData);");
                break;
            }
            case CHAR: {
                testContent.append("char testData = 'z';\n");
                testContent.append("testRecord.").append(newVariable.getSetterMethodName()).append("(testData);\n");
                testContent.append("char recordData = testRecord.").append(newVariable.getGetterMethodName()).append("();\n");
                testContent.append("assertEquals(testData, recordData);");
                break;
            }
            case BOOLEAN: {
                testContent.append("boolean testData = false;\n");
                testContent.append("testRecord.").append(newVariable.getSetterMethodName()).append("(testData);\n");
                testContent.append("boolean recordData = testRecord.").append(newVariable.getGetterMethodName()).append("();\n");
                testContent.append("assertEquals(testData, recordData);");
                break;
            }
            case INT: {
                testContent.append("int testData = 123;\n");
                testContent.append("testRecord.").append(newVariable.getSetterMethodName()).append("(testData);\n");
                testContent.append("int recordData = testRecord.").append(newVariable.getGetterMethodName()).append("();\n");
                testContent.append("assertEquals(testData, recordData);");
                break;
            }
            case FLOAT: {
                testContent.append("float testData = 123.56f;\n");
                testContent.append("testRecord.").append(newVariable.getSetterMethodName()).append("(testData);\n");
                testContent.append("float recordData = testRecord.").append(newVariable.getGetterMethodName()).append("();\n");
                testContent.append("assertEquals(testData, recordData, 0);");
                break;
            }
            case DOUBLE: {
                testContent.append("double testData = 123.56;\n");
                testContent.append("testRecord.").append(newVariable.getSetterMethodName()).append("(testData);\n");
                testContent.append("double recordData = testRecord.").append(newVariable.getGetterMethodName()).append("();\n");
                testContent.append("assertEquals(testData, recordData, 0);");
                break;
            }
            case DATE: {
                this.myTestClass.addImport("java.util.Calendar");
                this.myTestClass.addImport("java.util.Date");
                testContent.append("Calendar testData = Calendar.getInstance();\n");
                testContent.append("int testYear = 1980;\n");
                testContent.append("int testMonth = 2;\n");
                testContent.append("int testDay = 1;\n");
                testContent.append("testData.set(1980, 2, 1);\n");
                testContent.append("testRecord.").append(newVariable.getSetterMethodName()).append("(testData.getTime());\n");
                testContent.append("Date recordDataDate = testRecord.").append(newVariable.getGetterMethodName()).append("();\n");
                testContent.append("Calendar recordData = Calendar.getInstance();\n");
                testContent.append("recordData.setTime(recordDataDate);\n");
                testContent.append("int year = recordData.get(Calendar.YEAR);\n");
                testContent.append("int month = recordData.get(Calendar.MONTH);\n");
                testContent.append("int day = recordData.get(Calendar.DATE);\n");
                testContent.append("assertEquals(testYear, year);\n");
                testContent.append("assertEquals(testMonth, month);\n");
                testContent.append("assertEquals(testDay, day);\n");
            }
        }
        testMethod.setContent(testContent.toString());
        this.myTestClass.addMethod(testMethod);
    }

    public void setIncludeXML(boolean includeXML) {
        this.includeXML = includeXML;
    }

    public void setUseDateTime(boolean useDateTime) {
        this.useDateTime = useDateTime;
    }
}

