/*
 * Decompiled with CFR 0.152.
 */
package org.dbtools.gen.jpa;

import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.dbtools.gen.DBObjectBuilder;
import org.dbtools.gen.jpa.JPABaseRecordClassRenderer;
import org.dbtools.gen.jpa.JPAJEEBaseRecordManager;
import org.dbtools.gen.jpa.JPAJEERecordManager;
import org.dbtools.gen.jpa.JPAJSEBaseRecordManager;
import org.dbtools.gen.jpa.JPAJSERecordManager;
import org.dbtools.gen.jpa.JPARecordClassRenderer;
import org.dbtools.schema.SchemaDatabase;
import org.dbtools.schema.SchemaTable;

public class JPADBObjectBuilder
implements DBObjectBuilder {
    private JPAJSEBaseRecordManager baseSEManagerClass = new JPAJSEBaseRecordManager();
    private JPAJSERecordManager seManagerClass = new JPAJSERecordManager();
    private JPAJEEBaseRecordManager baseEEManagerClass = new JPAJEEBaseRecordManager();
    private JPAJEERecordManager eeManagerClass = new JPAJEERecordManager();
    private JPABaseRecordClassRenderer baseRecordClass = new JPABaseRecordClassRenderer();
    private JPARecordClassRenderer recordClass = new JPARecordClassRenderer();
    private int filesGeneratedCount = 0;
    private List<String> filesGenerated = new ArrayList<String>();
    private JPAManagerType managerType = JPAManagerType.JAVASE;
    private boolean jeeLocalInterface = false;
    private boolean jeeRemoteInterface = false;
    private boolean springSupport = false;
    private SchemaDatabase database;
    private SchemaTable table;
    private String packageName;
    private String outDir;
    private String testOutDir;
    private PrintStream psLog;
    private String author;
    private String version;

    @Override
    public String getName() {
        return "JPA Object Builder";
    }

    @Override
    public boolean build() {
        if (this.psLog == null) {
            this.psLog = System.out;
        }
        if (this.table == null) {
            this.psLog.println("ERROR: SchemaTable is null");
            return false;
        }
        this.psLog.println("SchemaTable: " + this.table.getName());
        char lastDirChar = this.outDir.charAt(this.outDir.length() - 1);
        if (lastDirChar != '\\' || lastDirChar != '/') {
            this.outDir = this.outDir.charAt(0) == '/' ? this.outDir + "/" : this.outDir + "\\";
        }
        if (!this.table.isEnumerationTable()) {
            File managerFile;
            String managerFileName;
            if (this.managerType == JPAManagerType.JAVASE) {
                managerFileName = this.outDir + JPAJSERecordManager.getClassName(this.table) + ".java";
                managerFile = new File(managerFileName);
                this.baseSEManagerClass.generateObjectCode(this.table, this.packageName, this.author, this.version, this.psLog);
                this.baseSEManagerClass.writeToFile(this.outDir);
                ++this.filesGeneratedCount;
                if (!managerFile.exists()) {
                    this.seManagerClass.generateObjectCode(this.table, this.packageName, this.author, this.version, this.psLog);
                    this.seManagerClass.writeToFile(this.outDir);
                    ++this.filesGeneratedCount;
                }
            } else {
                managerFileName = this.outDir + JPAJEERecordManager.getClassName(this.table) + ".java";
                managerFile = new File(managerFileName);
                this.baseEEManagerClass.generateObjectCode(this.table, this.packageName, this.author, this.version, this.psLog);
                this.baseEEManagerClass.writeToFile(this.outDir);
                ++this.filesGeneratedCount;
                if (!managerFile.exists()) {
                    this.eeManagerClass.generateObjectCode(this.table, this.packageName, this.author, this.version, this.psLog);
                    this.eeManagerClass.writeToFile(this.outDir);
                    ++this.filesGeneratedCount;
                }
            }
        }
        String baseRecordFileName = this.outDir + JPABaseRecordClassRenderer.createClassName(this.table) + ".java";
        String recordFileName = this.outDir + JPARecordClassRenderer.createClassName(this.table) + ".java";
        File baseRecordFile = new File(baseRecordFileName);
        File recordFile = new File(recordFileName);
        File recordTestFile = new File(recordFileName + "Test");
        this.baseRecordClass.generateObjectCode(this.database, this.table, this.packageName, this.author, this.version, this.psLog);
        this.baseRecordClass.writeToFile(this.outDir);
        if (this.testOutDir != null && this.testOutDir.length() > 0) {
            this.baseRecordClass.writeTestsToFile(this.testOutDir);
        }
        this.filesGenerated.add(baseRecordFile.getPath());
        ++this.filesGeneratedCount;
        if (!this.table.isEnumerationTable()) {
            if (!recordFile.exists()) {
                this.recordClass.generateObjectCode(this.database, this.table, this.packageName, this.author, this.version, this.psLog);
                this.recordClass.writeToFile(this.outDir);
                this.filesGenerated.add(recordFile.getPath());
                ++this.filesGeneratedCount;
            }
            if (this.testOutDir != null && this.testOutDir.length() > 0 && !recordTestFile.exists()) {
                this.recordClass.writeTestsToFile(this.testOutDir, this.table, this.packageName);
            }
        }
        return true;
    }

    @Override
    public int getNumberFilesGenerated() {
        return this.filesGeneratedCount;
    }

    @Override
    public List<String> getFilesGenerated() {
        return this.filesGenerated;
    }

    @Override
    public void setIncludeXMLSupport(boolean b) {
        this.baseRecordClass.setIncludeXML(b);
    }

    @Override
    public void setUseDateTime(boolean b) {
        this.baseRecordClass.setUseDateTime(b);
    }

    public JPAManagerType getManagerType() {
        return this.managerType;
    }

    public void setManagerType(JPAManagerType managerType) {
        this.managerType = managerType;
    }

    public boolean isJeeLocalInterface() {
        return this.jeeLocalInterface;
    }

    public void setJeeLocalInterface(boolean jeeLocalInterface) {
        this.baseEEManagerClass.setLocalInterfaceRequired(jeeLocalInterface);
        this.eeManagerClass.setLocalInterfaceRequired(jeeLocalInterface);
        this.jeeLocalInterface = jeeLocalInterface;
    }

    public boolean isJeeRemoteInterface() {
        return this.jeeRemoteInterface;
    }

    public void setJeeRemoteInterface(boolean jeeRemoteInterface) {
        this.baseEEManagerClass.setRemoteInterfaceRequired(jeeRemoteInterface);
        this.eeManagerClass.setRemoteInterfaceRequired(jeeRemoteInterface);
        this.jeeRemoteInterface = jeeRemoteInterface;
    }

    public boolean isSpringSupport() {
        return this.springSupport;
    }

    @Override
    public void setSpringSupport(boolean springSupport) {
        this.springSupport = springSupport;
        this.baseSEManagerClass.setSpringSupport(springSupport);
        this.seManagerClass.setSpringSupport(springSupport);
    }

    @Override
    public void setTable(SchemaTable table) {
        this.table = table;
    }

    @Override
    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    @Override
    public void setSourceOutputDir(String outDir) {
        this.outDir = outDir;
    }

    @Override
    public void setTestOutputDir(String outDir) {
        this.testOutDir = outDir;
    }

    @Override
    public void setLogPrintStream(PrintStream psLog) {
        this.psLog = psLog;
    }

    @Override
    public void setAuthor(String author) {
        this.author = author;
    }

    @Override
    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public void setDatabase(SchemaDatabase dbSchema) {
        this.database = dbSchema;
    }

    @Override
    public void setProperty(String key, Object value) {
    }

    public static enum JPAManagerType {
        JAVAEE,
        JAVASE;

    }
}

