/*
 * Decompiled with CFR 0.152.
 */
package org.dbtools.gen.jpa;

import java.io.PrintStream;
import java.util.ArrayList;
import org.dbtools.codegen.Access;
import org.dbtools.codegen.JavaClass;
import org.dbtools.codegen.JavaInterface;
import org.dbtools.codegen.JavaMethod;
import org.dbtools.codegen.JavaVariable;
import org.dbtools.gen.jpa.JPAJEERecordManager;
import org.dbtools.gen.jpa.JPARecordClassRenderer;
import org.dbtools.schema.SchemaTable;

public class JPAJEEBaseRecordManager {
    private JavaClass myClass;
    private JavaInterface localInterface;
    private JavaInterface remoteInterface;
    private JavaInterface localInterfaceBase;
    private JavaInterface remoteInterfaceBase;
    private boolean localInterfaceRequired = false;
    private boolean remoteInterfaceRequired = false;

    public void generateObjectCode(SchemaTable table, String packageName, String author, String version, PrintStream psLog) {
        String TAB = JavaClass.getTab();
        String recordClassName = JPARecordClassRenderer.createClassName(table);
        String className = JPAJEEBaseRecordManager.getClassName(table);
        this.myClass = new JavaClass(packageName, className);
        String localBaseInterfaceName = JPAJEEBaseRecordManager.getLocalBaseInterfaceName(table);
        this.localInterfaceBase = new JavaInterface(packageName, localBaseInterfaceName);
        String localInterfaceName = JPAJEEBaseRecordManager.getLocalInterfaceName(table);
        this.localInterface = new JavaInterface(packageName, localInterfaceName);
        this.localInterface.addImport("javax.ejb.Local");
        this.localInterface.addAnnotation("Local");
        this.localInterface.setExtends(localBaseInterfaceName);
        String remoteBaseInterfaceName = JPAJEEBaseRecordManager.getRemoteBaseInterfaceName(table);
        this.remoteInterfaceBase = new JavaInterface(packageName, remoteBaseInterfaceName);
        String remoteInterfaceName = JPAJEEBaseRecordManager.getRemoteInterfaceName(table);
        this.remoteInterface = new JavaInterface(packageName, remoteInterfaceName);
        this.remoteInterface.addImport("javax.ejb.Remote");
        this.remoteInterface.addAnnotation("Remote");
        this.remoteInterface.setExtends(remoteBaseInterfaceName);
        if (this.isLocalInterfaceRequired()) {
            this.myClass.addImplements(localBaseInterfaceName);
        }
        if (this.isRemoteInterfaceRequired()) {
            this.myClass.addImplements(remoteBaseInterfaceName);
        }
        String fileHeaderComment = "/*\n";
        fileHeaderComment = fileHeaderComment + " * " + className + ".java\n";
        fileHeaderComment = fileHeaderComment + " *\n";
        fileHeaderComment = fileHeaderComment + " * GENERATED FILE - DO NOT EDIT\n";
        fileHeaderComment = fileHeaderComment + " * CHECKSTYLE:OFF\n";
        fileHeaderComment = fileHeaderComment + " * \n";
        fileHeaderComment = fileHeaderComment + " */\n";
        this.myClass.setFileHeaderComment(fileHeaderComment);
        this.myClass.addAnnotation("@SuppressWarnings(\"all\")");
        ArrayList<JavaVariable> constParams = new ArrayList<JavaVariable>();
        constParams.add(new JavaVariable("EntityManager", "em"));
        String constContent = "";
        constContent = "if (em == null) {\n";
        constContent = TAB + "throw new IllegalArgumentException(\"EntityManager parameter cannot be null\");\n";
        constContent = "}\n";
        constContent = "this.entityManager = em;";
        this.myClass.addConstructor(Access.PUBLIC, constParams, constContent);
        this.myClass.addImport("javax.persistence.EntityManager");
        JavaVariable emVar = this.myClass.addVariable("EntityManager", "entityManager");
        emVar.setGenerateGetter(true);
        this.myClass.addImport("javax.persistence.PersistenceContext");
        emVar.addAnnotation("PersistenceContext");
        String recordVarParamName = "record";
        ArrayList<JavaVariable> recordClassOnlyParam = new ArrayList<JavaVariable>();
        recordClassOnlyParam.add(new JavaVariable(recordClassName, recordVarParamName));
        JavaMethod persistMethod = this.myClass.addMethod(Access.PUBLIC, "void", "create", recordClassOnlyParam, "entityManager.persist(" + recordVarParamName + ");");
        this.localInterfaceBase.addMethod(persistMethod);
        this.remoteInterfaceBase.addMethod(persistMethod);
        String updateContent = recordClassName + " mergedRecord = entityManager.merge(" + recordVarParamName + ");\n" + "mergedRecord." + "cleanupOrphans" + "(entityManager);  // work-around till CascadeType.DELETE-ORPHAN is supported\n";
        JavaMethod mergeMethod = this.myClass.addMethod(Access.PUBLIC, "void", "update", recordClassOnlyParam, updateContent);
        this.localInterfaceBase.addMethod(mergeMethod);
        this.remoteInterfaceBase.addMethod(mergeMethod);
        String deleteContent = recordClassName + " mergedRecord = entityManager.merge(" + recordVarParamName + ");\n" + "mergedRecord." + "cleanupOrphans" + "(entityManager);  // work-around till CascadeType.DELETE-ORPHAN is supported\n" + "entityManager.remove(mergedRecord);\n";
        JavaMethod deleteMethod = this.myClass.addMethod(Access.PUBLIC, "void", "delete", recordClassOnlyParam, deleteContent);
        this.localInterfaceBase.addMethod(deleteMethod);
        this.remoteInterfaceBase.addMethod(deleteMethod);
        ArrayList<JavaVariable> findParams = new ArrayList<JavaVariable>();
        findParams.add(new JavaVariable("Object", "pk"));
        JavaMethod findMethod = this.myClass.addMethod(Access.PUBLIC, recordClassName, "find", findParams, "return (" + recordClassName + ") entityManager.find(" + recordClassName + ".class, pk);");
        this.localInterfaceBase.addMethod(findMethod);
        this.remoteInterfaceBase.addMethod(findMethod);
    }

    public static String getClassName(SchemaTable table) {
        String recordClassName = JPARecordClassRenderer.createClassName(table);
        return recordClassName + "BaseManager";
    }

    public static String getLocalInterfaceName(SchemaTable table) {
        return JPAJEERecordManager.getClassName(table) + "Local";
    }

    public static String getRemoteInterfaceName(SchemaTable table) {
        return JPAJEERecordManager.getClassName(table) + "Remote";
    }

    public static String getLocalBaseInterfaceName(SchemaTable table) {
        return JPAJEERecordManager.getClassName(table) + "LocalBase";
    }

    public static String getRemoteBaseInterfaceName(SchemaTable table) {
        return JPAJEERecordManager.getClassName(table) + "RemoteBase";
    }

    public void writeToFile(String outDir) {
        this.myClass.writeToDisk(outDir);
        if (this.isLocalInterfaceRequired()) {
            this.localInterface.writeToDisk(outDir, false);
            this.localInterfaceBase.writeToDisk(outDir);
        }
        if (this.isRemoteInterfaceRequired()) {
            this.remoteInterface.writeToDisk(outDir, false);
            this.remoteInterfaceBase.writeToDisk(outDir);
        }
    }

    public boolean isLocalInterfaceRequired() {
        return this.localInterfaceRequired;
    }

    public void setLocalInterfaceRequired(boolean localInterfaceRequired) {
        this.localInterfaceRequired = localInterfaceRequired;
    }

    public boolean isRemoteInterfaceRequired() {
        return this.remoteInterfaceRequired;
    }

    public void setRemoteInterfaceRequired(boolean remoteInterfaceRequired) {
        this.remoteInterfaceRequired = remoteInterfaceRequired;
    }
}

