/*
 * Decompiled with CFR 0.152.
 */
package org.dbtools.gen.jpa;

import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.dbtools.codegen.JavaClass;
import org.dbtools.gen.jpa.JPAJEEBaseRecordManager;
import org.dbtools.gen.jpa.JPARecordClassRenderer;
import org.dbtools.schema.SchemaTable;

public class JPAJEERecordManager {
    private JavaClass myClass;
    private boolean localInterfaceRequired = false;
    private boolean remoteInterfaceRequired = false;

    public void generateObjectCode(SchemaTable table, String packageName, String author, String version, PrintStream psLog) {
        String className = JPAJEERecordManager.getClassName(table);
        this.myClass = new JavaClass(packageName, className);
        this.myClass.setExtends(JPAJEEBaseRecordManager.getClassName(table));
        if (this.isLocalInterfaceRequired()) {
            this.myClass.addImplements(JPAJEEBaseRecordManager.getLocalInterfaceName(table));
        }
        if (this.isRemoteInterfaceRequired()) {
            this.myClass.addImplements(JPAJEEBaseRecordManager.getRemoteInterfaceName(table));
        }
        this.myClass.addImport("javax.ejb.Stateless");
        this.myClass.addAnnotation("Stateless");
        Date now = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss");
        String fileHeaderComment = "/*\n";
        fileHeaderComment = fileHeaderComment + " * " + className + ".java\n";
        fileHeaderComment = fileHeaderComment + " *\n";
        fileHeaderComment = fileHeaderComment + " * Created Generated: " + dateFormat.format(now) + "\n";
        fileHeaderComment = fileHeaderComment + " *\n";
        fileHeaderComment = fileHeaderComment + " */\n";
        this.myClass.setFileHeaderComment(fileHeaderComment);
    }

    public static String getClassName(SchemaTable table) {
        String recordClassName = JPARecordClassRenderer.createClassName(table);
        return recordClassName + "Manager";
    }

    public void writeToFile(String outDir) {
        this.myClass.writeToDisk(outDir);
    }

    public boolean isLocalInterfaceRequired() {
        return this.localInterfaceRequired;
    }

    public void setLocalInterfaceRequired(boolean localInterfaceRequired) {
        this.localInterfaceRequired = localInterfaceRequired;
    }

    public boolean isRemoteInterfaceRequired() {
        return this.remoteInterfaceRequired;
    }

    public void setRemoteInterfaceRequired(boolean remoteInterfaceRequired) {
        this.remoteInterfaceRequired = remoteInterfaceRequired;
    }
}

