/*
 * Decompiled with CFR 0.152.
 */
package org.dbtools.gen.jpa;

import java.io.PrintStream;
import java.util.ArrayList;
import org.dbtools.codegen.Access;
import org.dbtools.codegen.JavaClass;
import org.dbtools.codegen.JavaMethod;
import org.dbtools.codegen.JavaVariable;
import org.dbtools.gen.jpa.JPARecordClassRenderer;
import org.dbtools.schema.SchemaTable;

public class JPAJSEBaseRecordManager {
    private JavaClass myClass;
    private boolean springSupport = false;

    public void generateObjectCode(SchemaTable table, String packageName, String author, String version, PrintStream psLog) {
        String TAB = JavaClass.getTab();
        String recordClassName = JPARecordClassRenderer.createClassName(table);
        String className = JPAJSEBaseRecordManager.getClassName(table);
        this.myClass = new JavaClass(packageName, className);
        String fileHeaderComment = "/*\n";
        fileHeaderComment = fileHeaderComment + " * " + className + ".java\n";
        fileHeaderComment = fileHeaderComment + " *\n";
        fileHeaderComment = fileHeaderComment + " * GENERATED FILE - DO NOT EDIT\n";
        fileHeaderComment = fileHeaderComment + " * CHECKSTYLE:OFF\n";
        fileHeaderComment = fileHeaderComment + " * \n";
        fileHeaderComment = fileHeaderComment + " */\n";
        this.myClass.setFileHeaderComment(fileHeaderComment);
        this.myClass.addAnnotation("@SuppressWarnings(\"all\")");
        this.myClass.setCreateDefaultConstructor(false);
        this.myClass.addConstructor(Access.PRIVATE, null, null);
        ArrayList<JavaVariable> constParams = new ArrayList<JavaVariable>();
        constParams.add(new JavaVariable("EntityManager", "em"));
        String constContent = "";
        constContent = "if (em == null) {\n";
        constContent = TAB + "throw new IllegalArgumentException(\"EntityManager parameter cannot be null\");\n";
        constContent = "}\n";
        constContent = "this.entityManager = em;";
        this.myClass.addConstructor(Access.PUBLIC, constParams, constContent);
        String managerClassName = JPARecordClassRenderer.createClassName(table) + "Manager";
        JavaVariable managerFactoryVar = this.myClass.addVariable(managerClassName, "manager");
        managerFactoryVar.setStatic(true);
        managerFactoryVar.setVolatile(true);
        managerFactoryVar.setGenerateSetter(true);
        String factoryMethodContet = "";
        factoryMethodContet = factoryMethodContet + "if (manager == null) {\n";
        factoryMethodContet = factoryMethodContet + TAB + "manager = new " + managerClassName + "(em);\n";
        factoryMethodContet = factoryMethodContet + "}\n\n";
        factoryMethodContet = factoryMethodContet + "manager.setEntityManager(em);\n";
        factoryMethodContet = factoryMethodContet + "\n";
        factoryMethodContet = factoryMethodContet + "return manager;\n";
        ArrayList<JavaVariable> factoryParams = new ArrayList<JavaVariable>();
        factoryParams.add(new JavaVariable("EntityManager", "em"));
        JavaMethod factoryMethod = this.myClass.addMethod(Access.PUBLIC, managerClassName, "get" + managerClassName, factoryParams, factoryMethodContet);
        factoryMethod.setStatic(true);
        this.myClass.addImport("javax.persistence.EntityManager");
        JavaVariable emVar = this.myClass.addVariable("EntityManager", "entityManager", true);
        emVar.addAnnotation("@javax.persistence.PersistenceContext");
        String recordVarParamName = "record";
        ArrayList<JavaVariable> recordClassOnlyParam = new ArrayList<JavaVariable>();
        recordClassOnlyParam.add(new JavaVariable(recordClassName, recordVarParamName));
        JavaMethod createMethod = this.myClass.addMethod(Access.PUBLIC, "void", "create", recordClassOnlyParam, "entityManager.persist(" + recordVarParamName + ");");
        this.addSpringSupport(createMethod);
        String updateContent = recordClassName + " mergedRecord = entityManager.merge(" + recordVarParamName + ");\n" + "mergedRecord." + "cleanupOrphans" + "(entityManager);  // work-around till CascadeType.DELETE-ORPHAN is supported\n";
        JavaMethod updateMethod = this.myClass.addMethod(Access.PUBLIC, "void", "update", recordClassOnlyParam, updateContent);
        this.addSpringSupport(updateMethod);
        String deleteContent = recordClassName + " mergedRecord = entityManager.merge(" + recordVarParamName + ");\n" + "mergedRecord." + "cleanupOrphans" + "(entityManager);  // work-around till CascadeType.DELETE-ORPHAN is supported\n" + "entityManager.remove(mergedRecord);\n";
        JavaMethod deleteMethod = this.myClass.addMethod(Access.PUBLIC, "void", "delete", recordClassOnlyParam, deleteContent);
        this.addSpringSupport(deleteMethod);
        String saveContent = "if (" + recordVarParamName + ".isNewRecord()) {\n" + TAB + "create(" + recordVarParamName + ");\n" + "} else {\n" + TAB + "update(" + recordVarParamName + ");\n" + "}\n";
        JavaMethod saveMethod = this.myClass.addMethod(Access.PUBLIC, "void", "save", recordClassOnlyParam, saveContent);
        this.addSpringSupport(saveMethod);
        ArrayList<JavaVariable> findParams = new ArrayList<JavaVariable>();
        findParams.add(new JavaVariable("Object", "pk"));
        this.myClass.addMethod(Access.PUBLIC, recordClassName, "find", findParams, "return (" + recordClassName + ") entityManager.find(" + recordClassName + ".class, pk);");
        this.myClass.addImport("javax.persistence.Query");
        String findCountContent = "Query q = getEntityManager().createNativeQuery(\"SELECT count(0) FROM \" + " + recordClassName + ".TABLE);\n" + "return ((Number) q.getSingleResult()).longValue();\n";
        this.myClass.addMethod(Access.PUBLIC, "long", "findCount", findCountContent);
    }

    private void addSpringSupport(JavaMethod method) {
        if (this.springSupport) {
            method.addAnnotation("@org.springframework.transaction.annotation.Transactional");
        }
    }

    public static String getClassName(SchemaTable table) {
        String recordClassName = JPARecordClassRenderer.createClassName(table);
        return recordClassName + "BaseManager";
    }

    public void writeToFile(String outDir) {
        this.myClass.writeToDisk(outDir);
    }

    void setSpringSupport(boolean b) {
        this.springSupport = b;
    }
}

