/*
 * Decompiled with CFR 0.152.
 */
package org.dbtools.gen.jpa;

import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.dbtools.codegen.Access;
import org.dbtools.codegen.JavaClass;
import org.dbtools.codegen.JavaVariable;
import org.dbtools.gen.jpa.JPAJSEBaseRecordManager;
import org.dbtools.gen.jpa.JPARecordClassRenderer;
import org.dbtools.schema.SchemaTable;

public class JPAJSERecordManager {
    private JavaClass myClass;
    private boolean springSupport = false;

    public void generateObjectCode(SchemaTable table, String packageName, String author, String version, PrintStream psLog) {
        String className = JPAJSERecordManager.getClassName(table);
        this.myClass = new JavaClass(packageName, className);
        this.myClass.setExtends(JPAJSEBaseRecordManager.getClassName(table));
        if (this.springSupport) {
            this.myClass.addImport("javax.inject.Named");
            this.myClass.addAnnotation("@Named");
        }
        Date now = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss");
        String fileHeaderComment = "/*\n";
        fileHeaderComment = fileHeaderComment + " * " + className + ".java\n";
        fileHeaderComment = fileHeaderComment + " *\n";
        fileHeaderComment = fileHeaderComment + " * Generated on: " + dateFormat.format(now) + "\n";
        fileHeaderComment = fileHeaderComment + " *\n";
        fileHeaderComment = fileHeaderComment + " */\n";
        this.myClass.setFileHeaderComment(fileHeaderComment);
        this.myClass.setCreateDefaultConstructor(false);
        if (this.springSupport) {
            this.myClass.addConstructor(Access.PUBLIC, null, "super(null);");
        }
        ArrayList<JavaVariable> constParams = new ArrayList<JavaVariable>();
        this.myClass.addImport("javax.persistence.EntityManager");
        constParams.add(new JavaVariable("EntityManager", "em"));
        String constContent = "super(em);";
        this.myClass.addConstructor(Access.PUBLIC, constParams, constContent);
    }

    public static String getClassName(SchemaTable table) {
        String recordClassName = JPARecordClassRenderer.createClassName(table);
        return recordClassName + "Manager";
    }

    public void writeToFile(String outDir) {
        this.myClass.writeToDisk(outDir);
    }

    void setSpringSupport(boolean b) {
        this.springSupport = b;
    }
}

