/*
 * Decompiled with CFR 0.152.
 */
package org.dbtools.gen.jpa;

import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.dbtools.codegen.Access;
import org.dbtools.codegen.JavaClass;
import org.dbtools.codegen.JavaMethod;
import org.dbtools.codegen.JavaVariable;
import org.dbtools.gen.jpa.JPABaseRecordClassRenderer;
import org.dbtools.schema.SchemaDatabase;
import org.dbtools.schema.SchemaTable;

public class JPARecordClassRenderer {
    private JavaClass myClass;
    private JavaClass myTestClass;
    private boolean uselegacyJUnit = false;

    public void generateObjectCode(SchemaDatabase dbSchema, SchemaTable table, String packageName, String author, String version, PrintStream psLog) {
        if (psLog == null) {
            psLog = System.out;
        }
        String baseClassName = JPABaseRecordClassRenderer.createClassName(table);
        String className = JPARecordClassRenderer.createClassName(table);
        this.myClass = new JavaClass(packageName, className);
        this.myClass.setExtends(baseClassName);
        Date now = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss");
        String fileHeaderComment = "/*\n";
        fileHeaderComment = fileHeaderComment + " * " + className + ".java\n";
        fileHeaderComment = fileHeaderComment + " *\n";
        fileHeaderComment = fileHeaderComment + " * Created: " + dateFormat.format(now) + "\n";
        fileHeaderComment = fileHeaderComment + " */\n";
        this.myClass.setFileHeaderComment(fileHeaderComment);
        this.myClass.addAnnotation("@javax.persistence.Entity()");
        this.myClass.addImport("javax.persistence.Table");
        this.myClass.addAnnotation("@Table(name=" + baseClassName + ".TABLE)");
    }

    private void initTestClass(String className) {
        if (this.uselegacyJUnit) {
            this.myTestClass.addImport("junit.framework.*");
            this.myTestClass.setExtends("TestCase");
        } else {
            this.myTestClass.addImport("org.junit.*");
            this.myTestClass.addImport("static org.junit.Assert.*");
        }
        if (this.uselegacyJUnit) {
            ArrayList<JavaVariable> params = new ArrayList<JavaVariable>();
            params.add(new JavaVariable("String", "testName"));
            this.myTestClass.addConstructor(Access.PUBLIC, params, "super(testName);");
        } else {
            this.myTestClass.setCreateDefaultConstructor(true);
        }
        this.myTestClass.addVariable(className, "testRecord");
        JavaMethod setUpMethod = this.myTestClass.addMethod(Access.PUBLIC, "void", "setUp", "testRecord = new " + className + "();\nassertNotNull(testRecord);");
        if (!this.uselegacyJUnit) {
            setUpMethod.addAnnotation("Before");
        }
        JavaMethod tearDownMethod = this.myTestClass.addMethod(Access.PUBLIC, "void", "tearDown", null);
        if (!this.uselegacyJUnit) {
            tearDownMethod.addAnnotation("After");
        }
        if (this.uselegacyJUnit) {
            this.myTestClass.addMethod(Access.PUBLIC, "void", "testEmpty", "");
        } else {
            JavaMethod emptyTestMethod = this.myTestClass.addMethod(Access.PUBLIC, "void", "emptyTest", "");
            emptyTestMethod.addAnnotation("Test");
        }
    }

    public static String createClassName(SchemaTable table) {
        return table.getClassName();
    }

    public String getFilename() {
        return this.myClass.getFilename();
    }

    public void writeToFile(String directoryname) {
        this.myClass.writeToDisk(directoryname);
    }

    public void writeTestsToFile(String directoryname, SchemaTable table, String packageName) {
        String className = JPARecordClassRenderer.createClassName(table);
        this.myTestClass = new JavaClass(packageName, className + "Test");
        this.initTestClass(className);
        this.myTestClass.writeToDisk(directoryname);
    }
}

