/*
 * Decompiled with CFR 0.152.
 */
package org.dbtools.schema;

public class ClassInfo {
    private String className;
    private String packageName;

    public ClassInfo(String className, String packageName) {
        this.className = className;
        this.packageName = packageName;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getPackageName(String otherEntityPackage) {
        String packageNameToUse = this.packageName == null ? ClassInfo.transformPackageName(otherEntityPackage, this.getClassName()) : this.packageName + "." + this.className.toLowerCase();
        return packageNameToUse;
    }

    public static String transformPackageName(String otherEntityPackage, String newClassname) {
        String newPackagename = "";
        String[] packageElements = otherEntityPackage.split("\\.");
        for (int i = 0; i < packageElements.length - 1; ++i) {
            newPackagename = newPackagename + packageElements[i] + ".";
        }
        return newPackagename + newClassname.toLowerCase();
    }

    public String toString() {
        String out = "Classname: " + this.className + "\n";
        out = out + "Package: " + this.packageName + "\n";
        return out;
    }
}

