/*
 * Decompiled with CFR 0.152.
 */
package org.dbtools.schema;

import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dbtools.schema.SchemaDatabase;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class DatabaseSchema {
    private List<SchemaDatabase> schemaDatabases;

    public boolean readXMLSchema(String schemaFilename, String dbVendorName, boolean schemaXMLFilenameIsAResource) {
        return this.readXMLSchema(schemaFilename, dbVendorName, schemaXMLFilenameIsAResource, null);
    }

    public boolean readXMLSchema(String schemaFilename, String dbVendorName, boolean schemaXMLFilenameIsAResource, PrintStream logPrintStream) {
        if (logPrintStream == null) {
            logPrintStream = System.out;
        }
        try {
            Document doc;
            SAXReader xmlReader = new SAXReader(false);
            if (schemaXMLFilenameIsAResource) {
                InputStream xmlSchemaInputStream = null;
                logPrintStream.print("Loading XML schema from classpath [" + schemaFilename + "]...");
                xmlSchemaInputStream = this.getClass().getResourceAsStream(schemaFilename);
                if (xmlSchemaInputStream == null) {
                    logPrintStream.println("[Failed] cannot find file resource in classpath!");
                    return false;
                }
                doc = xmlReader.read(xmlSchemaInputStream);
            } else {
                File schemaFile = new File(schemaFilename);
                doc = xmlReader.read(schemaFile);
            }
            Element root = doc.getRootElement();
            this.schemaDatabases = new ArrayList<SchemaDatabase>();
            Iterator dbItr = root.elementIterator("database");
            while (dbItr.hasNext()) {
                Element dbElement = (Element)dbItr.next();
                this.schemaDatabases.add(new SchemaDatabase(schemaFilename, dbVendorName, schemaXMLFilenameIsAResource, dbElement));
            }
        }
        catch (DocumentException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public List<SchemaDatabase> getSchemaDatabases() {
        return this.schemaDatabases;
    }

    public SchemaDatabase getDefaultDatabase() {
        if (this.schemaDatabases.size() > 0) {
            return this.schemaDatabases.get(0);
        }
        return null;
    }

    public SchemaDatabase getDatabase(String name) {
        for (SchemaDatabase schemaDatabase : this.schemaDatabases) {
            if (!name.equals(schemaDatabase.getName())) continue;
            return schemaDatabase;
        }
        return null;
    }

    public List<String> getTableNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (SchemaDatabase schemaDatabase : this.schemaDatabases) {
            names.addAll(schemaDatabase.getTableNames());
        }
        return names;
    }
}

