/*
 * Decompiled with CFR 0.152.
 */
package org.dbtools.schema;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dbtools.schema.ForeignKey;
import org.dbtools.schema.SchemaDatabase;
import org.dbtools.schema.SchemaField;
import org.dbtools.schema.SchemaRenderer;
import org.dbtools.schema.SchemaTable;
import org.dbtools.schema.SchemaView;
import org.dbtools.schema.SchemaViewField;

public class FireBirdRenderer
extends SchemaRenderer {
    public static final String RENDERER_NAME = "firebird";
    private int indexNumber = 0;

    public FireBirdRenderer() {
        this.setDbVendorName(RENDERER_NAME);
    }

    public FireBirdRenderer(PrintStream ps) {
        super(ps);
        this.setDbVendorName(RENDERER_NAME);
    }

    @Override
    public String generateSchema(SchemaDatabase database, String[] tablesToGenerate, String[] viewsToGenerate, boolean dropTables, boolean createInserts) {
        this.showProgress("Generating SQL schema using FireBird renderer ...", true);
        StringBuilder schema = new StringBuilder();
        ArrayList<ForeignKey> foreignKeysToCreate = new ArrayList<ForeignKey>();
        SchemaField incrementField = null;
        List<SchemaTable> requestedTables = this.getTablesToGenerate(database, tablesToGenerate);
        List<SchemaView> requestedViews = this.getViewsToGenerate(database, viewsToGenerate);
        if (dropTables) {
            this.generateDropSchema(false, true, schema, requestedTables, requestedViews);
        }
        for (SchemaTable table : requestedTables) {
            ArrayList<SchemaField> indexFields = new ArrayList<SchemaField>();
            schema.append("CREATE TABLE ");
            schema.append(table.getName());
            schema.append(" (\n");
            List<SchemaField> fields = table.getFields();
            SchemaField enumPKField = null;
            SchemaField enumValueField = null;
            for (int j = 0; j < fields.size(); ++j) {
                String defaultValue;
                SchemaField field = fields.get(j);
                schema.append("\t");
                schema.append(field.getName());
                schema.append(" ");
                schema.append(this.getTypes().get(field.getJdbcType()));
                if (field.getSize() > 0) {
                    schema.append("(");
                    schema.append(field.getSize());
                    if (field.getDecimals() > 0) {
                        schema.append(", ").append(field.getDecimals());
                    }
                    schema.append(")");
                }
                if (field.isNotNull() && field.isPrimaryKey()) {
                    schema.append(" NOT NULL");
                }
                if (field.isPrimaryKey()) {
                    schema.append(" PRIMARY KEY");
                }
                if (field.isIncrement()) {
                    incrementField = field;
                }
                if ((defaultValue = field.getDefaultValue()) != null && !defaultValue.equals("")) {
                    schema.append(" DEFAULT ").append(this.formatDefaultValue(field));
                }
                if ((field.isNotNull() || field.isUnique()) && !field.isPrimaryKey()) {
                    schema.append(" NOT NULL");
                }
                if (field.isUnique()) {
                    schema.append(" UNIQUE");
                }
                if (field.isIndex()) {
                    indexFields.add(field);
                }
                if (!field.getForeignKeyField().equals("")) {
                    foreignKeysToCreate.add(new ForeignKey(table.getName(), field.getName(), field.getForeignKeyTable(), field.getForeignKeyField()));
                }
                if (j != fields.size() - 1) {
                    schema.append(",\n");
                }
                if (enumPKField == null && field.isPrimaryKey()) {
                    enumPKField = field;
                }
                if (enumValueField != null || !field.getJdbcType().equals("VARCHAR")) continue;
                enumValueField = field;
            }
            List<List<String>> uniqueDeclarations = table.getUniqueDeclarations();
            for (int j = 0; j < uniqueDeclarations.size(); ++j) {
                String uniqueFieldString = "";
                List<String> uniqueFields = uniqueDeclarations.get(j);
                for (int k = 0; k < uniqueFields.size(); ++k) {
                    String uniqueField = uniqueFields.get(k);
                    if (k > 0) {
                        uniqueFieldString = uniqueFieldString + ", ";
                    }
                    uniqueFieldString = uniqueFieldString + uniqueField;
                }
                schema.append(",\n\tUNIQUE(" + uniqueFieldString + ")");
            }
            String tableType = table.getParameter("tableType");
            if (tableType != null && !tableType.equals("")) {
                schema.append("\n) TYPE=");
                schema.append(tableType);
                schema.append(";\n");
            } else {
                schema.append("\n);\n");
            }
            if (incrementField != null) {
                schema.append("CREATE GENERATOR gen" + table.getName() + "ID;\n");
            }
            for (int k = 0; k < indexFields.size(); ++k) {
                SchemaField iField = (SchemaField)indexFields.get(k);
                ++this.indexNumber;
                String indexName = "IDX_" + this.indexNumber;
                schema.append("CREATE INDEX ").append(indexName).append(" ON " + table.getName()).append(" (").append(iField.getName()).append(");\n");
            }
            schema.append("\n\n");
            FireBirdRenderer.generateEnumSchema(schema, table, this.getAlreadyCreatedEnum(), enumPKField, enumValueField, createInserts);
        }
        for (ForeignKey fk : foreignKeysToCreate) {
            schema.append("ALTER TABLE " + fk.getPrimaryKeyTable() + "\n");
            schema.append("ADD CONSTRAINT " + fk.getPrimaryKeyTable() + "_" + fk.getPrimaryKeyField() + "_FK\n");
            schema.append("FOREIGN KEY (" + fk.getPrimaryKeyField() + ")\n");
            schema.append("REFERENCES " + fk.getForeignKeyTable() + " (" + fk.getForeignKeyField() + ");\n");
            schema.append("\n");
        }
        for (SchemaView view : requestedViews) {
            schema.append("CREATE VIEW " + view.getName() + " ");
            String aliases = "";
            String selectItems = "";
            Iterator<SchemaViewField> vfItr = view.getViewFields().iterator();
            while (vfItr.hasNext()) {
                SchemaViewField viewField = vfItr.next();
                aliases = aliases + viewField.getName();
                selectItems = selectItems + "\t" + viewField.getExpression();
                if (vfItr.hasNext()) {
                    aliases = aliases + ", ";
                    selectItems = selectItems + ",\n";
                    continue;
                }
                selectItems = selectItems + "\n";
            }
            schema.append("(" + aliases + ")");
            schema.append(" AS\n  SELECT \n" + selectItems);
            schema.append("  " + view.getViewPostSelectClause() + ";");
            schema.append("\n\n");
        }
        return schema.toString();
    }

    @Override
    public String generatePostSchema(SchemaDatabase database, String[] tablesToGenerate) {
        StringBuffer postSchema = new StringBuffer();
        postSchema.append("\n\n");
        List<SchemaTable> requestedTables = this.getTablesToGenerate(database, tablesToGenerate);
        for (int i = 0; i < requestedTables.size(); ++i) {
            SchemaTable table = requestedTables.get(i);
            boolean containsSequence = false;
            int incrementInitialValue = -1;
            List<SchemaField> fields = table.getFields();
            Iterator<SchemaField> fItr = fields.iterator();
            while (fItr.hasNext() && !containsSequence) {
                SchemaField field = fItr.next();
                if (!field.isIncrement()) continue;
                containsSequence = true;
                incrementInitialValue = field.getIncrementInitialValue();
            }
            if (!containsSequence) continue;
            if (incrementInitialValue == 1) {
                postSchema.append("SELECT GEN_ID (gen" + table.getName() + "ID, (SELECT MAX(ID) FROM " + table.getName() + ") - GEN_ID (gen" + table.getName() + "ID,0) ) FROM RDB$DATABASE;\n");
                continue;
            }
            postSchema.append("SELECT GEN_ID (gen" + table.getName() + "ID, " + incrementInitialValue + ") FROM RDB$DATABASE;\n");
        }
        return postSchema.toString();
    }
}

