/*
 * Decompiled with CFR 0.152.
 */
package org.dbtools.schema;

public class ForeignKey {
    public static final int TYPE_IMPORTED_KEYS = 10;
    public static final int TYPE_EXPORTED_KEYS = 20;
    private int type = 10;
    private String primaryKeyTable;
    private String primaryKeyField;
    private String primaryKeyName;
    private String foreignKeyTable;
    private String foreignKeyField;
    private String foreignKeyName;
    private String keySequence;

    public ForeignKey() {
    }

    public ForeignKey(String primaryKeyTable, String primaryKeyField, String foreignKeyTable, String foreignKeyField) {
        this.primaryKeyTable = primaryKeyTable;
        this.primaryKeyField = primaryKeyField;
        this.foreignKeyTable = foreignKeyTable;
        this.foreignKeyField = foreignKeyField;
    }

    public String toString() {
        switch (this.type) {
            default: {
                return this.foreignKeyField + " -> " + this.primaryKeyTable + "." + this.primaryKeyField + " | (" + this.foreignKeyName + " -> " + this.primaryKeyName + ")";
            }
            case 20: 
        }
        return this.primaryKeyField + " <- " + this.foreignKeyTable + "." + this.foreignKeyField + " | (" + this.primaryKeyName + " <- " + this.foreignKeyName + ")";
    }

    public String getSimpleDescription() {
        switch (this.type) {
            default: {
                return this.foreignKeyField + " -> " + this.primaryKeyTable + "." + this.primaryKeyField;
            }
            case 20: 
        }
        return this.primaryKeyField + " <- " + this.foreignKeyTable + "." + this.foreignKeyField;
    }

    public String getDetailedDescription() {
        switch (this.type) {
            default: {
                return this.foreignKeyName + " -> " + this.primaryKeyName;
            }
            case 20: 
        }
        return this.primaryKeyName + " <- " + this.foreignKeyName;
    }

    public String getPrimaryKeyTable() {
        return this.primaryKeyTable;
    }

    public void setPrimaryKeyTable(String primaryKeyTable) {
        this.primaryKeyTable = primaryKeyTable;
    }

    public String getPrimaryKeyField() {
        return this.primaryKeyField;
    }

    public void setPrimaryKeyField(String primaryKeyField) {
        this.primaryKeyField = primaryKeyField;
    }

    public String getForeignKeyTable() {
        return this.foreignKeyTable;
    }

    public void setForeignKeyTable(String foreignKeyTable) {
        this.foreignKeyTable = foreignKeyTable;
    }

    public String getForeignKeyField() {
        return this.foreignKeyField;
    }

    public void setForeignKeyField(String foreignKeyField) {
        this.foreignKeyField = foreignKeyField;
    }

    public String getKeySequence() {
        return this.keySequence;
    }

    public void setKeySequence(String keySequence) {
        this.keySequence = keySequence;
    }

    public String getPrimaryKeyName() {
        return this.primaryKeyName;
    }

    public void setPrimaryKeyName(String primaryKeyName) {
        this.primaryKeyName = primaryKeyName;
    }

    public String getForeignKeyName() {
        return this.foreignKeyName;
    }

    public void setForeignKeyName(String foreignKeyName) {
        this.foreignKeyName = foreignKeyName;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }
}

